package com.google.javascript.jscomp.modules;

import com.google.common.collect.ImmutableMap;
import com.google.javascript.jscomp.deps.ModuleLoader;
import javax.annotation.processing.Generated;
import org.jspecify.annotations.Nullable;

@Generated("com.google.auto.value.processor.AutoBuilderProcessor")
class AutoBuilder_Module_Builder extends Module.Builder {

  private ModuleMetadataMap.@Nullable ModuleMetadata metadata;

  private ModuleLoader.ModulePath path;

  private @Nullable ImmutableMap<String, Binding> namespace;

  private @Nullable ImmutableMap<String, Binding> boundNames;

  private @Nullable ImmutableMap<String, Export> localNameToLocalExport;

  private String closureNamespace;

  AutoBuilder_Module_Builder() {
  }

  AutoBuilder_Module_Builder(Module source) {
    this.metadata = source.metadata();
    this.path = source.path();
    this.namespace = source.namespace();
    this.boundNames = source.boundNames();
    this.localNameToLocalExport = source.localNameToLocalExport();
    this.closureNamespace = source.closureNamespace();
  }

  @Override
  public Module.Builder metadata(ModuleMetadataMap.ModuleMetadata metadata) {
    if (metadata == null) {
      throw new NullPointerException("Null metadata");
    }
    this.metadata = metadata;
    return this;
  }

  @Override
  public Module.Builder path(ModuleLoader.@Nullable ModulePath path) {
    this.path = path;
    return this;
  }

  @Override
  public Module.Builder namespace(ImmutableMap<String, Binding> namespace) {
    if (namespace == null) {
      throw new NullPointerException("Null namespace");
    }
    this.namespace = namespace;
    return this;
  }

  @Override
  public Module.Builder boundNames(ImmutableMap<String, Binding> boundNames) {
    if (boundNames == null) {
      throw new NullPointerException("Null boundNames");
    }
    this.boundNames = boundNames;
    return this;
  }

  @Override
  public Module.Builder localNameToLocalExport(ImmutableMap<String, Export> localNameToLocalExport) {
    if (localNameToLocalExport == null) {
      throw new NullPointerException("Null localNameToLocalExport");
    }
    this.localNameToLocalExport = localNameToLocalExport;
    return this;
  }

  @Override
  public Module.Builder closureNamespace(@Nullable String closureNamespace) {
    this.closureNamespace = closureNamespace;
    return this;
  }

  @Override
  public Module build() {
    if (this.metadata == null
        || this.namespace == null
        || this.boundNames == null
        || this.localNameToLocalExport == null) {
      StringBuilder missing = new StringBuilder();
      if (this.metadata == null) {
        missing.append(" metadata");
      }
      if (this.namespace == null) {
        missing.append(" namespace");
      }
      if (this.boundNames == null) {
        missing.append(" boundNames");
      }
      if (this.localNameToLocalExport == null) {
        missing.append(" localNameToLocalExport");
      }
      throw new IllegalStateException("Missing required properties:" + missing);
    }
    return new Module(
        this.metadata,
        this.path,
        this.namespace,
        this.boundNames,
        this.localNameToLocalExport,
        this.closureNamespace);
  }
}
