/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.counter.data;

import com.itextpdf.kernel.counter.data.EventData;
import com.itextpdf.kernel.counter.data.IEventDataCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class EventDataCacheComparatorBased<T, V extends EventData<T>>
implements IEventDataCache<T, V> {
    private Map<T, V> map = new HashMap<T, V>();
    private Set<V> orderedCache;

    public EventDataCacheComparatorBased(Comparator<V> comparator) {
        this.orderedCache = new TreeSet<V>(comparator);
    }

    @Override
    public void put(V data) {
        if (data != null) {
            EventData old = (EventData)this.map.put(((EventData)data).getSignature(), data);
            if (old != null) {
                this.orderedCache.remove(old);
                ((EventData)data).mergeWith(old);
                this.orderedCache.add(data);
            } else {
                this.orderedCache.add(data);
            }
        }
    }

    @Override
    public V retrieveNext() {
        for (EventData data : this.orderedCache) {
            if (data == null) continue;
            this.map.remove(data.getSignature());
            this.orderedCache.remove(data);
            return (V)data;
        }
        return null;
    }

    @Override
    public List<V> clear() {
        ArrayList<V> result = new ArrayList<V>(this.map.values());
        this.map.clear();
        this.orderedCache.clear();
        return result;
    }
}

