/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.NumberUtil;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.AffineTransform;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.action.PdfAction;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.extgstate.PdfExtGState;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontCharacteristics;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.PositionedLayoutContext;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.BackgroundImage;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.BorderRadius;
import com.itextpdf.layout.property.BoxSizingPropertyValue;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.Property;
import com.itextpdf.layout.property.Transform;
import com.itextpdf.layout.property.TransparentColor;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.DivRenderer;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.RootRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRenderer
implements IRenderer {
    protected static final float EPS = 1.0E-4f;
    protected static final float INF = 1000000.0f;
    protected List<IRenderer> childRenderers = new ArrayList<IRenderer>();
    protected List<IRenderer> positionedRenderers = new ArrayList<IRenderer>();
    protected IPropertyContainer modelElement;
    protected boolean flushed = false;
    protected LayoutArea occupiedArea;
    protected IRenderer parent;
    protected Map<Integer, Object> properties = new HashMap<Integer, Object>();
    protected boolean isLastRendererForModelElement = true;

    protected AbstractRenderer() {
    }

    protected AbstractRenderer(IElement modelElement) {
        this.modelElement = modelElement;
    }

    protected AbstractRenderer(AbstractRenderer other) {
        this.childRenderers = other.childRenderers;
        this.positionedRenderers = other.positionedRenderers;
        this.modelElement = other.modelElement;
        this.flushed = other.flushed;
        this.occupiedArea = other.occupiedArea != null ? other.occupiedArea.clone() : null;
        this.parent = other.parent;
        this.properties.putAll(other.properties);
        this.isLastRendererForModelElement = other.isLastRendererForModelElement;
    }

    @Override
    public void addChild(IRenderer renderer) {
        Integer positioning = (Integer)renderer.getProperty(52);
        if (positioning == null || positioning == 2 || positioning == 1) {
            this.childRenderers.add(renderer);
        } else if (positioning == 4) {
            AbstractRenderer root = this;
            while (root.parent instanceof AbstractRenderer) {
                root = (AbstractRenderer)root.parent;
            }
            if (root == this) {
                this.positionedRenderers.add(renderer);
            } else {
                root.addChild(renderer);
            }
        } else if (positioning == 3) {
            IRenderer parent;
            AbstractRenderer positionedParent = this;
            boolean noPositionInfo = AbstractRenderer.noAbsolutePositionInfo(renderer);
            while (!positionedParent.isPositioned() && !noPositionInfo && (parent = positionedParent.parent) instanceof AbstractRenderer) {
                positionedParent = (AbstractRenderer)parent;
            }
            if (positionedParent == this) {
                this.positionedRenderers.add(renderer);
            } else {
                positionedParent.addChild(renderer);
            }
        }
        if (renderer instanceof AbstractRenderer && !((AbstractRenderer)renderer).isPositioned() && ((AbstractRenderer)renderer).positionedRenderers.size() > 0) {
            int pos = 0;
            List<IRenderer> childPositionedRenderers = ((AbstractRenderer)renderer).positionedRenderers;
            while (pos < childPositionedRenderers.size()) {
                if (AbstractRenderer.noAbsolutePositionInfo(childPositionedRenderers.get(pos))) {
                    ++pos;
                    continue;
                }
                this.positionedRenderers.add(childPositionedRenderers.get(pos));
                childPositionedRenderers.remove(pos);
            }
        }
    }

    @Override
    public IPropertyContainer getModelElement() {
        return this.modelElement;
    }

    @Override
    public List<IRenderer> getChildRenderers() {
        return this.childRenderers;
    }

    @Override
    public boolean hasProperty(int property) {
        return this.hasOwnProperty(property) || this.modelElement != null && this.modelElement.hasProperty(property) || this.parent != null && Property.isPropertyInherited(property) && this.parent.hasProperty(property);
    }

    @Override
    public boolean hasOwnProperty(int property) {
        return this.properties.containsKey(property);
    }

    public boolean hasOwnOrModelProperty(int property) {
        return AbstractRenderer.hasOwnOrModelProperty(this, property);
    }

    @Override
    public void deleteOwnProperty(int property) {
        this.properties.remove(property);
    }

    public void deleteProperty(int property) {
        if (this.properties.containsKey(property)) {
            this.properties.remove(property);
        } else if (this.modelElement != null) {
            this.modelElement.deleteOwnProperty(property);
        }
    }

    @Override
    public <T1> T1 getProperty(int key) {
        Object property = this.properties.get(key);
        if (property != null || this.properties.containsKey(key)) {
            return (T1)property;
        }
        if (this.modelElement != null && ((property = this.modelElement.getProperty(key)) != null || this.modelElement.hasProperty(key))) {
            return (T1)property;
        }
        if (this.parent != null && Property.isPropertyInherited(key) && (property = this.parent.getProperty(key)) != null) {
            return (T1)property;
        }
        property = this.getDefaultProperty(key);
        if (property != null) {
            return (T1)property;
        }
        return this.modelElement != null ? (T1)this.modelElement.getDefaultProperty(key) : null;
    }

    @Override
    public <T1> T1 getOwnProperty(int property) {
        return (T1)this.properties.get(property);
    }

    @Override
    public <T1> T1 getProperty(int property, T1 defaultValue) {
        T1 result = this.getProperty(property);
        return result != null ? result : defaultValue;
    }

    @Override
    public void setProperty(int property, Object value) {
        this.properties.put(property, value);
    }

    @Override
    public <T1> T1 getDefaultProperty(int property) {
        return null;
    }

    public PdfFont getPropertyAsFont(int property) {
        return (PdfFont)this.getProperty(property);
    }

    public Color getPropertyAsColor(int property) {
        return (Color)this.getProperty(property);
    }

    public TransparentColor getPropertyAsTransparentColor(int property) {
        return (TransparentColor)this.getProperty(property);
    }

    public Float getPropertyAsFloat(int property) {
        return NumberUtil.asFloat(this.getProperty(property));
    }

    public Float getPropertyAsFloat(int property, Float defaultValue) {
        return NumberUtil.asFloat((Object)this.getProperty(property, defaultValue));
    }

    public Boolean getPropertyAsBoolean(int property) {
        return (Boolean)this.getProperty(property);
    }

    public UnitValue getPropertyAsUnitValue(int property) {
        return (UnitValue)this.getProperty(property);
    }

    public Integer getPropertyAsInteger(int property) {
        return NumberUtil.asInteger(this.getProperty(property));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    @Override
    public LayoutArea getOccupiedArea() {
        return this.occupiedArea;
    }

    @Override
    public void draw(DrawContext drawContext) {
        this.applyDestinationsAndAnnotation(drawContext);
        boolean relativePosition = this.isRelativePosition();
        if (relativePosition) {
            this.applyRelativePositioningTranslation(false);
        }
        this.beginElementOpacityApplying(drawContext);
        this.drawBackground(drawContext);
        this.drawBorder(drawContext);
        this.drawChildren(drawContext);
        this.drawPositionedChildren(drawContext);
        this.endElementOpacityApplying(drawContext);
        if (relativePosition) {
            this.applyRelativePositioningTranslation(true);
        }
        this.flushed = true;
    }

    protected void beginElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            PdfExtGState extGState = new PdfExtGState();
            extGState.setStrokeOpacity(opacity.floatValue()).setFillOpacity(opacity.floatValue());
            drawContext.getCanvas().saveState().setExtGState(extGState);
        }
    }

    protected void endElementOpacityApplying(DrawContext drawContext) {
        Float opacity = this.getPropertyAsFloat(92);
        if (opacity != null && opacity.floatValue() < 1.0f) {
            drawContext.getCanvas().restoreState();
        }
    }

    public void drawBackground(DrawContext drawContext) {
        Background background = (Background)this.getProperty(6);
        BackgroundImage backgroundImage = (BackgroundImage)this.getProperty(90);
        if (background != null || backgroundImage != null) {
            Rectangle backgroundArea;
            Rectangle bBox = this.getOccupiedAreaBBox();
            boolean isTagged = drawContext.isTaggingEnabled();
            if (isTagged) {
                drawContext.getCanvas().openTag((CanvasTag)new CanvasArtifact());
            }
            if ((backgroundArea = this.applyMargins(bBox, false)).getWidth() <= 0.0f || backgroundArea.getHeight() <= 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.warn(MessageFormatUtil.format((String)"The {0} rectangle has negative or zero sizes. It will not be displayed.", (Object[])new Object[]{"background"}));
            } else {
                boolean backgroundAreaIsClipped = false;
                if (background != null) {
                    backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, backgroundArea);
                    TransparentColor backgroundColor = new TransparentColor(background.getColor(), background.getOpacity());
                    drawContext.getCanvas().saveState().setFillColor(backgroundColor.getColor());
                    backgroundColor.applyFillTransparency(drawContext.getCanvas());
                    drawContext.getCanvas().rectangle((double)(backgroundArea.getX() - background.getExtraLeft()), (double)(backgroundArea.getY() - background.getExtraBottom()), (double)(backgroundArea.getWidth() + background.getExtraLeft() + background.getExtraRight()), (double)(backgroundArea.getHeight() + background.getExtraTop() + background.getExtraBottom())).fill().restoreState();
                }
                if (backgroundImage != null && backgroundImage.getImage() != null) {
                    if (!backgroundAreaIsClipped) {
                        backgroundAreaIsClipped = this.clipBackgroundArea(drawContext, backgroundArea);
                    }
                    this.applyBorderBox(backgroundArea, false);
                    Rectangle imageRectangle = new Rectangle(backgroundArea.getX(), backgroundArea.getTop() - backgroundImage.getImage().getHeight(), backgroundImage.getImage().getWidth(), backgroundImage.getImage().getHeight());
                    if (imageRectangle.getWidth() <= 0.0f || imageRectangle.getHeight() <= 0.0f) {
                        Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                        logger.warn(MessageFormatUtil.format((String)"The {0} rectangle has negative or zero sizes. It will not be displayed.", (Object[])new Object[]{"background-image"}));
                    } else {
                        this.applyBorderBox(backgroundArea, true);
                        drawContext.getCanvas().saveState().rectangle(backgroundArea).clip().newPath();
                        float initialX = backgroundImage.isRepeatX() ? imageRectangle.getX() - imageRectangle.getWidth() : imageRectangle.getX();
                        float initialY = backgroundImage.isRepeatY() ? imageRectangle.getTop() : imageRectangle.getY();
                        imageRectangle.setY(initialY);
                        do {
                            imageRectangle.setX(initialX);
                            do {
                                drawContext.getCanvas().addXObject((PdfXObject)backgroundImage.getImage(), imageRectangle);
                                imageRectangle.moveRight(imageRectangle.getWidth());
                            } while (backgroundImage.isRepeatX() && imageRectangle.getLeft() < backgroundArea.getRight());
                            imageRectangle.moveDown(imageRectangle.getHeight());
                        } while (backgroundImage.isRepeatY() && imageRectangle.getTop() > backgroundArea.getBottom());
                        drawContext.getCanvas().restoreState();
                    }
                }
                if (backgroundAreaIsClipped) {
                    drawContext.getCanvas().restoreState();
                }
            }
            if (isTagged) {
                drawContext.getCanvas().closeTag();
            }
        }
    }

    protected boolean clipBorderArea(DrawContext drawContext, Rectangle outerBorderBox) {
        double curv = 0.4477f;
        float top = outerBorderBox.getTop();
        float right = outerBorderBox.getRight();
        float bottom = outerBorderBox.getBottom();
        float left = outerBorderBox.getLeft();
        boolean hasNotNullRadius = false;
        BorderRadius[] borderRadii = this.getBorderRadii();
        float[] verticalRadii = this.calculateRadii(borderRadii, outerBorderBox, false);
        float[] horizontalRadii = this.calculateRadii(borderRadii, outerBorderBox, true);
        for (int i = 0; i < 4; ++i) {
            verticalRadii[i] = Math.min(verticalRadii[i], outerBorderBox.getHeight() / 2.0f);
            horizontalRadii[i] = Math.min(horizontalRadii[i], outerBorderBox.getWidth() / 2.0f);
            if (hasNotNullRadius || 0.0f == verticalRadii[i] && 0.0f == horizontalRadii[i]) continue;
            hasNotNullRadius = true;
        }
        if (hasNotNullRadius) {
            float x1 = left + horizontalRadii[0];
            float y1 = top - verticalRadii[0];
            float x2 = right - horizontalRadii[1];
            float y2 = top - verticalRadii[1];
            float x3 = right - horizontalRadii[2];
            float y3 = bottom + verticalRadii[2];
            float x4 = left + horizontalRadii[3];
            float y4 = bottom + verticalRadii[3];
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.saveState();
            if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
                canvas.moveTo((double)left, (double)bottom).lineTo((double)left, (double)y1).curveTo((double)left, (double)y1 + (double)verticalRadii[0] * (double)0.4477f, (double)x1 - (double)horizontalRadii[0] * (double)0.4477f, (double)top, (double)x1, (double)top).lineTo((double)right, (double)top).lineTo((double)right, (double)bottom).lineTo((double)left, (double)bottom);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
                canvas.moveTo((double)left, (double)top).lineTo((double)x2, (double)top).curveTo((double)x2 + (double)horizontalRadii[1] * (double)0.4477f, (double)top, (double)right, (double)y2 + (double)verticalRadii[1] * (double)0.4477f, (double)right, (double)y2).lineTo((double)right, (double)bottom).lineTo((double)left, (double)bottom).lineTo((double)left, (double)top);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
                canvas.moveTo((double)right, (double)top).lineTo((double)right, (double)y3).curveTo((double)right, (double)y3 - (double)verticalRadii[2] * (double)0.4477f, (double)x3 + (double)horizontalRadii[2] * (double)0.4477f, (double)bottom, (double)x3, (double)bottom).lineTo((double)left, (double)bottom).lineTo((double)left, (double)top).lineTo((double)right, (double)top);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
                canvas.moveTo((double)right, (double)bottom).lineTo((double)x4, (double)bottom).curveTo((double)x4 - (double)horizontalRadii[3] * (double)0.4477f, (double)bottom, (double)left, (double)y4 - (double)verticalRadii[3] * (double)0.4477f, (double)left, (double)y4).lineTo((double)left, (double)top).lineTo((double)right, (double)top).lineTo((double)right, (double)bottom);
                canvas.clip().newPath();
            }
            Border[] borders = this.getBorders();
            float topBorderWidth = 0.0f;
            float rightBorderWidth = 0.0f;
            float bottomBorderWidth = 0.0f;
            float leftBorderWidth = 0.0f;
            if (borders[0] != null) {
                topBorderWidth = borders[0].getWidth();
                if (y2 > (top -= borders[0].getWidth())) {
                    y2 = top;
                }
                if (y1 > top) {
                    y1 = top;
                }
                verticalRadii[0] = Math.max(0.0f, verticalRadii[0] - borders[0].getWidth());
                verticalRadii[1] = Math.max(0.0f, verticalRadii[1] - borders[0].getWidth());
            }
            if (borders[1] != null) {
                rightBorderWidth = borders[1].getWidth();
                if (x2 > (right -= borders[1].getWidth())) {
                    x2 = right;
                }
                if (x3 > right) {
                    x3 = right;
                }
                horizontalRadii[1] = Math.max(0.0f, horizontalRadii[1] - borders[1].getWidth());
                horizontalRadii[2] = Math.max(0.0f, horizontalRadii[2] - borders[1].getWidth());
            }
            if (borders[2] != null) {
                bottomBorderWidth = borders[2].getWidth();
                if (y3 < (bottom += borders[2].getWidth())) {
                    y3 = top;
                }
                if (y4 < bottom) {
                    y4 = bottom;
                }
                verticalRadii[2] = Math.max(0.0f, verticalRadii[2] - borders[2].getWidth());
                verticalRadii[3] = Math.max(0.0f, verticalRadii[3] - borders[2].getWidth());
            }
            if (borders[3] != null) {
                leftBorderWidth = borders[3].getWidth();
                if (x4 < (left += borders[3].getWidth())) {
                    x4 = left;
                }
                if (x1 < left) {
                    x1 = left;
                }
                horizontalRadii[3] = Math.max(0.0f, horizontalRadii[3] - borders[3].getWidth());
                horizontalRadii[0] = Math.max(0.0f, horizontalRadii[0] - borders[3].getWidth());
            }
            if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
                canvas.moveTo((double)left, (double)y1).curveTo((double)left, (double)y1 + (double)verticalRadii[0] * (double)0.4477f, (double)x1 - (double)horizontalRadii[0] * (double)0.4477f, (double)top, (double)x1, (double)top).lineTo((double)x2, (double)top).lineTo((double)right, (double)y2).lineTo((double)right, (double)y3).lineTo((double)x3, (double)bottom).lineTo((double)x4, (double)bottom).lineTo((double)left, (double)y4).lineTo((double)left, (double)y1).lineTo((double)(left - leftBorderWidth), (double)y1).lineTo((double)(left - leftBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)y1);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
                canvas.moveTo((double)x2, (double)top).curveTo((double)x2 + (double)horizontalRadii[1] * (double)0.4477f, (double)top, (double)right, (double)y2 + (double)verticalRadii[1] * (double)0.4477f, (double)right, (double)y2).lineTo((double)right, (double)y3).lineTo((double)x3, (double)bottom).lineTo((double)x4, (double)bottom).lineTo((double)left, (double)y4).lineTo((double)left, (double)y1).lineTo((double)x1, (double)top).lineTo((double)x2, (double)top).lineTo((double)x2, (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(top + topBorderWidth)).lineTo((double)x2, (double)(top + topBorderWidth));
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
                canvas.moveTo((double)right, (double)y3).curveTo((double)right, (double)y3 - (double)verticalRadii[2] * (double)0.4477f, (double)x3 + (double)horizontalRadii[2] * (double)0.4477f, (double)bottom, (double)x3, (double)bottom).lineTo((double)x4, (double)bottom).lineTo((double)left, (double)y4).lineTo((double)left, (double)y1).lineTo((double)x1, (double)top).lineTo((double)x2, (double)top).lineTo((double)right, (double)y2).lineTo((double)right, (double)y3).lineTo((double)(right + rightBorderWidth), (double)y3).lineTo((double)(right + rightBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)y3);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
                canvas.moveTo((double)x4, (double)bottom).curveTo((double)x4 - (double)horizontalRadii[3] * (double)0.4477f, (double)bottom, (double)left, (double)y4 - (double)verticalRadii[3] * (double)0.4477f, (double)left, (double)y4).lineTo((double)left, (double)y1).lineTo((double)x1, (double)top).lineTo((double)x2, (double)top).lineTo((double)right, (double)y2).lineTo((double)right, (double)y3).lineTo((double)x3, (double)bottom).lineTo((double)x4, (double)bottom).lineTo((double)x4, (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)(right + rightBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(top + topBorderWidth)).lineTo((double)(left - leftBorderWidth), (double)(bottom - bottomBorderWidth)).lineTo((double)x4, (double)(bottom - bottomBorderWidth));
                canvas.clip().newPath();
            }
        }
        return hasNotNullRadius;
    }

    protected boolean clipBackgroundArea(DrawContext drawContext, Rectangle outerBorderBox) {
        double curv = 0.4477f;
        float top = outerBorderBox.getTop();
        float right = outerBorderBox.getRight();
        float bottom = outerBorderBox.getBottom();
        float left = outerBorderBox.getLeft();
        boolean hasNotNullRadius = false;
        BorderRadius[] borderRadii = this.getBorderRadii();
        float[] verticalRadii = this.calculateRadii(borderRadii, outerBorderBox, false);
        float[] horizontalRadii = this.calculateRadii(borderRadii, outerBorderBox, true);
        for (int i = 0; i < 4; ++i) {
            verticalRadii[i] = Math.min(verticalRadii[i], outerBorderBox.getHeight() / 2.0f);
            horizontalRadii[i] = Math.min(horizontalRadii[i], outerBorderBox.getWidth() / 2.0f);
            if (hasNotNullRadius || 0.0f == verticalRadii[i] && 0.0f == horizontalRadii[i]) continue;
            hasNotNullRadius = true;
        }
        if (hasNotNullRadius) {
            float x1 = left + horizontalRadii[0];
            float y1 = top - verticalRadii[0];
            float x2 = right - horizontalRadii[1];
            float y2 = top - verticalRadii[1];
            float x3 = right - horizontalRadii[2];
            float y3 = bottom + verticalRadii[2];
            float x4 = left + horizontalRadii[3];
            float y4 = bottom + verticalRadii[3];
            PdfCanvas canvas = drawContext.getCanvas();
            canvas.saveState();
            if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
                canvas.moveTo((double)left, (double)bottom).lineTo((double)left, (double)y1).curveTo((double)left, (double)y1 + (double)verticalRadii[0] * (double)0.4477f, (double)x1 - (double)horizontalRadii[0] * (double)0.4477f, (double)top, (double)x1, (double)top).lineTo((double)right, (double)top).lineTo((double)right, (double)bottom).lineTo((double)left, (double)bottom);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
                canvas.moveTo((double)left, (double)top).lineTo((double)x2, (double)top).curveTo((double)x2 + (double)horizontalRadii[1] * (double)0.4477f, (double)top, (double)right, (double)y2 + (double)verticalRadii[1] * (double)0.4477f, (double)right, (double)y2).lineTo((double)right, (double)bottom).lineTo((double)left, (double)bottom).lineTo((double)left, (double)top);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
                canvas.moveTo((double)right, (double)top).lineTo((double)right, (double)y3).curveTo((double)right, (double)y3 - (double)verticalRadii[2] * (double)0.4477f, (double)x3 + (double)horizontalRadii[2] * (double)0.4477f, (double)bottom, (double)x3, (double)bottom).lineTo((double)left, (double)bottom).lineTo((double)left, (double)top).lineTo((double)right, (double)top);
                canvas.clip().newPath();
            }
            if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
                canvas.moveTo((double)right, (double)bottom).lineTo((double)x4, (double)bottom).curveTo((double)x4 - (double)horizontalRadii[3] * (double)0.4477f, (double)bottom, (double)left, (double)y4 - (double)verticalRadii[3] * (double)0.4477f, (double)left, (double)y4).lineTo((double)left, (double)top).lineTo((double)right, (double)top).lineTo((double)right, (double)bottom);
                canvas.clip().newPath();
            }
        }
        return hasNotNullRadius;
    }

    public void drawChildren(DrawContext drawContext) {
        ArrayList<IRenderer> waitingRenderers = new ArrayList<IRenderer>();
        for (IRenderer child : this.childRenderers) {
            Transform transformProp = (Transform)child.getProperty(53);
            RootRenderer rootRenderer = this.getRootRenderer();
            ArrayList<IRenderer> waiting = rootRenderer != null && !rootRenderer.waitingDrawingElements.contains(child) ? rootRenderer.waitingDrawingElements : waitingRenderers;
            AbstractRenderer.processWaitingDrawing(child, transformProp, waiting);
            if (FloatingHelper.isRendererFloating(child) || transformProp != null) continue;
            child.draw(drawContext);
        }
        for (IRenderer waitingRenderer : waitingRenderers) {
            waitingRenderer.draw(drawContext);
        }
    }

    public void drawBorder(DrawContext drawContext) {
        Border[] borders = this.getBorders();
        boolean gotBorders = false;
        for (Border border : borders) {
            gotBorders = gotBorders || border != null;
        }
        if (gotBorders) {
            float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
            float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
            float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
            float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
            Rectangle bBox = this.getBorderAreaBBox();
            if (bBox.getWidth() < 0.0f || bBox.getHeight() < 0.0f) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format((String)"The {0} rectangle has negative size. It will not be displayed.", (Object[])new Object[]{"border"}));
                return;
            }
            float x1 = bBox.getX();
            float y1 = bBox.getY();
            float x2 = bBox.getX() + bBox.getWidth();
            float y2 = bBox.getY() + bBox.getHeight();
            boolean isTagged = drawContext.isTaggingEnabled();
            PdfCanvas canvas = drawContext.getCanvas();
            if (isTagged) {
                canvas.openTag((CanvasTag)new CanvasArtifact());
            }
            Rectangle borderRect = this.applyMargins(this.occupiedArea.getBBox().clone(), this.getMargins(), false);
            boolean isAreaClipped = this.clipBorderArea(drawContext, borderRect);
            BorderRadius[] borderRadii = this.getBorderRadii();
            float[] verticalRadii = this.calculateRadii(borderRadii, borderRect, false);
            float[] horizontalRadii = this.calculateRadii(borderRadii, borderRect, true);
            if (borders[0] != null) {
                if (0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0] || 0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1]) {
                    borders[0].draw(canvas, x1, y2, x2, y2, horizontalRadii[0], verticalRadii[0], horizontalRadii[1], verticalRadii[1], Border.Side.TOP, leftWidth, rightWidth);
                } else {
                    borders[0].draw(canvas, x1, y2, x2, y2, Border.Side.TOP, leftWidth, rightWidth);
                }
            }
            if (borders[1] != null) {
                if (0.0f != horizontalRadii[1] || 0.0f != verticalRadii[1] || 0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2]) {
                    borders[1].draw(canvas, x2, y2, x2, y1, horizontalRadii[1], verticalRadii[1], horizontalRadii[2], verticalRadii[2], Border.Side.RIGHT, topWidth, bottomWidth);
                } else {
                    borders[1].draw(canvas, x2, y2, x2, y1, Border.Side.RIGHT, topWidth, bottomWidth);
                }
            }
            if (borders[2] != null) {
                if (0.0f != horizontalRadii[2] || 0.0f != verticalRadii[2] || 0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3]) {
                    borders[2].draw(canvas, x2, y1, x1, y1, horizontalRadii[2], verticalRadii[2], horizontalRadii[3], verticalRadii[3], Border.Side.BOTTOM, rightWidth, leftWidth);
                } else {
                    borders[2].draw(canvas, x2, y1, x1, y1, Border.Side.BOTTOM, rightWidth, leftWidth);
                }
            }
            if (borders[3] != null) {
                if (0.0f != horizontalRadii[3] || 0.0f != verticalRadii[3] || 0.0f != horizontalRadii[0] || 0.0f != verticalRadii[0]) {
                    borders[3].draw(canvas, x1, y1, x1, y2, horizontalRadii[3], verticalRadii[3], horizontalRadii[0], verticalRadii[0], Border.Side.LEFT, bottomWidth, topWidth);
                } else {
                    borders[3].draw(canvas, x1, y1, x1, y2, Border.Side.LEFT, bottomWidth, topWidth);
                }
            }
            if (isAreaClipped) {
                drawContext.getCanvas().restoreState();
            }
            if (isTagged) {
                canvas.closeTag();
            }
        }
    }

    @Override
    public boolean isFlushed() {
        return this.flushed;
    }

    @Override
    public IRenderer setParent(IRenderer parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public IRenderer getParent() {
        return this.parent;
    }

    @Override
    public void move(float dxRight, float dyUp) {
        this.occupiedArea.getBBox().moveRight(dxRight);
        this.occupiedArea.getBBox().moveUp(dyUp);
        for (IRenderer childRenderer : this.childRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
        for (IRenderer childRenderer : this.positionedRenderers) {
            childRenderer.move(dxRight, dyUp);
        }
    }

    public List<Rectangle> initElementAreas(LayoutArea area) {
        return Collections.singletonList(area.getBBox());
    }

    public Rectangle getOccupiedAreaBBox() {
        return this.occupiedArea.getBBox().clone();
    }

    public Rectangle getBorderAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        return rect;
    }

    public Rectangle getInnerAreaBBox() {
        Rectangle rect = this.getOccupiedAreaBBox();
        this.applyMargins(rect, false);
        this.applyBorderBox(rect, false);
        this.applyPaddings(rect, false);
        return rect;
    }

    protected void applyDestinationsAndAnnotation(DrawContext drawContext) {
        this.applyDestination(drawContext.getDocument());
        this.applyAction(drawContext.getDocument());
        this.applyLinkAnnotation(drawContext.getDocument());
    }

    static boolean isBorderBoxSizing(IRenderer renderer) {
        BoxSizingPropertyValue boxSizing = (BoxSizingPropertyValue)((Object)renderer.getProperty(105));
        return boxSizing != null && boxSizing.equals((Object)BoxSizingPropertyValue.BORDER_BOX);
    }

    static void processWaitingDrawing(IRenderer child, Transform transformProp, List<IRenderer> waitingDrawing) {
        Border outlineProp;
        if (FloatingHelper.isRendererFloating(child) || transformProp != null) {
            waitingDrawing.add(child);
        }
        if ((outlineProp = (Border)child.getProperty(106)) != null && child instanceof AbstractRenderer) {
            AbstractRenderer abstractChild = (AbstractRenderer)child;
            if (abstractChild.isRelativePosition()) {
                abstractChild.applyRelativePositioningTranslation(false);
            }
            Div outlines = new Div();
            outlines.getAccessibilityProperties().setRole(null);
            if (transformProp != null) {
                outlines.setProperty(53, transformProp);
            }
            outlines.setProperty(9, outlineProp);
            float offset = ((Border)outlines.getProperty(9)).getWidth();
            if (abstractChild.getPropertyAsFloat(107) != null) {
                offset += abstractChild.getPropertyAsFloat(107).floatValue();
            }
            DivRenderer div = new DivRenderer(outlines);
            div.setParent(abstractChild.getParent());
            Rectangle divOccupiedArea = abstractChild.applyMargins(abstractChild.occupiedArea.clone().getBBox(), false).moveLeft(offset).moveDown(offset);
            divOccupiedArea.setWidth(divOccupiedArea.getWidth() + 2.0f * offset).setHeight(divOccupiedArea.getHeight() + 2.0f * offset);
            div.occupiedArea = new LayoutArea(abstractChild.getOccupiedArea().getPageNumber(), divOccupiedArea);
            float outlineWidth = ((Border)div.getProperty(9)).getWidth();
            if (divOccupiedArea.getWidth() >= outlineWidth * 2.0f && divOccupiedArea.getHeight() >= outlineWidth * 2.0f) {
                waitingDrawing.add(div);
            }
            if (abstractChild.isRelativePosition()) {
                abstractChild.applyRelativePositioningTranslation(true);
            }
        }
    }

    protected Float retrieveWidth(float parentBoxWidth) {
        Float width;
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 79);
        if (maxWidth != null && minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
            maxWidth = minWidth;
        }
        if ((width = this.retrieveUnitValue(parentBoxWidth, 77)) != null) {
            if (maxWidth != null) {
                Float f = width = width.floatValue() > maxWidth.floatValue() ? maxWidth : width;
            }
            if (minWidth != null) {
                width = width.floatValue() < minWidth.floatValue() ? minWidth : width;
            }
        } else if (maxWidth != null) {
            Float f = width = maxWidth.floatValue() < parentBoxWidth ? maxWidth : null;
        }
        if (width != null && AbstractRenderer.isBorderBoxSizing(this)) {
            width = Float.valueOf(width.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        return width != null ? Float.valueOf(Math.max(0.0f, width.floatValue())) : null;
    }

    protected Float retrieveMaxWidth(float parentBoxWidth) {
        Float maxWidth = this.retrieveUnitValue(parentBoxWidth, 79);
        if (maxWidth != null) {
            Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
            if (minWidth != null && minWidth.floatValue() > maxWidth.floatValue()) {
                maxWidth = minWidth;
            }
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                maxWidth = Float.valueOf(maxWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(maxWidth.floatValue() > 0.0f ? maxWidth.floatValue() : 0.0f);
        }
        return null;
    }

    protected Float retrieveMinWidth(float parentBoxWidth) {
        Float minWidth = this.retrieveUnitValue(parentBoxWidth, 80);
        if (minWidth != null) {
            if (AbstractRenderer.isBorderBoxSizing(this)) {
                minWidth = Float.valueOf(minWidth.floatValue() - AbstractRenderer.calculatePaddingBorderWidth(this));
            }
            return Float.valueOf(minWidth.floatValue() > 0.0f ? minWidth.floatValue() : 0.0f);
        }
        return null;
    }

    void updateWidth(UnitValue updatedWidthValue) {
        if (updatedWidthValue.isPointValue() && AbstractRenderer.isBorderBoxSizing(this)) {
            updatedWidthValue.setValue(updatedWidthValue.getValue() + AbstractRenderer.calculatePaddingBorderWidth(this));
        }
        this.setProperty(77, updatedWidthValue);
    }

    protected Float retrieveHeight() {
        Float height = null;
        UnitValue heightUV = this.getPropertyAsUnitValue(27);
        Float parentResolvedHeight = this.retrieveResolvedParentDeclaredHeight();
        Float minHeight = null;
        Float maxHeight = null;
        if (heightUV != null) {
            if (parentResolvedHeight == null) {
                if (heightUV.isPercentValue()) {
                    height = null;
                } else {
                    UnitValue maxHeightUV;
                    UnitValue minHeightUV = this.getPropertyAsUnitValue(85);
                    if (minHeightUV != null && minHeightUV.isPointValue()) {
                        minHeight = Float.valueOf(minHeightUV.getValue());
                    }
                    if ((maxHeightUV = this.getPropertyAsUnitValue(84)) != null && maxHeightUV.isPointValue()) {
                        maxHeight = Float.valueOf(maxHeightUV.getValue());
                    }
                    height = Float.valueOf(heightUV.getValue());
                }
            } else {
                minHeight = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 85);
                maxHeight = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 84);
                height = this.retrieveUnitValue(parentResolvedHeight.floatValue(), 27);
            }
            if (maxHeight != null && minHeight != null && minHeight.floatValue() > maxHeight.floatValue()) {
                maxHeight = minHeight;
            }
            if (height != null) {
                if (maxHeight != null) {
                    Float f = height = height.floatValue() > maxHeight.floatValue() ? maxHeight : height;
                }
                if (minHeight != null) {
                    Float f = height = height.floatValue() < minHeight.floatValue() ? minHeight : height;
                }
            }
            if (height != null && AbstractRenderer.isBorderBoxSizing(this)) {
                height = Float.valueOf(height.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
            }
        }
        return height != null ? Float.valueOf(Math.max(0.0f, height.floatValue())) : null;
    }

    private float[] calculateRadii(BorderRadius[] radii, Rectangle area, boolean horizontal) {
        float[] results = new float[4];
        for (int i = 0; i < 4; ++i) {
            if (null != radii[i]) {
                UnitValue value;
                UnitValue unitValue = value = horizontal ? radii[i].getHorizontalRadius() : radii[i].getVerticalRadius();
                if (value != null) {
                    if (value.getUnitType() == 2) {
                        results[i] = value.getValue() * (horizontal ? area.getWidth() : area.getHeight()) / 100.0f;
                        continue;
                    }
                    assert (value.getUnitType() == 1);
                    results[i] = value.getValue();
                    continue;
                }
                results[i] = 0.0f;
                continue;
            }
            results[i] = 0.0f;
        }
        return results;
    }

    void updateHeight(UnitValue updatedHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedHeight.isPointValue()) {
            updatedHeight.setValue(updatedHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(27, updatedHeight);
    }

    protected Float retrieveMaxHeight() {
        Float maxHeight = null;
        Float minHeight = null;
        Float directParentDeclaredHeight = this.retrieveDirectParentDeclaredHeight();
        UnitValue maxHeightAsUV = this.getPropertyAsUnitValue(84);
        if (maxHeightAsUV != null) {
            if (directParentDeclaredHeight == null) {
                if (maxHeightAsUV.isPercentValue()) {
                    maxHeight = null;
                } else {
                    minHeight = this.retrieveMinHeight();
                    UnitValue minHeightUV = this.getPropertyAsUnitValue(85);
                    if (minHeightUV != null && minHeightUV.isPointValue()) {
                        minHeight = Float.valueOf(minHeightUV.getValue());
                    }
                    maxHeight = Float.valueOf(maxHeightAsUV.getValue());
                }
            } else {
                maxHeight = this.retrieveUnitValue(directParentDeclaredHeight.floatValue(), 84);
            }
            if (maxHeight != null) {
                if (minHeight != null && minHeight.floatValue() > maxHeight.floatValue()) {
                    maxHeight = minHeight;
                }
                if (AbstractRenderer.isBorderBoxSizing(this)) {
                    maxHeight = Float.valueOf(maxHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
                }
                return Float.valueOf(maxHeight.floatValue() > 0.0f ? maxHeight.floatValue() : 0.0f);
            }
        }
        return this.retrieveHeight();
    }

    void updateMaxHeight(UnitValue updatedMaxHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedMaxHeight.isPointValue()) {
            updatedMaxHeight.setValue(updatedMaxHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(84, updatedMaxHeight);
    }

    protected Float retrieveMinHeight() {
        Float minHeight = null;
        Float directParentDeclaredHeight = this.retrieveDirectParentDeclaredHeight();
        UnitValue minHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 85);
        if (minHeightUV != null) {
            minHeight = directParentDeclaredHeight == null ? (minHeightUV.isPercentValue() ? null : Float.valueOf(minHeightUV.getValue())) : this.retrieveUnitValue(directParentDeclaredHeight.floatValue(), 85);
            if (minHeight != null) {
                if (AbstractRenderer.isBorderBoxSizing(this)) {
                    minHeight = Float.valueOf(minHeight.floatValue() - AbstractRenderer.calculatePaddingBorderHeight(this));
                }
                return Float.valueOf(minHeight.floatValue() > 0.0f ? minHeight.floatValue() : 0.0f);
            }
        }
        return this.retrieveHeight();
    }

    void updateMinHeight(UnitValue updatedMinHeight) {
        if (AbstractRenderer.isBorderBoxSizing(this) && updatedMinHeight.isPointValue()) {
            updatedMinHeight.setValue(updatedMinHeight.getValue() + AbstractRenderer.calculatePaddingBorderHeight(this));
        }
        this.setProperty(85, updatedMinHeight);
    }

    protected Float retrieveUnitValue(float baseValue, int property) {
        return this.retrieveUnitValue(baseValue, property, false);
    }

    protected Float retrieveUnitValue(float baseValue, int property, boolean pointOnly) {
        UnitValue value = (UnitValue)this.getProperty(property);
        if (pointOnly && value.getUnitType() == 1) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{property}));
        }
        if (value != null) {
            if (value.getUnitType() == 2) {
                return Float.valueOf(baseValue * value.getValue() / 100.0f);
            }
            assert (value.getUnitType() == 1);
            return Float.valueOf(value.getValue());
        }
        return null;
    }

    protected Map<Integer, Object> getOwnProperties() {
        return this.properties;
    }

    protected void addAllProperties(Map<Integer, Object> properties) {
        this.properties.putAll(properties);
    }

    protected Float getFirstYLineRecursively() {
        if (this.childRenderers.size() == 0) {
            return null;
        }
        return ((AbstractRenderer)this.childRenderers.get(0)).getFirstYLineRecursively();
    }

    protected Float getLastYLineRecursively() {
        for (int i = this.childRenderers.size() - 1; i >= 0; --i) {
            Float lastYLine;
            IRenderer child = this.childRenderers.get(i);
            if (!(child instanceof AbstractRenderer) || (lastYLine = ((AbstractRenderer)child).getLastYLineRecursively()) == null) continue;
            return lastYLine;
        }
        return null;
    }

    protected Rectangle applyMargins(Rectangle rect, boolean reverse) {
        return this.applyMargins(rect, this.getMargins(), reverse);
    }

    protected Rectangle applyMargins(Rectangle rect, UnitValue[] margins, boolean reverse) {
        Logger logger;
        if (!margins[0].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{46}));
        }
        if (!margins[1].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
        }
        if (!margins[2].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{43}));
        }
        if (!margins[3].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
        }
        return rect.applyMargins(margins[0].getValue(), margins[1].getValue(), margins[2].getValue(), margins[3].getValue(), reverse);
    }

    protected UnitValue[] getMargins() {
        return AbstractRenderer.getMargins(this);
    }

    protected UnitValue[] getPaddings() {
        return AbstractRenderer.getPaddings(this);
    }

    protected Rectangle applyPaddings(Rectangle rect, boolean reverse) {
        return this.applyPaddings(rect, this.getPaddings(), reverse);
    }

    protected Rectangle applyPaddings(Rectangle rect, UnitValue[] paddings, boolean reverse) {
        Logger logger;
        if (!paddings[0].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{50}));
        }
        if (!paddings[1].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{49}));
        }
        if (!paddings[2].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{47}));
        }
        if (!paddings[3].isPointValue()) {
            logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{48}));
        }
        return rect.applyMargins(paddings[0].getValue(), paddings[1].getValue(), paddings[2].getValue(), paddings[3].getValue(), reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, boolean reverse) {
        Border[] borders = this.getBorders();
        return this.applyBorderBox(rect, borders, reverse);
    }

    protected Rectangle applyBorderBox(Rectangle rect, Border[] borders, boolean reverse) {
        float topWidth = borders[0] != null ? borders[0].getWidth() : 0.0f;
        float rightWidth = borders[1] != null ? borders[1].getWidth() : 0.0f;
        float bottomWidth = borders[2] != null ? borders[2].getWidth() : 0.0f;
        float leftWidth = borders[3] != null ? borders[3].getWidth() : 0.0f;
        return rect.applyMargins(topWidth, rightWidth, bottomWidth, leftWidth, reverse);
    }

    protected void applyAbsolutePosition(Rectangle parentRect) {
        Float top = this.getPropertyAsFloat(73);
        Float bottom = this.getPropertyAsFloat(14);
        Float left = this.getPropertyAsFloat(34);
        Float right = this.getPropertyAsFloat(54);
        if (left == null && right == null && BaseDirection.RIGHT_TO_LEFT.equals(this.getProperty(7))) {
            right = Float.valueOf(0.0f);
        }
        if (top == null && bottom == null) {
            top = Float.valueOf(0.0f);
        }
        try {
            if (right != null) {
                this.move(parentRect.getRight() - right.floatValue() - this.occupiedArea.getBBox().getRight(), 0.0f);
            }
            if (left != null) {
                this.move(parentRect.getLeft() + left.floatValue() - this.occupiedArea.getBBox().getLeft(), 0.0f);
            }
            if (top != null) {
                this.move(0.0f, parentRect.getTop() - top.floatValue() - this.occupiedArea.getBBox().getTop());
            }
            if (bottom != null) {
                this.move(0.0f, parentRect.getBottom() + bottom.floatValue() - this.occupiedArea.getBBox().getBottom());
            }
        }
        catch (Exception exc) {
            Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Absolute positioning might be applied incorrectly."}));
        }
    }

    protected void applyRelativePositioningTranslation(boolean reverse) {
        float dyUp;
        float top = this.getPropertyAsFloat(73, Float.valueOf(0.0f)).floatValue();
        float bottom = this.getPropertyAsFloat(14, Float.valueOf(0.0f)).floatValue();
        float left = this.getPropertyAsFloat(34, Float.valueOf(0.0f)).floatValue();
        float right = this.getPropertyAsFloat(54, Float.valueOf(0.0f)).floatValue();
        int reverseMultiplier = reverse ? -1 : 1;
        float dxRight = left != 0.0f ? left * (float)reverseMultiplier : -right * (float)reverseMultiplier;
        float f = dyUp = top != 0.0f ? -top * (float)reverseMultiplier : bottom * (float)reverseMultiplier;
        if (dxRight != 0.0f || dyUp != 0.0f) {
            this.move(dxRight, dyUp);
        }
    }

    protected void applyDestination(PdfDocument document) {
        String destination = (String)this.getProperty(17);
        if (destination != null) {
            PdfArray array = new PdfArray();
            array.add(document.getPage(this.occupiedArea.getPageNumber()).getPdfObject());
            array.add((PdfObject)PdfName.XYZ);
            array.add((PdfObject)new PdfNumber((double)this.occupiedArea.getBBox().getX()));
            array.add((PdfObject)new PdfNumber((double)(this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight())));
            array.add((PdfObject)new PdfNumber(0));
            document.addNamedDestination(destination, array.makeIndirect(document));
            this.deleteProperty(17);
        }
    }

    protected void applyAction(PdfDocument document) {
        PdfAction action = (PdfAction)this.getProperty(1);
        if (action != null) {
            PdfLinkAnnotation link = (PdfLinkAnnotation)this.getProperty(88);
            if (link == null) {
                link = (PdfLinkAnnotation)new PdfLinkAnnotation(new Rectangle(0.0f, 0.0f, 0.0f, 0.0f)).setFlags(4);
                Border border = (Border)this.getProperty(9);
                if (border != null) {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, border.getWidth()}));
                } else {
                    link.setBorder(new PdfArray(new float[]{0.0f, 0.0f, 0.0f}));
                }
                this.setProperty(88, link);
            }
            link.setAction(action);
        }
    }

    protected void applyLinkAnnotation(PdfDocument document) {
        PdfLinkAnnotation linkAnnotation = (PdfLinkAnnotation)this.getProperty(88);
        if (linkAnnotation != null) {
            Rectangle pdfBBox = this.calculateAbsolutePdfBBox();
            if (linkAnnotation.getPage() != null) {
                PdfDictionary oldAnnotation = (PdfDictionary)((PdfDictionary)linkAnnotation.getPdfObject()).clone();
                linkAnnotation = (PdfLinkAnnotation)PdfAnnotation.makeAnnotation((PdfObject)oldAnnotation);
            }
            linkAnnotation.setRectangle(new PdfArray(pdfBBox));
            PdfPage page = document.getPage(this.occupiedArea.getPageNumber());
            page.addAnnotation((PdfAnnotation)linkAnnotation);
        }
    }

    private Float retrieveResolvedParentDeclaredHeight() {
        if (this.parent != null && this.parent.getProperty(27) != null) {
            UnitValue parentHeightUV = AbstractRenderer.getPropertyAsUnitValue(this.parent, 27);
            if (parentHeightUV.isPointValue()) {
                return Float.valueOf(parentHeightUV.getValue());
            }
            return ((AbstractRenderer)this.parent).retrieveHeight();
        }
        return null;
    }

    private Float retrieveDirectParentDeclaredHeight() {
        UnitValue parentHeightUV;
        if (this.parent != null && this.parent.getProperty(27) != null && (parentHeightUV = AbstractRenderer.getPropertyAsUnitValue(this.parent, 27)).isPointValue()) {
            return Float.valueOf(parentHeightUV.getValue());
        }
        return null;
    }

    protected void updateHeightsOnSplit(boolean wasHeightClipped, AbstractRenderer splitRenderer, AbstractRenderer overflowRenderer) {
        Float parentResolvedHeightPropertyValue = this.retrieveResolvedParentDeclaredHeight();
        if (this.hasProperty(84)) {
            UnitValue maxHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 84);
            if (maxHeightUV.isPointValue()) {
                Float maxHeight = this.retrieveMaxHeight();
                UnitValue updateMaxHeight = UnitValue.createPointValue(maxHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
                overflowRenderer.updateMaxHeight(updateMaxHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = this.occupiedArea.getBBox().getHeight() / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = maxHeightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
        if (this.hasProperty(85)) {
            UnitValue minHeightUV = AbstractRenderer.getPropertyAsUnitValue(this, 85);
            if (minHeightUV.isPointValue()) {
                Float minHeight = this.retrieveMinHeight();
                UnitValue updateminHeight = UnitValue.createPointValue(minHeight.floatValue() - this.occupiedArea.getBBox().getHeight());
                overflowRenderer.updateMinHeight(updateminHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = this.occupiedArea.getBBox().getHeight() / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = minHeightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
        if (this.hasProperty(27)) {
            UnitValue heightUV = AbstractRenderer.getPropertyAsUnitValue(this, 27);
            if (heightUV.isPointValue()) {
                Float height = this.retrieveHeight();
                UnitValue updateHeight = UnitValue.createPointValue(height.floatValue() - this.occupiedArea.getBBox().getHeight());
                overflowRenderer.updateHeight(updateHeight);
            } else if (parentResolvedHeightPropertyValue != null) {
                float currentOccupiedFraction = this.occupiedArea.getBBox().getHeight() / parentResolvedHeightPropertyValue.floatValue() * 100.0f;
                float newFraction = heightUV.getValue() - currentOccupiedFraction;
                overflowRenderer.updateMinHeight(UnitValue.createPercentValue(newFraction));
            }
        }
        if (wasHeightClipped) {
            Float maxHeight = this.retrieveMaxHeight();
            Logger logger = LoggerFactory.getLogger(BlockRenderer.class);
            logger.warn("Element content was clipped because some height properties are set.");
            splitRenderer.occupiedArea.getBBox().moveDown(maxHeight.floatValue() - this.occupiedArea.getBBox().getHeight()).setHeight(maxHeight.floatValue());
        }
    }

    protected MinMaxWidth getMinMaxWidth() {
        return MinMaxWidthUtils.countDefaultMinMaxWidth(this);
    }

    protected boolean setMinMaxWidthBasedOnFixedWidth(MinMaxWidth minMaxWidth) {
        Float width;
        if (this.hasAbsoluteUnitValue(77) && (width = this.retrieveWidth(0.0f)) != null) {
            minMaxWidth.setChildrenMaxWidth(width.floatValue());
            minMaxWidth.setChildrenMinWidth(width.floatValue());
            return true;
        }
        return false;
    }

    protected boolean isNotFittingHeight(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getHeight() > layoutArea.getBBox().getHeight();
    }

    protected boolean isNotFittingWidth(LayoutArea layoutArea) {
        return !this.isPositioned() && this.occupiedArea.getBBox().getWidth() > layoutArea.getBBox().getWidth();
    }

    protected boolean isNotFittingLayoutArea(LayoutArea layoutArea) {
        return this.isNotFittingHeight(layoutArea) || this.isNotFittingWidth(layoutArea);
    }

    protected boolean isPositioned() {
        return !this.isStaticLayout();
    }

    protected boolean isFixedLayout() {
        Object positioning = this.getProperty(52);
        return Integer.valueOf(4).equals(positioning);
    }

    protected boolean isStaticLayout() {
        Object positioning = this.getProperty(52);
        return positioning == null || Integer.valueOf(1).equals(positioning);
    }

    protected boolean isRelativePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(2).equals(positioning);
    }

    protected boolean isAbsolutePosition() {
        Integer positioning = this.getPropertyAsInteger(52);
        return Integer.valueOf(3).equals(positioning);
    }

    protected boolean isKeepTogether() {
        return Boolean.TRUE.equals(this.getPropertyAsBoolean(32));
    }

    protected void alignChildHorizontally(IRenderer childRenderer, Rectangle currentArea) {
        float freeSpace;
        float availableWidth = currentArea.getWidth();
        HorizontalAlignment horizontalAlignment = (HorizontalAlignment)((Object)childRenderer.getProperty(28));
        if (horizontalAlignment != null && horizontalAlignment != HorizontalAlignment.LEFT && (freeSpace = availableWidth - childRenderer.getOccupiedArea().getBBox().getWidth()) > 0.0f) {
            try {
                switch (horizontalAlignment) {
                    case RIGHT: {
                        childRenderer.move(freeSpace, 0.0f);
                        break;
                    }
                    case CENTER: {
                        childRenderer.move(freeSpace / 2.0f, 0.0f);
                    }
                }
            }
            catch (NullPointerException e) {
                Logger logger = LoggerFactory.getLogger(AbstractRenderer.class);
                logger.error(MessageFormatUtil.format((String)"Occupied area has not been initialized. {0}", (Object[])new Object[]{"Some of the children might not end up aligned horizontally."}));
            }
        }
    }

    protected Border[] getBorders() {
        return AbstractRenderer.getBorders(this);
    }

    protected BorderRadius[] getBorderRadii() {
        return AbstractRenderer.getBorderRadii(this);
    }

    protected AbstractRenderer setBorders(Border border, int borderNumber) {
        switch (borderNumber) {
            case 0: {
                this.setProperty(13, border);
                break;
            }
            case 1: {
                this.setProperty(12, border);
                break;
            }
            case 2: {
                this.setProperty(10, border);
                break;
            }
            case 3: {
                this.setProperty(11, border);
            }
        }
        return this;
    }

    protected Rectangle calculateAbsolutePdfBBox() {
        Rectangle contentBox = this.getOccupiedAreaBBox();
        List<Point> contentBoxPoints = this.rectangleToPointsList(contentBox);
        AbstractRenderer renderer = this;
        while (renderer.parent != null) {
            Float angle;
            if (renderer instanceof BlockRenderer && (angle = (Float)renderer.getProperty(55)) != null) {
                BlockRenderer blockRenderer = (BlockRenderer)renderer;
                AffineTransform rotationTransform = blockRenderer.createRotationTransformInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            if (renderer.getProperty(53) != null && (renderer instanceof BlockRenderer || renderer instanceof ImageRenderer || renderer instanceof TableRenderer)) {
                AffineTransform rotationTransform = renderer.createTransformationInsideOccupiedArea();
                this.transformPoints(contentBoxPoints, rotationTransform);
            }
            renderer = (AbstractRenderer)renderer.parent;
        }
        return this.calculateBBox(contentBoxPoints);
    }

    protected Rectangle calculateBBox(List<Point> points) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (Point p : points) {
            minX = Math.min(p.getX(), minX);
            minY = Math.min(p.getY(), minY);
            maxX = Math.max(p.getX(), maxX);
            maxY = Math.max(p.getY(), maxY);
        }
        return new Rectangle((float)minX, (float)minY, (float)(maxX - minX), (float)(maxY - minY));
    }

    protected List<Point> rectangleToPointsList(Rectangle rect) {
        ArrayList<Point> points = new ArrayList<Point>();
        points.addAll(Arrays.asList(new Point((double)rect.getLeft(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getBottom()), new Point((double)rect.getRight(), (double)rect.getTop()), new Point((double)rect.getLeft(), (double)rect.getTop())));
        return points;
    }

    protected List<Point> transformPoints(List<Point> points, AffineTransform transform) {
        for (Point point : points) {
            transform.transform(point, point);
        }
        return points;
    }

    protected float[] calculateShiftToPositionBBoxOfPointsAt(float left, float top, List<Point> points) {
        double minX = Double.MAX_VALUE;
        double maxY = -1.7976931348623157E308;
        for (Point point : points) {
            minX = Math.min(point.getX(), minX);
            maxY = Math.max(point.getY(), maxY);
        }
        float dx = (float)((double)left - minX);
        float dy = (float)((double)top - maxY);
        return new float[]{dx, dy};
    }

    protected boolean hasAbsoluteUnitValue(int property) {
        UnitValue value = (UnitValue)this.getProperty(property);
        return value != null && value.isPointValue();
    }

    boolean isFirstOnRootArea() {
        return this.isFirstOnRootArea(false);
    }

    boolean isFirstOnRootArea(boolean checkRootAreaOnly) {
        boolean isFirstOnRootArea = true;
        IRenderer ancestor = this;
        while (isFirstOnRootArea && ancestor.getParent() != null) {
            IRenderer parent = ancestor.getParent();
            if (parent instanceof RootRenderer) {
                isFirstOnRootArea = ((RootRenderer)parent).currentArea.isEmptyArea();
            } else if (!checkRootAreaOnly) {
                isFirstOnRootArea = parent.getOccupiedArea().getBBox().getHeight() < 1.0E-4f;
            }
            ancestor = parent;
        }
        return isFirstOnRootArea;
    }

    RootRenderer getRootRenderer() {
        IRenderer currentRenderer = this;
        while (currentRenderer instanceof AbstractRenderer) {
            if (currentRenderer instanceof RootRenderer) {
                return (RootRenderer)currentRenderer;
            }
            currentRenderer = currentRenderer.getParent();
        }
        return null;
    }

    static float calculateAdditionalWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyMargins(dummy, true);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    static boolean noAbsolutePositionInfo(IRenderer renderer) {
        return !renderer.hasProperty(73) && !renderer.hasProperty(14) && !renderer.hasProperty(34) && !renderer.hasProperty(54);
    }

    static Float getPropertyAsFloat(IRenderer renderer, int property) {
        return NumberUtil.asFloat(renderer.getProperty(property));
    }

    static UnitValue getPropertyAsUnitValue(IRenderer renderer, int property) {
        UnitValue result = (UnitValue)renderer.getProperty(property);
        return result;
    }

    void shrinkOccupiedAreaForAbsolutePosition() {
        if (this.isAbsolutePosition()) {
            Float left = this.getPropertyAsFloat(34);
            Float right = this.getPropertyAsFloat(54);
            UnitValue width = (UnitValue)this.getProperty(77);
            if (left == null && right == null && width == null) {
                this.occupiedArea.getBBox().setWidth(0.0f);
            }
        }
    }

    void drawPositionedChildren(DrawContext drawContext) {
        for (IRenderer positionedChild : this.positionedRenderers) {
            positionedChild.draw(drawContext);
        }
    }

    FontCharacteristics createFontCharacteristics() {
        FontCharacteristics fc = new FontCharacteristics();
        if (this.hasProperty(95)) {
            fc.setFontWeight((String)this.getProperty(95));
        }
        if (this.hasProperty(94)) {
            fc.setFontStyle((String)this.getProperty(94));
        }
        return fc;
    }

    PdfFont resolveFirstPdfFont() {
        Object font = this.getProperty(20);
        if (font instanceof PdfFont) {
            return (PdfFont)font;
        }
        if (font instanceof String) {
            FontProvider provider = (FontProvider)this.getProperty(91);
            if (provider == null) {
                throw new IllegalStateException("Invalid font type. FontProvider expected. Cannot resolve font with string value");
            }
            FontCharacteristics fc = this.createFontCharacteristics();
            return this.resolveFirstPdfFont((String)font, provider, fc);
        }
        throw new IllegalStateException("String or PdfFont expected as value of FONT property");
    }

    PdfFont resolveFirstPdfFont(String font, FontProvider provider, FontCharacteristics fc) {
        return provider.getPdfFont(provider.getFontSelector(FontFamilySplitter.splitFontFamily(font), fc).bestMatch());
    }

    void applyAbsolutePositionIfNeeded(LayoutContext layoutContext) {
        if (this.isAbsolutePosition()) {
            this.applyAbsolutePosition(layoutContext instanceof PositionedLayoutContext ? ((PositionedLayoutContext)layoutContext).getParentOccupiedArea().getBBox() : layoutContext.getArea().getBBox());
        }
    }

    void preparePositionedRendererAndAreaForLayout(IRenderer childPositionedRenderer, Rectangle fullBbox, Rectangle parentBbox) {
        Float left = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 34);
        Float right = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 54);
        Float top = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 73);
        Float bottom = AbstractRenderer.getPropertyAsFloat(childPositionedRenderer, 14);
        childPositionedRenderer.setParent(this);
        this.adjustPositionedRendererLayoutBoxWidth(childPositionedRenderer, fullBbox, left, right);
        if (Integer.valueOf(3).equals(childPositionedRenderer.getProperty(52))) {
            this.updateMinHeightForAbsolutelyPositionedRenderer(childPositionedRenderer, parentBbox, top, bottom);
        }
    }

    private void updateMinHeightForAbsolutelyPositionedRenderer(IRenderer renderer, Rectangle parentRendererBox, Float top, Float bottom) {
        if (top != null && bottom != null && !renderer.hasProperty(27)) {
            UnitValue currentMaxHeight = AbstractRenderer.getPropertyAsUnitValue(renderer, 84);
            UnitValue currentMinHeight = AbstractRenderer.getPropertyAsUnitValue(renderer, 85);
            float resolvedMinHeight = Math.max(0.0f, parentRendererBox.getTop() - top.floatValue() - parentRendererBox.getBottom() - bottom.floatValue());
            Rectangle dummy = new Rectangle(0.0f, 0.0f);
            if (!AbstractRenderer.isBorderBoxSizing(renderer)) {
                this.applyPaddings(dummy, AbstractRenderer.getPaddings(renderer), true);
                this.applyBorderBox(dummy, AbstractRenderer.getBorders(renderer), true);
            }
            this.applyMargins(dummy, AbstractRenderer.getMargins(renderer), true);
            resolvedMinHeight -= dummy.getHeight();
            if (currentMinHeight != null) {
                resolvedMinHeight = Math.max(resolvedMinHeight, currentMinHeight.getValue());
            }
            if (currentMaxHeight != null) {
                resolvedMinHeight = Math.min(resolvedMinHeight, currentMaxHeight.getValue());
            }
            renderer.setProperty(85, UnitValue.createPointValue(resolvedMinHeight));
        }
    }

    private void adjustPositionedRendererLayoutBoxWidth(IRenderer renderer, Rectangle fullBbox, Float left, Float right) {
        if (left != null) {
            fullBbox.setWidth(fullBbox.getWidth() - left.floatValue()).setX(fullBbox.getX() + left.floatValue());
        }
        if (right != null) {
            fullBbox.setWidth(fullBbox.getWidth() - right.floatValue());
        }
        if (left == null && right == null && !renderer.hasProperty(77)) {
            MinMaxWidth minMaxWidth;
            MinMaxWidth minMaxWidth2 = minMaxWidth = renderer instanceof BlockRenderer ? ((BlockRenderer)renderer).getMinMaxWidth() : null;
            if (minMaxWidth != null && minMaxWidth.getMaxWidth() < fullBbox.getWidth()) {
                fullBbox.setWidth(minMaxWidth.getMaxWidth() + 1.0E-4f);
            }
        }
    }

    private static float calculatePaddingBorderWidth(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getWidth();
    }

    private static float calculatePaddingBorderHeight(AbstractRenderer renderer) {
        Rectangle dummy = new Rectangle(0.0f, 0.0f);
        renderer.applyBorderBox(dummy, true);
        renderer.applyPaddings(dummy, true);
        return dummy.getHeight();
    }

    private AffineTransform createTransformationInsideOccupiedArea() {
        Rectangle backgroundArea = this.applyMargins(this.occupiedArea.clone().getBBox(), false);
        float x = backgroundArea.getX();
        float y = backgroundArea.getY();
        float height = backgroundArea.getHeight();
        float width = backgroundArea.getWidth();
        AffineTransform transform = AffineTransform.getTranslateInstance((double)(-1.0f * (x + width / 2.0f)), (double)(-1.0f * (y + height / 2.0f)));
        transform.preConcatenate(Transform.getAffineTransform((Transform)this.getProperty(53), width, height));
        transform.preConcatenate(AffineTransform.getTranslateInstance((double)(x + width / 2.0f), (double)(y + height / 2.0f)));
        return transform;
    }

    protected void beginTransformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(53) != null) {
            AffineTransform transform = this.createTransformationInsideOccupiedArea();
            canvas.saveState().concatMatrix(transform);
        }
    }

    protected void endTransformationIfApplied(PdfCanvas canvas) {
        if (this.getProperty(53) != null) {
            canvas.restoreState();
        }
    }

    private static UnitValue[] getMargins(IRenderer renderer) {
        return new UnitValue[]{(UnitValue)renderer.getProperty(46), (UnitValue)renderer.getProperty(45), (UnitValue)renderer.getProperty(43), (UnitValue)renderer.getProperty(44)};
    }

    private static Border[] getBorders(IRenderer renderer) {
        Border border = (Border)renderer.getProperty(9);
        Border topBorder = (Border)renderer.getProperty(13);
        Border rightBorder = (Border)renderer.getProperty(12);
        Border bottomBorder = (Border)renderer.getProperty(10);
        Border leftBorder = (Border)renderer.getProperty(11);
        Border[] borders = new Border[]{topBorder, rightBorder, bottomBorder, leftBorder};
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 13)) {
            borders[0] = border;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 12)) {
            borders[1] = border;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 10)) {
            borders[2] = border;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 11)) {
            borders[3] = border;
        }
        return borders;
    }

    private static BorderRadius[] getBorderRadii(IRenderer renderer) {
        BorderRadius radius = (BorderRadius)renderer.getProperty(101);
        BorderRadius topLeftRadius = (BorderRadius)renderer.getProperty(110);
        BorderRadius topRightRadius = (BorderRadius)renderer.getProperty(111);
        BorderRadius bottomRightRadius = (BorderRadius)renderer.getProperty(112);
        BorderRadius bottomLeftRadius = (BorderRadius)renderer.getProperty(113);
        BorderRadius[] borderRadii = new BorderRadius[]{topLeftRadius, topRightRadius, bottomRightRadius, bottomLeftRadius};
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 110)) {
            borderRadii[0] = radius;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 111)) {
            borderRadii[1] = radius;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 112)) {
            borderRadii[2] = radius;
        }
        if (!AbstractRenderer.hasOwnOrModelProperty(renderer, 113)) {
            borderRadii[3] = radius;
        }
        return borderRadii;
    }

    private static UnitValue[] getPaddings(IRenderer renderer) {
        return new UnitValue[]{(UnitValue)renderer.getProperty(50), (UnitValue)renderer.getProperty(49), (UnitValue)renderer.getProperty(47), (UnitValue)renderer.getProperty(48)};
    }

    private static boolean hasOwnOrModelProperty(IRenderer renderer, int property) {
        return renderer.hasOwnProperty(property) || null != renderer.getModelElement() && renderer.getModelElement().hasProperty(property);
    }
}

