/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.borders.Border;
import com.itextpdf.layout.element.Cell;
import com.itextpdf.layout.element.Table;
import com.itextpdf.layout.renderer.CellRenderer;
import com.itextpdf.layout.renderer.TableBorderUtil;
import com.itextpdf.layout.renderer.TableBorders;
import com.itextpdf.layout.renderer.TableRenderer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollapsedTableBorders
extends TableBorders {
    private List<Border> topBorderCollapseWith = new ArrayList<Border>();
    private List<Border> bottomBorderCollapseWith = new ArrayList<Border>();

    public CollapsedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders) {
        super(rows, numberOfColumns, tableBoundingBorders);
    }

    public CollapsedTableBorders(List<CellRenderer[]> rows, int numberOfColumns, Border[] tableBoundingBorders, int largeTableIndexOffset) {
        super(rows, numberOfColumns, tableBoundingBorders, largeTableIndexOffset);
    }

    protected CollapsedTableBorders collapseAllBordersAndEmptyRows() {
        int[] rowspansToDeduct = new int[this.numberOfColumns];
        int numOfRowsToRemove = 0;
        if (!this.rows.isEmpty()) {
            for (int row = this.startRow - this.largeTableIndexOffset; row <= this.finishRow - this.largeTableIndexOffset; ++row) {
                CellRenderer[] currentRow = (CellRenderer[])this.rows.get(row);
                boolean hasCells = false;
                for (int col = 0; col < this.numberOfColumns; ++col) {
                    if (null != currentRow[col]) {
                        int colspan = currentRow[col].getPropertyAsInteger(16);
                        if (rowspansToDeduct[col] > 0) {
                            int rowspan = currentRow[col].getPropertyAsInteger(60) - rowspansToDeduct[col];
                            if (rowspan < 1) {
                                Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                                logger.warn("Unexpected behaviour during table row collapsing. Calculated rowspan was less then 1.");
                                rowspan = 1;
                            }
                            currentRow[col].setProperty(60, rowspan);
                            if (0 != numOfRowsToRemove) {
                                this.removeRows(row - numOfRowsToRemove, numOfRowsToRemove);
                                row -= numOfRowsToRemove;
                                numOfRowsToRemove = 0;
                            }
                        }
                        this.buildBordersArrays(currentRow[col], row, col, rowspansToDeduct);
                        hasCells = true;
                        for (int i = 0; i < colspan; ++i) {
                            rowspansToDeduct[col + i] = 0;
                        }
                        col += colspan - 1;
                        continue;
                    }
                    if (((List)this.horizontalBorders.get(row)).size() > col) continue;
                    ((List)this.horizontalBorders.get(row)).add(null);
                }
                if (hasCells) continue;
                if (row == this.rows.size() - 1) {
                    this.removeRows(row - rowspansToDeduct[0], rowspansToDeduct[0]);
                    this.rows.remove(row - rowspansToDeduct[0]);
                    this.setFinishRow(this.finishRow - 1);
                    Logger logger = LoggerFactory.getLogger(TableRenderer.class);
                    logger.warn("Last row is not completed. Table bottom border may collapse as you do not expect it");
                    continue;
                }
                int i = 0;
                while (i < this.numberOfColumns) {
                    int n = i++;
                    rowspansToDeduct[n] = rowspansToDeduct[n] + 1;
                }
                ++numOfRowsToRemove;
            }
        }
        if (this.finishRow < this.startRow) {
            this.setFinishRow(this.startRow);
        }
        return this;
    }

    public List<Border> getTopBorderCollapseWith() {
        return this.topBorderCollapseWith;
    }

    public List<Border> getBottomBorderCollapseWith() {
        return this.bottomBorderCollapseWith;
    }

    @Override
    public float[] getCellBorderIndents(int row, int col, int rowspan, int colspan) {
        Border border;
        int i;
        float[] indents = new float[4];
        List<Border> borderList = this.getHorizontalBorder(this.startRow + row - rowspan + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[0])) continue;
            indents[0] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col + colspan);
        for (i = this.startRow - this.largeTableIndexOffset + row - rowspan + 1; i < this.startRow - this.largeTableIndexOffset + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[1])) continue;
            indents[1] = border.getWidth();
        }
        borderList = this.getHorizontalBorder(this.startRow + row + 1);
        for (i = col; i < col + colspan; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[2])) continue;
            indents[2] = border.getWidth();
        }
        borderList = this.getVerticalBorder(col);
        for (i = this.startRow - this.largeTableIndexOffset + row - rowspan + 1; i < this.startRow - this.largeTableIndexOffset + row + 1; ++i) {
            border = borderList.get(i);
            if (null == border || !(border.getWidth() > indents[3])) continue;
            indents[3] = border.getWidth();
        }
        return indents;
    }

    @Override
    public List<Border> getVerticalBorder(int index) {
        if (index == 0) {
            List<Border> borderList = TableBorderUtil.createAndFillBorderList(null, this.tableBoundingBorders[3], ((List)this.verticalBorders.get(0)).size());
            return CollapsedTableBorders.getCollapsedList((List)this.verticalBorders.get(0), borderList);
        }
        if (index == this.numberOfColumns) {
            List<Border> borderList = TableBorderUtil.createAndFillBorderList(null, this.tableBoundingBorders[1], ((List)this.verticalBorders.get(0)).size());
            return CollapsedTableBorders.getCollapsedList((List)this.verticalBorders.get(this.verticalBorders.size() - 1), borderList);
        }
        return (List)this.verticalBorders.get(index);
    }

    @Override
    public List<Border> getHorizontalBorder(int index) {
        if (index == this.startRow) {
            List<Border> firstBorderOnCurrentPage = TableBorderUtil.createAndFillBorderList(this.topBorderCollapseWith, this.tableBoundingBorders[0], this.numberOfColumns);
            if (index == this.largeTableIndexOffset) {
                return CollapsedTableBorders.getCollapsedList((List)this.horizontalBorders.get(index - this.largeTableIndexOffset), firstBorderOnCurrentPage);
            }
            if (0 != this.rows.size()) {
                int col = 0;
                int row = index;
                while (col < this.numberOfColumns) {
                    if (null != ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col] && row - index + 1 <= ((Cell)((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col].getModelElement()).getRowspan()) {
                        CellRenderer cell = ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col];
                        Border cellModelTopBorder = TableBorderUtil.getCellSideBorder((Cell)cell.getModelElement(), 13);
                        int colspan = cell.getPropertyAsInteger(16);
                        if (null == firstBorderOnCurrentPage.get(col) || null != cellModelTopBorder && cellModelTopBorder.getWidth() > firstBorderOnCurrentPage.get(col).getWidth()) {
                            for (int i = col; i < col + colspan; ++i) {
                                firstBorderOnCurrentPage.set(i, cellModelTopBorder);
                            }
                        }
                        col += colspan;
                        row = index;
                        continue;
                    }
                    if (++row != this.rows.size()) continue;
                }
            }
            return firstBorderOnCurrentPage;
        }
        if (index == this.finishRow + 1) {
            List<Border> lastBorderOnCurrentPage = TableBorderUtil.createAndFillBorderList(this.bottomBorderCollapseWith, this.tableBoundingBorders[2], this.numberOfColumns);
            if (index - this.largeTableIndexOffset == this.horizontalBorders.size() - 1) {
                return CollapsedTableBorders.getCollapsedList((List)this.horizontalBorders.get(index - this.largeTableIndexOffset), lastBorderOnCurrentPage);
            }
            if (0 != this.rows.size()) {
                int col = 0;
                int row = index - 1;
                while (col < this.numberOfColumns) {
                    if (null != ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col]) {
                        CellRenderer cell = ((CellRenderer[])this.rows.get(row - this.largeTableIndexOffset))[col];
                        Border cellModelBottomBorder = TableBorderUtil.getCellSideBorder((Cell)cell.getModelElement(), 10);
                        int colspan = cell.getPropertyAsInteger(16);
                        if (null == lastBorderOnCurrentPage.get(col) || null != cellModelBottomBorder && cellModelBottomBorder.getWidth() > lastBorderOnCurrentPage.get(col).getWidth()) {
                            for (int i = col; i < col + colspan; ++i) {
                                lastBorderOnCurrentPage.set(i, cellModelBottomBorder);
                            }
                        }
                        col += colspan;
                        row = index - 1;
                        continue;
                    }
                    if (++row != this.rows.size()) continue;
                }
            }
            return lastBorderOnCurrentPage;
        }
        return (List)this.horizontalBorders.get(index - this.largeTableIndexOffset);
    }

    public CollapsedTableBorders setTopBorderCollapseWith(List<Border> topBorderCollapseWith) {
        this.topBorderCollapseWith = new ArrayList<Border>();
        if (null != topBorderCollapseWith) {
            this.topBorderCollapseWith.addAll(topBorderCollapseWith);
        }
        return this;
    }

    public CollapsedTableBorders setBottomBorderCollapseWith(List<Border> bottomBorderCollapseWith) {
        this.bottomBorderCollapseWith = new ArrayList<Border>();
        if (null != bottomBorderCollapseWith) {
            this.bottomBorderCollapseWith.addAll(bottomBorderCollapseWith);
        }
        return this;
    }

    protected void buildBordersArrays(CellRenderer cell, int row, int col, int[] rowspansToDeduct) {
        int i;
        int nextCellColspan;
        CellRenderer nextCell;
        int nextCellRow;
        int j;
        if (row > this.horizontalBorders.size()) {
            --row;
        }
        int currCellColspan = cell.getPropertyAsInteger(16);
        if (col != 0 && null == ((CellRenderer[])this.rows.get(row))[col - 1]) {
            j = col;
            do {
                --j;
                for (nextCellRow = row; this.rows.size() != nextCellRow && null == ((CellRenderer[])this.rows.get(nextCellRow))[j]; ++nextCellRow) {
                }
            } while (j > 0 && this.rows.size() != nextCellRow && (j + ((CellRenderer[])this.rows.get(nextCellRow))[j].getPropertyAsInteger(16) != col || nextCellRow - ((CellRenderer[])this.rows.get(nextCellRow))[j].getPropertyAsInteger(60) + 1 + rowspansToDeduct[j] != row));
            if (j >= 0 && nextCellRow != this.rows.size() && nextCellRow > row) {
                nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[j];
                nextCell.setProperty(60, nextCell.getPropertyAsInteger(60) - rowspansToDeduct[j]);
                nextCellColspan = nextCell.getPropertyAsInteger(16);
                for (i = j; i < j + nextCellColspan; ++i) {
                    rowspansToDeduct[i] = 0;
                }
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        for (j = 0; j < currCellColspan; j += nextCell.getPropertyAsInteger(16).intValue()) {
            for (nextCellRow = row + 1; nextCellRow < this.rows.size() && null == ((CellRenderer[])this.rows.get(nextCellRow))[col + j]; ++nextCellRow) {
            }
            if (nextCellRow == this.rows.size()) break;
            nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[col + j];
            if (row != nextCellRow - nextCell.getPropertyAsInteger(60)) continue;
            this.buildBordersArrays(nextCell, nextCellRow, true);
        }
        if (col + currCellColspan < ((CellRenderer[])this.rows.get(row)).length) {
            for (nextCellRow = row; nextCellRow < this.rows.size() && null == ((CellRenderer[])this.rows.get(nextCellRow))[col + currCellColspan]; ++nextCellRow) {
            }
            if (nextCellRow != this.rows.size()) {
                nextCell = ((CellRenderer[])this.rows.get(nextCellRow))[col + currCellColspan];
                nextCell.setProperty(60, nextCell.getPropertyAsInteger(60) - rowspansToDeduct[col + currCellColspan]);
                nextCellColspan = nextCell.getPropertyAsInteger(16);
                for (i = col + currCellColspan; i < col + currCellColspan + nextCellColspan; ++i) {
                    rowspansToDeduct[i] = 0;
                }
                this.buildBordersArrays(nextCell, nextCellRow, true);
            }
        }
        this.buildBordersArrays(cell, row, false);
    }

    protected void buildBordersArrays(CellRenderer cell, int row, boolean isNeighbourCell) {
        int i;
        int colspan = cell.getPropertyAsInteger(16);
        int rowspan = cell.getPropertyAsInteger(60);
        int colN = ((Cell)cell.getModelElement()).getCol();
        Border[] cellBorders = cell.getBorders();
        if (row + 1 - rowspan < 0) {
            rowspan = row + 1;
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1 - rowspan, colN + i, cellBorders[0], false);
        }
        for (i = 0; i < colspan; ++i) {
            this.checkAndReplaceBorderInArray(this.horizontalBorders, row + 1, colN + i, cellBorders[2], true);
        }
        for (int j = row - rowspan + 1; j <= row; ++j) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN, j, cellBorders[3], false);
        }
        for (i = row - rowspan + 1; i <= row; ++i) {
            this.checkAndReplaceBorderInArray(this.verticalBorders, colN + colspan, i, cellBorders[1], true);
        }
    }

    protected boolean checkAndReplaceBorderInArray(List<List<Border>> borderArray, int i, int j, Border borderToAdd, boolean hasPriority) {
        List<Border> borders = borderArray.get(i);
        Border neighbour = borders.get(j);
        if (neighbour == null) {
            borders.set(j, borderToAdd);
            return true;
        }
        if (neighbour != borderToAdd && borderToAdd != null && neighbour.getWidth() <= borderToAdd.getWidth()) {
            if (!hasPriority && neighbour.getWidth() == borderToAdd.getWidth()) {
                return false;
            }
            borders.set(j, borderToAdd);
            return true;
        }
        return false;
    }

    private void removeRows(int startRow, int numOfRows) {
        for (int row = startRow; row < startRow + numOfRows; ++row) {
            this.rows.remove(startRow);
            this.horizontalBorders.remove(startRow + 1);
            for (int j = 0; j <= this.numberOfColumns; ++j) {
                ((List)this.verticalBorders.get(j)).remove(startRow + 1);
            }
        }
        this.setFinishRow(this.finishRow - numOfRows);
    }

    @Override
    protected TableBorders drawHorizontalBorder(int i, float startX, float y1, PdfCanvas canvas, float[] countedColumnWidth) {
        Border lastBorder;
        int j;
        Border firstBorder;
        List<Border> borders = this.getHorizontalBorder(this.startRow + i);
        float x1 = startX;
        float x2 = x1 + countedColumnWidth[0];
        if (i == 0) {
            firstBorder = this.getFirstVerticalBorder().get(this.startRow - this.largeTableIndexOffset);
            if (firstBorder != null) {
                x1 -= firstBorder.getWidth() / 2.0f;
            }
        } else if (i == this.finishRow - this.startRow + 1 && (firstBorder = this.getFirstVerticalBorder().get(this.startRow - this.largeTableIndexOffset + this.finishRow - this.startRow + 1 - 1)) != null) {
            x1 -= firstBorder.getWidth() / 2.0f;
        }
        for (j = 1; j < borders.size(); ++j) {
            Border prevBorder = borders.get(j - 1);
            Border curBorder = borders.get(j);
            if (prevBorder != null) {
                if (!prevBorder.equals(curBorder)) {
                    prevBorder.drawCellBorder(canvas, x1, y1, x2, y1, Border.Side.NONE);
                    prevBorder.drawCellBorder(canvas, x1, y1, x2, y1, Border.Side.NONE);
                    x1 = x2;
                }
            } else {
                x2 = x1 += countedColumnWidth[j - 1];
            }
            if (curBorder == null) continue;
            x2 += countedColumnWidth[j];
        }
        Border border = lastBorder = borders.size() > j - 1 ? borders.get(j - 1) : null;
        if (lastBorder != null) {
            if (i == 0) {
                if (this.getVerticalBorder(j).get(this.startRow - this.largeTableIndexOffset + i) != null) {
                    x2 += this.getVerticalBorder(j).get(this.startRow - this.largeTableIndexOffset + i).getWidth() / 2.0f;
                }
            } else if (i == this.finishRow - this.startRow + 1 && this.getVerticalBorder(j).size() > this.startRow - this.largeTableIndexOffset + i - 1 && this.getVerticalBorder(j).get(this.startRow - this.largeTableIndexOffset + i - 1) != null) {
                x2 += this.getVerticalBorder(j).get(this.startRow - this.largeTableIndexOffset + i - 1).getWidth() / 2.0f;
            }
            lastBorder.drawCellBorder(canvas, x1, y1, x2, y1, Border.Side.NONE);
        }
        return this;
    }

    @Override
    protected TableBorders drawVerticalBorder(int i, float startY, float x1, PdfCanvas canvas, List<Float> heights) {
        int j;
        float y1;
        List<Border> borders = this.getVerticalBorder(i);
        float y2 = y1 = startY;
        if (!heights.isEmpty()) {
            y2 = y1 - heights.get(0).floatValue();
        }
        for (j = 1; j < heights.size(); ++j) {
            Border prevBorder = borders.get(this.startRow - this.largeTableIndexOffset + j - 1);
            Border curBorder = borders.get(this.startRow - this.largeTableIndexOffset + j);
            if (prevBorder != null) {
                if (!prevBorder.equals(curBorder)) {
                    prevBorder.drawCellBorder(canvas, x1, y1, x1, y2, Border.Side.NONE);
                    y1 = y2;
                }
            } else {
                y2 = y1 -= heights.get(j - 1).floatValue();
            }
            if (curBorder == null) continue;
            y2 -= heights.get(j).floatValue();
        }
        if (borders.size() == 0) {
            return this;
        }
        Border lastBorder = borders.get(this.startRow - this.largeTableIndexOffset + j - 1);
        if (lastBorder != null) {
            lastBorder.drawCellBorder(canvas, x1, y1, x1, y2, Border.Side.NONE);
        }
        return this;
    }

    public static Border getCollapsedBorder(Border cellBorder, Border tableBorder) {
        if (null != tableBorder && (null == cellBorder || cellBorder.getWidth() < tableBorder.getWidth())) {
            return tableBorder;
        }
        if (null != cellBorder) {
            return cellBorder;
        }
        return Border.NO_BORDER;
    }

    public static List<Border> getCollapsedList(List<Border> innerList, List<Border> outerList) {
        int size = Math.min(null == innerList ? 0 : innerList.size(), null == outerList ? 0 : outerList.size());
        ArrayList<Border> collapsedList = new ArrayList<Border>();
        for (int i = 0; i < size; ++i) {
            collapsedList.add(CollapsedTableBorders.getCollapsedBorder(innerList.get(i), outerList.get(i)));
        }
        return collapsedList;
    }

    @Override
    protected TableBorders applyLeftAndRightTableBorder(Rectangle layoutBox, boolean reverse) {
        if (null != layoutBox) {
            layoutBox.applyMargins(0.0f, this.rightBorderMaxWidth / 2.0f, 0.0f, this.leftBorderMaxWidth / 2.0f, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        if (!isEmpty) {
            return this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
        }
        if (force) {
            this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
            return this.applyTopTableBorder(occupiedBox, layoutBox, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean isEmpty, boolean force, boolean reverse) {
        if (!isEmpty) {
            return this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
        }
        if (force) {
            this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
            return this.applyBottomTableBorder(occupiedBox, layoutBox, reverse);
        }
        return this;
    }

    @Override
    protected TableBorders applyTopTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float topIndent = (float)(reverse ? -1 : 1) * this.getMaxTopWidth();
        layoutBox.decreaseHeight(topIndent / 2.0f);
        occupiedBox.moveDown(topIndent / 2.0f).increaseHeight(topIndent / 2.0f);
        return this;
    }

    @Override
    protected TableBorders applyBottomTableBorder(Rectangle occupiedBox, Rectangle layoutBox, boolean reverse) {
        float bottomTableBorderWidth = (float)(reverse ? -1 : 1) * this.getMaxBottomWidth();
        layoutBox.decreaseHeight(bottomTableBorderWidth / 2.0f);
        occupiedBox.moveDown(bottomTableBorderWidth / 2.0f).increaseHeight(bottomTableBorderWidth / 2.0f);
        return this;
    }

    @Override
    protected TableBorders applyCellIndents(Rectangle box, float topIndent, float rightIndent, float bottomIndent, float leftIndent, boolean reverse) {
        box.applyMargins(topIndent / 2.0f, rightIndent / 2.0f, bottomIndent / 2.0f, leftIndent / 2.0f, false);
        return this;
    }

    @Override
    protected float getCellVerticalAddition(float[] indents) {
        return indents[0] / 2.0f + indents[2] / 2.0f;
    }

    @Override
    protected TableBorders updateBordersOnNewPage(boolean isOriginalNonSplitRenderer, boolean isFooterOrHeader, TableRenderer currentRenderer, TableRenderer headerRenderer, TableRenderer footerRenderer) {
        if (!isFooterOrHeader) {
            if (isOriginalNonSplitRenderer) {
                if (null != this.rows) {
                    this.collapseAllBordersAndEmptyRows();
                    this.rightBorderMaxWidth = this.getMaxRightWidth();
                    this.leftBorderMaxWidth = this.getMaxLeftWidth();
                }
                this.setTopBorderCollapseWith(((Table)currentRenderer.getModelElement()).getLastRowBottomBorder());
            } else {
                this.setTopBorderCollapseWith(null);
                this.setBottomBorderCollapseWith(null);
            }
        }
        if (null != footerRenderer) {
            float rightFooterBorderWidth = footerRenderer.bordersHandler.getMaxRightWidth();
            float leftFooterBorderWidth = footerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftFooterBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightFooterBorderWidth);
        }
        if (null != headerRenderer) {
            float rightHeaderBorderWidth = headerRenderer.bordersHandler.getMaxRightWidth();
            float leftHeaderBorderWidth = headerRenderer.bordersHandler.getMaxLeftWidth();
            this.leftBorderMaxWidth = Math.max(this.leftBorderMaxWidth, leftHeaderBorderWidth);
            this.rightBorderMaxWidth = Math.max(this.rightBorderMaxWidth, rightHeaderBorderWidth);
        }
        return this;
    }

    @Override
    protected TableBorders skipFooter(Border[] borders) {
        this.setTableBoundingBorders(borders);
        this.setBottomBorderCollapseWith(null);
        return this;
    }

    @Override
    protected TableBorders skipHeader(Border[] borders) {
        this.setTableBoundingBorders(borders);
        this.setTopBorderCollapseWith(null);
        return this;
    }

    @Override
    protected TableBorders collapseTableWithFooter(TableBorders footerBordersHandler, boolean hasContent) {
        ((CollapsedTableBorders)footerBordersHandler).setTopBorderCollapseWith(hasContent ? this.getLastHorizontalBorder() : this.getTopBorderCollapseWith());
        this.setBottomBorderCollapseWith(footerBordersHandler.getHorizontalBorder(0));
        return this;
    }

    @Override
    protected TableBorders collapseTableWithHeader(TableBorders headerBordersHandler, boolean changeThis) {
        ((CollapsedTableBorders)headerBordersHandler).setBottomBorderCollapseWith(this.getHorizontalBorder(this.startRow));
        if (changeThis) {
            this.setTopBorderCollapseWith(headerBordersHandler.getLastHorizontalBorder());
        }
        return this;
    }

    @Override
    protected TableBorders fixHeaderOccupiedArea(Rectangle occupiedBox, Rectangle layoutBox) {
        float topBorderMaxWidth = this.getMaxTopWidth();
        layoutBox.increaseHeight(topBorderMaxWidth);
        occupiedBox.moveUp(topBorderMaxWidth).decreaseHeight(topBorderMaxWidth);
        return this;
    }
}

