/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.commons.utils.EncodingUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.util.ResourceUtil;
import com.itextpdf.licensing.base.util.UTF8;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

public final class CertificateWorker {
    private final PublicKey publicKey;

    private CertificateWorker(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public static CertificateWorker createCertificateWorker(String certPath) {
        return CertificateWorker.createCertificateWorker(ResourceUtil.getResourceStream(certPath));
    }

    public static CertificateWorker createCertificateWorker(InputStream certInputStream) {
        PublicKey publicKey = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            if (certInputStream == null) {
                throw new LicenseKeyException("Certificate not found.");
            }
            X509Certificate certificate = (X509Certificate)cf.generateCertificate(certInputStream);
            publicKey = certificate.getPublicKey();
        }
        catch (LicenseKeyException lex) {
            throw lex;
        }
        catch (Exception ex) {
            throw new LicenseKeyException("Invalid public key.", ex);
        }
        finally {
            try {
                if (certInputStream != null) {
                    certInputStream.close();
                }
            }
            catch (IOException e) {
                throw new LicenseKeyException(e.getMessage());
            }
        }
        if (publicKey == null) {
            throw new LicenseKeyException("Certificate not found.");
        }
        return new CertificateWorker(publicKey);
    }

    public boolean verify(String decodedString, String encodedSignature) throws GeneralSecurityException {
        Signature signature = Signature.getInstance("SHA1WithRSA");
        signature.initVerify(this.publicKey);
        signature.update(UTF8.getBytes(decodedString));
        return signature.verify(EncodingUtil.fromBase64((String)encodedSignature));
    }
}

