/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base;

import com.itextpdf.commons.actions.data.CommonsProductData;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.util.VersionUtil;
import java.util.List;

final class CommonsVersionChecker {
    static final int MINIMAL_COMMONS_MAJOR_VERSION = 9;
    static final int MINIMAL_COMMONS_MINOR_VERSION = 2;
    static final int MINIMAL_COMMONS_PATCH_VERSION = 0;

    private CommonsVersionChecker() {
    }

    static void checkCommonsVersion() {
        String commonsVersion = CommonsProductData.getInstance().getVersion();
        CommonsVersionChecker.checkVersion(commonsVersion);
    }

    static void checkVersion(String actualVersion) {
        List<Integer> parsedActualVersion = VersionUtil.parseModuleOrProductVersion(actualVersion);
        if (parsedActualVersion == null || VersionUtil.isVersionsIncompatible(9, 2, 0, parsedActualVersion.get(0), parsedActualVersion.get(1), parsedActualVersion.get(2))) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Version \"{0}\" of commons module of iText does not match minimal expected version \"{1}.{2}.{3}\".", (Object[])new Object[]{actualVersion, 9, 2, 0}));
        }
    }
}

