/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.actions;

import com.itextpdf.commons.actions.AbstractProductProcessITextEvent;
import com.itextpdf.commons.actions.EventManager;
import com.itextpdf.commons.actions.IEvent;
import com.itextpdf.commons.actions.confirmations.ConfirmEvent;
import com.itextpdf.commons.actions.processors.AbstractITextProductEventProcessor;
import com.itextpdf.commons.exceptions.ProductEventHandlerRepeatException;
import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.base.LicenseFileService;
import com.itextpdf.licensing.base.LicenseKeyProductData;
import com.itextpdf.licensing.base.actions.ILicenseFileExpirationChecker;
import com.itextpdf.licensing.base.actions.LicenseFileCheckerFactoryKeeper;
import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.licensefile.ProductVersion;
import com.itextpdf.licensing.base.reporting.IReportingHandler;
import com.itextpdf.licensing.base.statistics.ProductVersionStatisticsEvent;
import com.itextpdf.licensing.base.util.VersionUtil;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LicenseITextProductEventProcessor
extends AbstractITextProductEventProcessor {
    private static final Pattern VERSION_PATTERN = Pattern.compile("^([\\d]+)\\.([\\d]+).*$");
    private final LicenseFile licenseFile;
    private final ILicenseFileExpirationChecker licenseFileExpirationChecker;
    private final IReportingHandler reportingHandler;

    LicenseITextProductEventProcessor(LicenseFile licenseFile, IReportingHandler reportingHandler) {
        super(licenseFile.getProduct());
        this.licenseFile = licenseFile;
        this.licenseFileExpirationChecker = LicenseFileCheckerFactoryKeeper.getFactory().create(licenseFile.getProduct(), licenseFile.getOnExpiration(), licenseFile.getExpirationDate(), licenseFile.getGracePeriod());
        this.reportingHandler = reportingHandler;
    }

    public String getUsageType() {
        return this.licenseFile.getLicenseType().name();
    }

    public String getProducer() {
        String producer = this.licenseFile.getProducerLine();
        if (producer == null || producer.isEmpty()) {
            return super.getProducer() + ", " + this.licenseFile.getLicensee().getCompany();
        }
        return producer;
    }

    public void onEvent(AbstractProductProcessITextEvent event) {
        if (this.licenseFile.getProduct().equals(event.getProductName())) {
            this.checkExpiration();
            this.checkProductVersion(event.getProductData().getVersion());
            this.checkLicensingBaseVersion(event.getProductData().getMinCompatibleLicensingModuleVersion());
            this.reportingHandler.checkEvent(this, event.getEventType());
            if (event instanceof ConfirmEvent) {
                this.reportingHandler.reportEvent((ConfirmEvent)event);
                EventManager.getInstance().onEvent((IEvent)new ProductVersionStatisticsEvent(event.getProductData()));
            }
        }
    }

    public LicenseFile getLicenseFile() {
        return this.licenseFile;
    }

    public void tryToUpdateCurrentLicense() {
        LicenseFile currentLicenseFile = this.getLicenseFile();
        LicenseFileService.tryToLoadUpToDateLicenseFile(currentLicenseFile);
        String productName = currentLicenseFile.getProduct();
        LicenseFile upToDateLicenseFile = LicenseFileService.getLicenseFileForProduct(productName);
        if (!currentLicenseFile.equals(upToDateLicenseFile)) {
            throw new ProductEventHandlerRepeatException(MessageFormatUtil.format((String)"License file for \"{0}\" product has been reloaded.", (Object[])new Object[]{productName}));
        }
    }

    private void checkExpiration() {
        if (this.licenseFileExpirationChecker.isLicenseFileExpired()) {
            this.tryToUpdateCurrentLicense();
        }
        this.licenseFileExpirationChecker.checkExpiration();
    }

    private void checkProductVersion(String versionStr) {
        int minor;
        int minorFromLicense;
        ProductVersion productVersion = this.licenseFile.getProductVersion();
        if (productVersion == null) {
            return;
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionStr);
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid event version.");
        }
        int major = Integer.parseInt(matcher.group(1));
        int majorFromLicence = productVersion.getMajor();
        if (majorFromLicence != major) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Major version \"{0}\" of product \"{1}\" doesn't match to supported version \"{2}\" from license file.", (Object[])new Object[]{major, this.licenseFile.getProduct(), majorFromLicence}));
        }
        if (productVersion.getMinor() != null && (minorFromLicense = productVersion.getMinor().intValue()) != (minor = Integer.parseInt(matcher.group(2)))) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Minor version \"{0}\" of product \"{1}\" doesn't match to supported version \"{2}\" from license file.", (Object[])new Object[]{minor, this.licenseFile.getProduct(), minorFromLicense}));
        }
    }

    private void checkLicensingBaseVersion(String versionStr) {
        if (versionStr == null) {
            return;
        }
        List<Integer> parsedCompatibleVersion = VersionUtil.parseModuleOrProductVersion(versionStr);
        if (parsedCompatibleVersion == null || VersionUtil.isVersionsIncompatible(parsedCompatibleVersion.get(0), parsedCompatibleVersion.get(1), parsedCompatibleVersion.get(2), VersionUtil.LICENSING_BASE_MAJOR, VersionUtil.LICENSING_BASE_MINOR, VersionUtil.LICENSING_BASE_PATCH)) {
            throw new LicenseKeyException(MessageFormatUtil.format((String)"Your current licensing base module version \"{0}\" does not corresponds minimal compatible version \"{1}\" for your product", (Object[])new Object[]{LicenseKeyProductData.getInstance().getVersion(), versionStr}));
        }
    }
}

