/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.reporting;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.itextpdf.commons.utils.MapUtil;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class ProductLimitsRequest {
    @JsonProperty(value="licenseKey")
    private final String licenseKey;
    @JsonProperty(value="productName")
    private final String productName;
    @JsonProperty(value="limits")
    private final Map<String, Long> limits;

    public ProductLimitsRequest(@JsonProperty(value="licenseKey") String licenseKey, @JsonProperty(value="productName") String productName, @JsonProperty(value="limits") Map<String, Long> limits) {
        if (licenseKey == null) {
            throw new IllegalArgumentException("License file key can not be null.");
        }
        this.licenseKey = licenseKey;
        if (productName == null) {
            throw new IllegalArgumentException("Product name can not be null.");
        }
        this.productName = productName;
        if (limits == null) {
            throw new IllegalArgumentException("Limits can not be null.");
        }
        this.limits = new LinkedHashMap<String, Long>();
        for (Map.Entry<String, Long> entry : limits.entrySet()) {
            this.limits.put(entry.getKey(), entry.getValue());
        }
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public String getProductName() {
        return this.productName;
    }

    public Map<String, Long> getLimits() {
        return Collections.unmodifiableMap(this.limits);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProductLimitsRequest request = (ProductLimitsRequest)o;
        return Objects.equals(this.licenseKey, request.licenseKey) && Objects.equals(this.productName, request.productName) && MapUtil.equals(this.limits, request.limits);
    }

    public int hashCode() {
        int hashCode = Objects.hash(this.licenseKey, this.productName);
        return hashCode * 31 + (this.limits == null ? 0 : MapUtil.getHashCode(this.limits));
    }
}

