/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.strategy;

import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.licensing.base.strategy.AbstractGraceStrategy;
import com.itextpdf.licensing.base.strategy.IStrategy;
import java.util.concurrent.atomic.AtomicLong;

final class GraceFromLastSuccessStrategy
extends AbstractGraceStrategy {
    private final AtomicLong lastSuccessTime;
    private final long gracePeriod;

    public GraceFromLastSuccessStrategy(IStrategy duringGracePeriodStrategy, IStrategy afterGracePeriodStrategy, long gracePeriod) {
        super(duringGracePeriodStrategy, afterGracePeriodStrategy);
        this.gracePeriod = gracePeriod;
        this.lastSuccessTime = new AtomicLong(SystemUtil.getRelativeTimeMillis());
    }

    @Override
    public void onSuccess() {
        this.lastSuccessTime.set(SystemUtil.getRelativeTimeMillis());
        super.onSuccess();
    }

    @Override
    protected boolean isBeforeGraceStrategy() {
        return SystemUtil.getRelativeTimeMillis() - this.lastSuccessTime.get() < this.gracePeriod;
    }
}

