/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.base.util;

import com.itextpdf.licensing.base.exceptions.LicenseKeyException;
import com.itextpdf.licensing.base.licensefile.LicenseFile;
import com.itextpdf.licensing.base.util.CertificateWorker;
import com.itextpdf.licensing.base.util.JsonMapperUtil;

public final class SigningUtil {
    private static final char[] SPACES = new char[]{' ', '\f', '\n', '\r', '\t'};
    private static final String ITEXT_CERTIFICATE_RESOURCE_PATH = "com/itextpdf/licensing/base/itext-unified.cer";
    private static final CertificateWorker CERTIFICATE_WORKER = CertificateWorker.createCertificateWorker("com/itextpdf/licensing/base/itext-unified.cer");

    private SigningUtil() {
    }

    public static boolean isSignedLicenseFile(LicenseFile toCheck) {
        try {
            SigningUtil.checkSignature(toCheck);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void checkSignature(LicenseFile file) throws LicenseKeyException {
        if (file == null) {
            throw new LicenseKeyException("License file was corrupted.");
        }
        String expectedSignature = SigningUtil.getExpectedSignature(file);
        boolean isVerified = false;
        try {
            isVerified = CERTIFICATE_WORKER.verify(expectedSignature, file.getSignature());
        }
        catch (Exception any) {
            throw new LicenseKeyException("Signature was corrupted.");
        }
        if (!isVerified) {
            throw new LicenseKeyException("License file was corrupted.");
        }
    }

    private static String getExpectedSignature(LicenseFile licenseFile) {
        LicenseFile unsignedLicenseFile = licenseFile.unsignedCopy();
        return "iTextRulez" + SigningUtil.removeSpaces(JsonMapperUtil.serializeToString(unsignedLicenseFile));
    }

    private static String removeSpaces(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (char c : value.toCharArray()) {
            if (SigningUtil.isSpaceCharacter(c)) continue;
            builder.append(c);
        }
        return builder.toString();
    }

    private static boolean isSpaceCharacter(char c) {
        for (char index : SPACES) {
            if (index != c) continue;
            return true;
        }
        return false;
    }
}

