/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote;

import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;

public final class LicenseKeyRemoteConfigurer {
    private static ProxyConfig config;

    private LicenseKeyRemoteConfigurer() {
    }

    public static void setProxy(String host, int port) {
        if (null == host || host.isEmpty() || port <= 0 || port > 65535) {
            throw new LicenseKeyRemoteException("Proxy host or port value is invalid");
        }
        if (PortingUtil.isClientConfigurationInitialized()) {
            throw new LicenseKeyRemoteException("Proxy settings are already set up and in use. Proxy settings should be set up before the first license loading.");
        }
        config = new ProxyConfig(host, port);
    }

    public static void resetProxy() {
        if (PortingUtil.isClientConfigurationInitialized()) {
            throw new LicenseKeyRemoteException("Proxy settings are already set up and in use. Proxy settings should be set up before the first license loading.");
        }
        config = null;
    }

    static ProxyConfig getProxyConfig() {
        return config;
    }

    static final class ProxyConfig {
        private final String host;
        private final int port;

        ProxyConfig(String host, int port) {
            this.host = host;
            this.port = port;
        }

        String getHost() {
            return this.host;
        }

        int getPort() {
            return this.port;
        }
    }
}

