/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.auth;

import com.itextpdf.licensing.remote.PortingUtil;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.regions.Region;

public final class AwsCredentialsData {
    private final String access;
    private final String secret;
    private final String session;
    private final Region region;

    public AwsCredentialsData(String accessKey, String secretKey, String region) {
        this(accessKey, secretKey, null, region);
    }

    public AwsCredentialsData(String accessKey, String secretKey, String session, String region) {
        if (accessKey == null || secretKey == null) {
            throw new IllegalArgumentException("Access and Secret should be present.");
        }
        this.access = accessKey;
        this.secret = secretKey;
        this.session = session;
        this.region = Region.of((String)region);
    }

    public String getAccess() {
        return this.access;
    }

    public String getSecret() {
        return this.secret;
    }

    public String getSession() {
        return this.session;
    }

    public Region getRegion() {
        return this.region;
    }

    public AwsCredentials getAwsCredentials() {
        return PortingUtil.getAwsCredentialsObject(this.access, this.secret, this.session);
    }
}

