/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.kinesis;

import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import com.itextpdf.licensing.remote.kinesis.KinesisRecordDataBuffer;
import software.amazon.awssdk.services.kinesis.KinesisClient;

public final class KinesisDataSender {
    private final KinesisRecordDataBuffer buffer;
    private final int capacity;
    private final String streamName;
    private final AwsSdkCredentialsProvider credentialsProvider;
    private KinesisClient client;

    public KinesisDataSender(int capacity, String streamName, AwsSdkCredentialsProvider credentialsProvider) {
        this.buffer = new KinesisRecordDataBuffer(capacity);
        this.capacity = capacity;
        this.streamName = streamName;
        this.credentialsProvider = credentialsProvider;
        this.client = PortingUtil.buildStandardKinesisClient(credentialsProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecord(byte[] data) {
        KinesisRecordDataBuffer kinesisRecordDataBuffer = this.buffer;
        synchronized (kinesisRecordDataBuffer) {
            boolean successful;
            if (data.length > this.capacity) {
                throw new LicenseKeyRemoteException("The data record size to be sent is greater than max capacity.");
            }
            boolean didRetriedRequest = false;
            try {
                successful = this.sendRequest(data);
                if (!successful && this.credentialsProvider != null) {
                    this.credentialsProvider.refresh();
                    this.client = PortingUtil.buildStandardKinesisClient(this.credentialsProvider);
                    didRetriedRequest = true;
                    successful = this.sendRequest(data);
                }
            }
            catch (Exception e) {
                if (this.credentialsProvider == null || didRetriedRequest) {
                    throw e;
                }
                this.credentialsProvider.refresh();
                this.client = PortingUtil.buildStandardKinesisClient(this.credentialsProvider);
                successful = this.sendRequest(data);
            }
            return successful;
        }
    }

    private boolean sendRequest(byte[] toSend) {
        this.buffer.wrap(toSend);
        return PortingUtil.sendKinesisRequest(this.buffer, this.streamName, this.client);
    }
}

