/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote;

import com.itextpdf.commons.utils.MessageFormatUtil;
import com.itextpdf.licensing.remote.PortingUtil;
import org.slf4j.Logger;

public class LoggingUtil {
    public static void traceLog(Logger logger, String message, Object ... args) {
        LoggingUtil.traceLog(logger, message, null, args);
    }

    public static void traceLog(Logger logger, String message, Exception exception, Object ... args) {
        if (!logger.isTraceEnabled()) {
            return;
        }
        args = LoggingUtil.appendTimeStamp(args);
        if (exception == null) {
            logger.trace(MessageFormatUtil.format((String)(LoggingUtil.getTimeStampLog(args.length) + message), (Object[])args));
        } else {
            logger.trace(MessageFormatUtil.format((String)(LoggingUtil.getTimeStampLog(args.length) + message), (Object[])args), (Throwable)exception);
        }
    }

    public static String redactPii(String data) {
        return LoggingUtil.redactPii(data, 5);
    }

    public static String redactPii(String data, int length) {
        if (data == null || data.length() < length) {
            return data;
        }
        StringBuilder masked = new StringBuilder(data.length());
        masked.append(data.substring(0, length));
        for (int i = length; i < data.length(); ++i) {
            masked.append('*');
        }
        return masked.toString();
    }

    static String getTimeStampLog(int argsLength) {
        return "UTC Time = \"{" + (argsLength - 1) + "}\": ";
    }

    static Object[] appendTimeStamp(Object[] args) {
        if (args == null) {
            return new Object[]{PortingUtil.getAwsCurrentUtcTimestamp()};
        }
        Object[] newArgs = new Object[args.length + 1];
        System.arraycopy(args, 0, newArgs, 0, args.length);
        newArgs[args.length] = PortingUtil.getAwsCurrentUtcTimestamp();
        return newArgs;
    }
}

