/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote.auth;

import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.PortingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayClient;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AuthData;
import com.itextpdf.licensing.remote.auth.AuthHelper;
import com.itextpdf.licensing.remote.auth.AwsCredentialsData;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.services.cognitoidentity.model.Credentials;

public class AwsSdkCredentialsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(AwsSdkCredentialsProvider.class);
    private static final String COGNITO_JWT_PROVIDER = "cognito-identity.amazonaws.com";
    private final Object syncLock = new Object();
    private final ApiGatewayClient apiGatewayClient;
    private final AuthHelper authHelper;
    private volatile AuthData lastObtainedAuthData;
    private volatile AwsCredentialsData lastObtainedCredentials;

    public AwsSdkCredentialsProvider(ApiGatewayClient apiGatewayClient, AuthHelper authHelper) {
        this.apiGatewayClient = apiGatewayClient;
        this.authHelper = authHelper;
    }

    public AwsCredentialsData getCredentialsData() {
        if (this.lastObtainedCredentials == null) {
            this.refresh();
        }
        return this.lastObtainedCredentials;
    }

    public AwsCredentials getCredentials() {
        return this.getCredentialsData().getAwsCredentials();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object object = this.syncLock;
        synchronized (object) {
            LoggingUtil.traceLog(LOGGER, "Refresh AWS credentials, last obtained auth data: {0}", this.lastObtainedAuthData);
            if (this.lastObtainedAuthData == null) {
                this.refreshAuthData();
            }
            try {
                this.refreshSessionCredentials();
            }
            catch (Exception e) {
                LoggingUtil.traceLog(LOGGER, "AWS credentials refresh failed with exception: {0}", e, e.toString());
                this.refreshAuthData();
                this.refreshSessionCredentials();
            }
        }
    }

    private void refreshAuthData() {
        ApiGatewayResponse response = this.apiGatewayClient.makePostRequest(this.authHelper.getBodyForAuthRequest());
        if (response.getStatus() != 200) {
            throw new LicenseKeyRemoteException("Cannot get authentication data.");
        }
        this.lastObtainedAuthData = this.authHelper.parseAuthData(response.getBody());
        LoggingUtil.traceLog(LOGGER, "Auth data was refreshed: {0}", this.lastObtainedAuthData);
    }

    private void refreshSessionCredentials() {
        LoggingUtil.traceLog(LOGGER, "Attempt to refresh session credentials, last obtained auth data: {0}", this.lastObtainedAuthData);
        Credentials credentials = PortingUtil.getAwsCognitoCredentials(this.lastObtainedAuthData, COGNITO_JWT_PROVIDER);
        this.lastObtainedCredentials = new AwsCredentialsData(credentials.accessKeyId(), credentials.secretKey(), credentials.sessionToken(), this.lastObtainedAuthData.getRegion());
        LoggingUtil.traceLog(LOGGER, "Refresh session credentials was successful, obtained credentials: {0}", this.lastObtainedCredentials);
    }
}

