/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.licensing.remote;

import com.itextpdf.licensing.remote.LicenseKeyRemoteConfigurer;
import com.itextpdf.licensing.remote.LoggingUtil;
import com.itextpdf.licensing.remote.apigateway.ApiGatewayResponse;
import com.itextpdf.licensing.remote.auth.AuthData;
import com.itextpdf.licensing.remote.auth.AwsCredentialsData;
import com.itextpdf.licensing.remote.auth.AwsSdkCredentialsProvider;
import com.itextpdf.licensing.remote.exceptions.LicenseKeyRemoteException;
import com.itextpdf.licensing.remote.kinesis.KinesisRecordDataBuffer;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClient;
import software.amazon.awssdk.services.cognitoidentity.CognitoIdentityClientBuilder;
import software.amazon.awssdk.services.cognitoidentity.model.Credentials;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityRequest;
import software.amazon.awssdk.services.cognitoidentity.model.GetCredentialsForIdentityResponse;
import software.amazon.awssdk.services.kinesis.KinesisClient;
import software.amazon.awssdk.services.kinesis.KinesisClientBuilder;
import software.amazon.awssdk.services.kinesis.model.PutRecordRequest;
import software.amazon.awssdk.services.kinesis.model.PutRecordResponse;

public final class PortingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PortingUtil.class);
    private static final String HTTPS_PROTOCOL_PREFIX = "https://";
    private static final ContentType CONTENT_TYPE = ContentType.APPLICATION_JSON;
    private static SdkHttpClient sdkHttpClient;
    private static LicenseKeyRemoteConfigurer.ProxyConfig clientProxyConfig;

    private PortingUtil() {
    }

    public static KinesisClient buildStandardKinesisClient(AwsSdkCredentialsProvider credentialsProvider) {
        AwsCredentialsData credentialsData = credentialsProvider.getCredentialsData();
        LoggingUtil.traceLog(LOGGER, "Build standard kinesis client, credentials data = {0}", credentialsData);
        return (KinesisClient)((KinesisClientBuilder)((KinesisClientBuilder)((KinesisClientBuilder)KinesisClient.builder().httpClient(PortingUtil.getSdkHttpClient())).credentialsProvider((AwsCredentialsProvider)StaticCredentialsProvider.create((AwsCredentials)credentialsProvider.getCredentials()))).region(credentialsProvider.getCredentialsData().getRegion())).build();
    }

    public static boolean sendKinesisRequest(KinesisRecordDataBuffer buffer, String streamName, KinesisClient client) {
        try {
            PutRecordRequest putRecordRequest = (PutRecordRequest)PutRecordRequest.builder().streamName(streamName).data(SdkBytes.fromByteBuffer((ByteBuffer)buffer.toRecordData())).partitionKey("partitionKey-" + (int)(PortingUtil.random() * 2.147483647E9)).build();
            LoggingUtil.traceLog(LOGGER, "Send Kinesis request, record request = {0}", putRecordRequest.toString());
            return PortingUtil.isSuccessful(client.putRecord(putRecordRequest));
        }
        catch (Exception e) {
            throw new LicenseKeyRemoteException(e.getMessage(), e);
        }
    }

    public static boolean isSuccessful(PutRecordResponse result) {
        boolean isSuccessful = result != null && result.sdkHttpResponse().isSuccessful();
        LoggingUtil.traceLog(LOGGER, "Is Kinesis request successful, result = {0}", isSuccessful);
        return isSuccessful;
    }

    public static double random() {
        return Math.random();
    }

    public static <T> List<T> singletonList(T o) {
        return Collections.singletonList(o);
    }

    public static String getAwsCurrentUtcTimestamp() {
        ZonedDateTime time = ZonedDateTime.now(ZoneOffset.UTC);
        String datestamp = time.format(DateTimeFormatter.ofPattern("yyyyMMdd"));
        return datestamp + "T" + time.format(DateTimeFormatter.ofPattern("HHmmss")) + "Z";
    }

    public static String toHexString(byte[] bytes) {
        try (Formatter formatter = new Formatter();){
            for (byte b : bytes) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            return string;
        }
    }

    public static byte[] hmacSha256HashCalculate(byte[] key, String msg) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(key, "HmacSHA256");
            Mac mac = Mac.getInstance("HmacSHA256");
            mac.init(signingKey);
            return mac.doFinal(msg.getBytes(StandardCharsets.UTF_8));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            throw new LicenseKeyRemoteException("Exception during request signing.", e);
        }
    }

    public static int getHashCodeFromObjects(Object ... objects) {
        return Objects.hash(objects);
    }

    public static String sha256HashCalculate(byte[] msg) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] encodedHash = digest.digest(msg);
            return PortingUtil.toHexString(encodedHash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new LicenseKeyRemoteException("Exception during request signing.", e);
        }
    }

    public static AwsCredentials getAwsCredentialsObject(String access, String secret, String session) {
        return session == null ? AwsBasicCredentials.create((String)access, (String)secret) : AwsSessionCredentials.create((String)access, (String)secret, (String)session);
    }

    public static String getJsonContentTypeHeader() {
        return CONTENT_TYPE.getMimeType();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Credentials getAwsCognitoCredentials(AuthData authData, String provider) {
        LoggingUtil.traceLog(LOGGER, "Get Cognito credentials using auth data: {0}", authData.toString());
        try (CognitoIdentityClient client = (CognitoIdentityClient)((CognitoIdentityClientBuilder)((CognitoIdentityClientBuilder)((CognitoIdentityClientBuilder)CognitoIdentityClient.builder().httpClient(PortingUtil.getSdkHttpClient())).region(Region.of((String)authData.getRegion()))).credentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create())).build();){
            GetCredentialsForIdentityResponse response = client.getCredentialsForIdentity((GetCredentialsForIdentityRequest)GetCredentialsForIdentityRequest.builder().logins(Collections.singletonMap(provider, authData.getToken())).identityId(authData.getIdentityId()).build());
            LoggingUtil.traceLog(LOGGER, "Get Cognito credentials response: aws identity id = \"{0}\", credentials = {1}", response.identityId(), response.credentials() == null ? "null" : response.credentials().toString());
            Credentials credentials = response.credentials();
            return credentials;
        }
        catch (Exception e) {
            throw new LicenseKeyRemoteException(e.getMessage(), e);
        }
    }

    public static ApiGatewayResponse tryMakePostHttpRequest(String requestBody, String host, String resource, Map<String, String> headers, int timeoutMillis) throws IOException {
        HttpPost httpPost = new HttpPost(HTTPS_PROTOCOL_PREFIX + host + resource);
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            httpPost.addHeader(entry.getKey(), entry.getValue());
        }
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(requestBody.getBytes(StandardCharsets.UTF_8), CONTENT_TYPE));
        httpPost.setConfig(RequestConfig.custom().setConnectionRequestTimeout(timeoutMillis).setConnectTimeout(timeoutMillis).setSocketTimeout(timeoutMillis).setNormalizeUri(false).build());
        HttpClientBuilder builder = HttpClientBuilder.create();
        PortingUtil.initiateClientConfigInstance();
        if (null != clientProxyConfig) {
            builder.setProxy(new HttpHost(clientProxyConfig.getHost(), clientProxyConfig.getPort()));
        }
        if (LOGGER.isTraceEnabled()) {
            StringBuilder logBuilder = new StringBuilder();
            logBuilder.append("Try make post HTTP request").append('\n');
            logBuilder.append("UTC Time = ").append(PortingUtil.getAwsCurrentUtcTimestamp()).append('\n');
            logBuilder.append("POST ").append(HTTPS_PROTOCOL_PREFIX).append(host).append(resource).append('\n');
            logBuilder.append("Headers:\n");
            for (Header header : httpPost.getAllHeaders()) {
                if (header.getName().equalsIgnoreCase("Authorization")) {
                    logBuilder.append(LoggingUtil.redactPii(header.toString(), 30)).append("\n");
                    continue;
                }
                logBuilder.append(header.toString()).append("\n");
            }
            logBuilder.append("Request body:\n");
            logBuilder.append(requestBody);
            logBuilder.append('\n');
            if (null != clientProxyConfig) {
                logBuilder.append("Client proxy config: ");
                logBuilder.append(clientProxyConfig.getHost()).append(":").append(clientProxyConfig.getPort());
            }
            LOGGER.trace(logBuilder.toString());
        }
        Header[] headerArray = null;
        try (CloseableHttpClient httpClient = builder.build();){
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int status = response.getStatusLine().getStatusCode();
            String body = null;
            HttpEntity respEntity = response.getEntity();
            if (respEntity != null) {
                body = EntityUtils.toString((HttpEntity)respEntity);
            }
            LoggingUtil.traceLog(LOGGER, "HTTP Response status = {0}", status);
            if (LOGGER.isTraceEnabled()) {
                for (Header header : response.getAllHeaders()) {
                    LoggingUtil.traceLog(LOGGER, "HTTP Response header = {0}", header.toString());
                }
            }
            ApiGatewayResponse apiGatewayResponse = new ApiGatewayResponse(status, body);
            return apiGatewayResponse;
        }
        catch (Throwable object) {
            headerArray = object;
            throw object;
        }
    }

    public static boolean isClientConfigurationInitialized() {
        return null != sdkHttpClient;
    }

    public static void logWebException(Exception e) {
    }

    static SdkHttpClient getSdkHttpClient() {
        PortingUtil.initiateClientConfigInstance();
        return sdkHttpClient;
    }

    static void resetClientConfiguration() {
        LoggingUtil.traceLog(LOGGER, "Reset client configuration", new Object[0]);
        sdkHttpClient = null;
    }

    static void initiateClientConfigInstance() {
        if (null == sdkHttpClient) {
            ApacheHttpClient.Builder httpClientBuilder = ApacheHttpClient.builder();
            LicenseKeyRemoteConfigurer.ProxyConfig proxyConfig = LicenseKeyRemoteConfigurer.getProxyConfig();
            if (proxyConfig == null) {
                proxyConfig = PortingUtil.getSystemProxyConfig();
            }
            if (null != proxyConfig) {
                URI uri;
                try {
                    uri = new URI(String.format("//%s:%s", proxyConfig.getHost(), proxyConfig.getPort()));
                }
                catch (URISyntaxException e) {
                    throw new LicenseKeyRemoteException("Proxy host or port value is invalid", e);
                }
                ProxyConfiguration.Builder proxyConfigBuilder = ProxyConfiguration.builder().endpoint(uri);
                httpClientBuilder.proxyConfiguration((ProxyConfiguration)proxyConfigBuilder.build());
                clientProxyConfig = proxyConfig;
            }
            sdkHttpClient = httpClientBuilder.build();
        }
    }

    private static LicenseKeyRemoteConfigurer.ProxyConfig getSystemProxyConfig() {
        try {
            String proxyHost = System.getProperty("https.proxyHost");
            String proxyPort = System.getProperty("https.proxyPort");
            if (proxyHost == null || proxyPort == null) {
                proxyHost = System.getProperty("http.proxyHost");
                proxyPort = System.getProperty("http.proxyPort");
            }
            if (proxyHost == null || proxyPort == null) {
                String proxyUrl;
                String envHttps = System.getenv("HTTPS_PROXY");
                String envHttp = System.getenv("HTTP_PROXY");
                String string = proxyUrl = envHttps != null ? envHttps : envHttp;
                if (proxyUrl != null) {
                    URI uri = new URI(proxyUrl);
                    proxyHost = uri.getHost();
                    proxyPort = Integer.toString(uri.getPort());
                }
            }
            return proxyHost == null || proxyPort == null ? null : new LicenseKeyRemoteConfigurer.ProxyConfig(proxyHost, Integer.parseInt(proxyPort));
        }
        catch (Exception ignored) {
            LoggingUtil.traceLog(LOGGER, "Failed to get system proxy config", ignored, new Object[0]);
            return null;
        }
    }
}

