/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.pdf.Barcode;
import com.itextpdf.text.pdf.Barcode128;
import com.itextpdf.text.pdf.Barcode39;
import com.itextpdf.text.pdf.BarcodeDatamatrix;
import com.itextpdf.text.pdf.BarcodeInter25;
import com.itextpdf.text.pdf.BarcodePDF417;
import com.itextpdf.text.pdf.BarcodeQRCode;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.qrcode.EncodeHintType;
import com.itextpdf.text.pdf.qrcode.ErrorCorrectionLevel;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.xtra.xfa.element.AbstractDrawer;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.Deflater;

public class BarcodeDrawer
extends AbstractDrawer {
    public static final String CODE128 = "code128";
    public static final String CODE128A = "code128a";
    public static final String CODE128B = "code128b";
    public static final String CODE128C = "code128c";
    public static final String PDF417 = "pdf417";
    public static final String CODE30F9 = "code3Of9";
    public static final String CODE30F9EXT = "code3Of9extended";
    public static final String CODE2OF5INTER = "code2of5interleaved";
    public static final String QRCODE = "QRCode";
    public static final String DATA_MATRIX = "dataMatrix";
    private final BaseColor barcodeColor = BaseColor.BLACK;
    private final BaseColor textColor = BaseColor.BLACK;
    protected Barcode barcode;
    protected BarcodePDF417 pdf417Barcode;
    protected BarcodeQRCode qrBarcode;
    protected BarcodeDatamatrix datamatrixBarcode;
    protected float width;
    protected static final float DEFAULT_MODULE_HEIGHT = CssUtils.getInstance().parsePxInCmMmPcToPt("5mm");
    protected static final float DEFAULT_MODULE_WIDTH = CssUtils.getInstance().parsePxInCmMmPcToPt("0.25mm");
    protected float moduleHeight = DEFAULT_MODULE_HEIGHT;
    protected float moduleWidth = DEFAULT_MODULE_WIDTH;
    Integer errorCorrectionLevel = null;

    public BarcodeDrawer(Map<String, String> attributes, String code, Float width) {
        this.width = width.floatValue();
        code = code.replace("\ufffc", "\t");
        String type = "";
        Float dataLength = null;
        Float wideNarrowRatio = Float.valueOf(3.0f);
        String checksum = null;
        if (attributes != null) {
            String wideNarrowRationAttrVal;
            String moduleWidthStr;
            String moduleHeightStr;
            type = attributes.get("type");
            checksum = attributes.get("checksum");
            this.errorCorrectionLevel = XFAUtil.parseInt(attributes.get("errorCorrectionLevel"));
            String dataLengthAttr = attributes.get("dataLength");
            if (dataLengthAttr != null && dataLengthAttr.length() > 0) {
                dataLength = XFAUtil.parseFloat(dataLengthAttr);
            }
            if ((moduleHeightStr = attributes.get("moduleHeight")) != null) {
                this.moduleHeight = CssUtils.getInstance().parsePxInCmMmPcToPt(moduleHeightStr);
            }
            if ((moduleWidthStr = attributes.get("moduleWidth")) != null) {
                this.moduleWidth = CssUtils.getInstance().parsePxInCmMmPcToPt(moduleWidthStr);
            }
            if ((wideNarrowRationAttrVal = attributes.get("wideNarrowRatio")) != null && wideNarrowRationAttrVal.length() > 0) {
                try {
                    if (wideNarrowRationAttrVal.contains(":")) {
                        String[] values = wideNarrowRationAttrVal.split(":");
                        if (values.length == 2) {
                            Float wide = XFAUtil.parseFloat(values[0]);
                            Float narrow = XFAUtil.parseFloat(values[1]);
                            if (wide != null && wide.floatValue() > 0.0f && narrow != null && narrow.floatValue() > 0.0f) {
                                wideNarrowRatio = Float.valueOf(wide.floatValue() / narrow.floatValue());
                            }
                        }
                    } else {
                        wideNarrowRatio = XFAUtil.parseFloat(wideNarrowRationAttrVal);
                        if (wideNarrowRatio == null || wideNarrowRatio.floatValue() <= 0.0f) {
                            wideNarrowRatio = Float.valueOf(3.0f);
                        }
                    }
                }
                catch (Exception exc) {
                    wideNarrowRatio = Float.valueOf(3.0f);
                }
            }
        }
        if (PDF417.equalsIgnoreCase(type)) {
            if (code.length() > 0) {
                byte[] text = code.getBytes();
                String dataPrep = null;
                if (attributes != null) {
                    dataPrep = attributes.get("dataPrep");
                }
                this.pdf417Barcode = new BarcodePDF417();
                if (this.errorCorrectionLevel != null) {
                    this.pdf417Barcode.setOptions(this.pdf417Barcode.getOptions() | 0x10);
                    this.pdf417Barcode.setErrorLevel(this.errorCorrectionLevel);
                }
                if ("flateCompress".equals(dataPrep)) {
                    byte[] output = new byte[5 * text.length + 100];
                    Deflater compresser = new Deflater();
                    compresser.setInput(text);
                    compresser.finish();
                    int len = compresser.deflate(output, 2, output.length - 2);
                    output[0] = -127;
                    output[1] = 1;
                    text = Arrays.copyOfRange(output, 0, len + 2);
                }
                this.pdf417Barcode.setText(text);
            }
        } else if (QRCODE.equalsIgnoreCase(type)) {
            ErrorCorrectionLevel qrCodeErrorCorrection = null;
            if (this.errorCorrectionLevel != null) {
                switch (this.errorCorrectionLevel) {
                    case 0: {
                        qrCodeErrorCorrection = ErrorCorrectionLevel.L;
                        break;
                    }
                    case 1: {
                        qrCodeErrorCorrection = ErrorCorrectionLevel.M;
                        break;
                    }
                    case 2: {
                        qrCodeErrorCorrection = ErrorCorrectionLevel.Q;
                        break;
                    }
                    case 3: {
                        qrCodeErrorCorrection = ErrorCorrectionLevel.H;
                    }
                }
            }
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            if (qrCodeErrorCorrection != null) {
                hints.put(EncodeHintType.ERROR_CORRECTION, qrCodeErrorCorrection);
            }
            if (code != null && code.length() != 0) {
                this.qrBarcode = new BarcodeQRCode(code, 1, 1, hints);
            }
        } else if (DATA_MATRIX.equalsIgnoreCase(type)) {
            this.datamatrixBarcode = new BarcodeDatamatrix();
            this.datamatrixBarcode.setForceSquareSize(true);
            try {
                this.datamatrixBarcode.generate(code);
            }
            catch (UnsupportedEncodingException qrCodeErrorCorrection) {}
        } else if (CODE128.equalsIgnoreCase(type) || CODE128A.equalsIgnoreCase(type) || CODE128B.equalsIgnoreCase(type) || CODE128C.equalsIgnoreCase(type)) {
            String fakeCode;
            this.barcode = new Barcode128();
            String subtype = type.substring(CODE128.length());
            Barcode128.Barcode128CodeSet codeSet = Barcode128.Barcode128CodeSet.B;
            if ("A".equals(subtype)) {
                codeSet = Barcode128.Barcode128CodeSet.A;
            } else if ("C".equals(subtype)) {
                codeSet = Barcode128.Barcode128CodeSet.C;
            }
            ((Barcode128)this.barcode).setCodeSet(codeSet);
            String string = fakeCode = code.length() != 0 ? code : "1";
            while (dataLength != null && (float)fakeCode.length() < dataLength.floatValue()) {
                fakeCode = fakeCode + fakeCode;
            }
            if (dataLength != null) {
                fakeCode = fakeCode.substring(0, dataLength.intValue());
            }
            this.barcode.setCode(fakeCode);
            this.barcode.setX(this.barcode.getX() * width.floatValue() / this.barcode.getBarcodeSize().getWidth());
        } else if (CODE30F9.equalsIgnoreCase(type) || CODE30F9EXT.equalsIgnoreCase(type)) {
            this.barcode = new Barcode39();
            if (CODE30F9EXT.equalsIgnoreCase(type)) {
                this.barcode.setExtended(true);
                try {
                    Barcode39.getCode39Ex(code);
                }
                catch (IllegalArgumentException exc) {
                    code = "";
                }
            } else {
                code = code.toUpperCase();
                try {
                    Barcode39.getBarsCode39(code);
                }
                catch (IllegalArgumentException exc) {
                    code = "";
                }
            }
            float barcodeLength = (dataLength != null ? dataLength.floatValue() : (float)code.length()) + 2.0f;
            if ("auto".equals(checksum)) {
                this.barcode.setGenerateChecksum(true);
                barcodeLength += 1.0f;
            }
            this.barcode.setX(width.floatValue() / (barcodeLength * (6.0f + 3.0f * wideNarrowRatio.floatValue()) + (barcodeLength - 1.0f)));
        } else if (CODE2OF5INTER.equalsIgnoreCase(type)) {
            this.barcode = new BarcodeInter25();
            float barcodeLength = dataLength != null ? dataLength.floatValue() : (float)code.length();
            this.barcode.setX(width.floatValue() / (barcodeLength * (3.0f + 2.0f * wideNarrowRatio.floatValue()) + 6.0f + wideNarrowRatio.floatValue()));
        } else {
            this.barcode = new Barcode128();
        }
        if (this.barcode != null) {
            if (code.length() > 1 && code.startsWith("*") && code.endsWith("*")) {
                code = code.substring(1, code.length() - 1);
            }
            if (code.length() == 0) {
                this.barcode = null;
            } else {
                this.barcode.setCode(code);
                this.barcode.setN(wideNarrowRatio.floatValue());
                this.barcode.setFont(null);
            }
        }
    }

    public float getBarcodeWidth() {
        if (this.barcode != null) {
            return this.barcode.getBarcodeSize().getWidth();
        }
        if (this.pdf417Barcode != null) {
            return this.pdf417Barcode.getBarcodeSize().getWidth() * this.moduleWidth;
        }
        if (this.qrBarcode != null) {
            return this.qrBarcode.getBarcodeSize().getWidth() * this.moduleWidth;
        }
        if (this.datamatrixBarcode != null) {
            return (float)this.datamatrixBarcode.getWidth() * this.moduleWidth;
        }
        return 0.0f;
    }

    public float getBarcodeHeight() {
        if (this.barcode != null) {
            return this.barcode.getBarcodeSize().getHeight();
        }
        if (this.pdf417Barcode != null) {
            return this.pdf417Barcode.getBarcodeSize().getHeight() * this.moduleHeight;
        }
        if (this.qrBarcode != null) {
            return this.qrBarcode.getBarcodeSize().getHeight() * this.moduleWidth;
        }
        if (this.datamatrixBarcode != null) {
            return (float)this.datamatrixBarcode.getHeight() * this.moduleHeight;
        }
        return 0.0f;
    }

    public void setBarHeight(float height) {
        if (this.barcode != null) {
            this.barcode.setBarHeight(height);
        } else if (this.pdf417Barcode != null) {
            float verticalMargin = 6.0f;
            this.pdf417Barcode.setOptions(this.pdf417Barcode.getOptions() | 2);
            int codeBitsInRow = (int)(this.width / this.moduleWidth);
            this.pdf417Barcode.setCodeColumns(codeBitsInRow / 17 - 4);
            this.moduleHeight = (height -= verticalMargin) / this.pdf417Barcode.getBarcodeSize().getHeight();
            if (this.moduleHeight > this.moduleWidth * 15.0f) {
                this.moduleHeight = DEFAULT_MODULE_HEIGHT;
                this.pdf417Barcode.setOptions(this.pdf417Barcode.getOptions() & 0xFFFFFFFD | 4);
                this.pdf417Barcode.setCodeRows((int)(height / this.moduleHeight));
                this.moduleWidth = this.width / this.pdf417Barcode.getBarcodeSize().getWidth();
            }
        } else if (this.qrBarcode != null) {
            this.moduleWidth = Math.min(this.moduleWidth, this.width / this.qrBarcode.getBarcodeSize().getWidth());
        } else if (this.datamatrixBarcode != null) {
            this.moduleWidth = Math.min(this.moduleWidth, this.width / (float)this.datamatrixBarcode.getWidth());
        }
    }

    @Override
    public void draw(PdfContentByte canvas, XFARectangle borderArea) {
        if (this.barcode != null) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            this.barcode.placeBarcode(canvas, this.barcodeColor, this.textColor);
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        } else if (this.pdf417Barcode != null) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            this.pdf417Barcode.placeBarcode(canvas, this.barcodeColor, this.moduleHeight, this.moduleWidth);
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        } else if (this.qrBarcode != null) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            this.qrBarcode.placeBarcode(canvas, this.barcodeColor, this.moduleWidth);
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        } else if (this.datamatrixBarcode != null) {
            if (canvas.isTagged()) {
                canvas.openMCBlock(this);
            }
            this.datamatrixBarcode.placeBarcode(canvas, this.barcodeColor, this.moduleHeight, this.moduleWidth);
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this);
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.barcode == null && this.pdf417Barcode == null && this.qrBarcode == null && this.datamatrixBarcode == null;
    }

    public boolean barcodeHasTextOnIt() {
        return this.pdf417Barcode == null && this.qrBarcode == null && this.datamatrixBarcode == null;
    }
}

