/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.element.TrailerLeaderElement;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.resolver.SomExpression;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.ArrayList;
import java.util.List;

public class OverflowConditions {
    private List<TrailerLeaderElement> leader;
    private List<TrailerLeaderElement> trailer;
    private Positioner leaderParent;
    private Positioner trailerParent;

    public OverflowConditions(Tag tag, FlattenerContext referenceResolver, OverflowConditions parent, Positioner parentPositioner) {
        String leaderRef = null;
        String trailerRef = null;
        if (tag != null) {
            if (tag.getName().equalsIgnoreCase("break")) {
                leaderRef = tag.getAttributes().get("overflowLeader");
                trailerRef = tag.getAttributes().get("overflowTrailer");
            } else if (tag.getName().equalsIgnoreCase("overflow")) {
                leaderRef = tag.getAttributes().get("leader");
                trailerRef = tag.getAttributes().get("trailer");
            }
            this.leaderParent = parentPositioner;
        }
        if (leaderRef != null && leaderRef.length() > 0) {
            String[] leaders = leaderRef.split(" ");
            for (String string : leaders) {
                XFATemplateTag leaderTemplateTag;
                JsNode leaderNode = (JsNode)parentPositioner.resolveNode(string);
                if (leaderNode == null || (leaderTemplateTag = (XFATemplateTag)leaderNode.getTag()) == null) continue;
                if (this.leader == null) {
                    this.leader = new ArrayList<TrailerLeaderElement>();
                }
                this.leader.add(new TrailerLeaderElement(leaderTemplateTag));
            }
        } else if (parent != null) {
            boolean parentFound = false;
            if (parent.leader != null) {
                for (TrailerLeaderElement trailerLeaderElement : parent.leader) {
                    if (trailerLeaderElement.getFormTag() != parentPositioner.getTemplate()) continue;
                    parentFound = true;
                    break;
                }
            }
            if (!parentFound) {
                this.leader = parent.leader;
                this.leaderParent = parent.leaderParent;
            }
        }
        if (trailerRef != null && trailerRef.length() > 0) {
            String[] trailers = trailerRef.split(" ");
            for (String string : trailers) {
                FormNode res = new SomExpression(string).resolveNode(parentPositioner.getTemplate(), true);
                if (!(res instanceof XFATemplateTag)) continue;
                if (this.trailer == null) {
                    this.trailer = new ArrayList<TrailerLeaderElement>();
                }
                this.trailer.add(new TrailerLeaderElement((XFATemplateTag)res));
            }
            this.trailerParent = parentPositioner;
        } else if (parent != null) {
            this.trailer = parent.trailer;
            this.trailerParent = parent.trailerParent;
        }
    }

    public TrailerLeaderElement getCurrentLeader() {
        if (this.leader != null && this.leader.size() > 0) {
            return this.leader.get(0);
        }
        return null;
    }

    public TrailerLeaderElement getNextLeader() {
        TrailerLeaderElement leaderElement = null;
        if (this.leader != null && this.leader.size() > 0) {
            leaderElement = this.getNextElement(this.leader);
        }
        return leaderElement;
    }

    public TrailerLeaderElement getCurrentTrailer() {
        if (this.trailer != null && this.trailer.size() > 0) {
            return this.trailer.get(0);
        }
        return null;
    }

    public TrailerLeaderElement getNextTrailer() {
        TrailerLeaderElement trailerElement = null;
        if (this.trailer != null && this.trailer.size() > 0) {
            trailerElement = this.getNextElement(this.trailer);
        }
        return trailerElement;
    }

    public Positioner getLeaderParent() {
        return this.leaderParent;
    }

    public void setLeaderParent(Positioner leaderParent) {
        this.leaderParent = leaderParent;
    }

    public Positioner getTrailerParent() {
        return this.trailerParent;
    }

    public void setTrailerParent(Positioner trailerParent) {
        this.trailerParent = trailerParent;
    }

    private TrailerLeaderElement getNextElement(List<TrailerLeaderElement> elementList) {
        TrailerLeaderElement element = elementList.get(0);
        if (!element.incrementOccur()) {
            elementList.remove(0);
            if (elementList.size() > 0) {
                return this.getNextElement(elementList);
            }
            element = null;
        }
        return element;
    }
}

