/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.tool.xml.xtra.xfa.bind.DataTreeResolver;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.UiElement;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class SignatureElement
extends UiElement {
    private static HashSet<Character> charsToEscape = new HashSet<Character>(){
        {
            this.add(Character.valueOf('\\'));
            this.add(Character.valueOf('.'));
            this.add(Character.valueOf('['));
            this.add(Character.valueOf(']'));
            this.add(Character.valueOf('{'));
            this.add(Character.valueOf('}'));
            this.add(Character.valueOf('('));
            this.add(Character.valueOf(')'));
            this.add(Character.valueOf('*'));
            this.add(Character.valueOf('+'));
            this.add(Character.valueOf('-'));
            this.add(Character.valueOf('?'));
            this.add(Character.valueOf('^'));
            this.add(Character.valueOf('$'));
            this.add(Character.valueOf('|'));
        }
    };
    protected FlattenerContext flattenerContext;
    protected List<PRIndirectReference> copiedReferences = null;
    protected PdfWriter writer = null;

    public SignatureElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement, FlattenerContext flattenerContext) {
        super(elementTag, elementRec, document, contentElement);
        this.flattenerContext = flattenerContext;
    }

    @Override
    protected boolean isTextWidget() {
        return true;
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        Map<String, PdfDictionary> signatureFields;
        String fullName = "";
        XFATemplateTag parent = (XFATemplateTag)this.elementTag.retrieveParent();
        while (!"template".equals(parent.getName())) {
            String dataRef = parent.getDataRef();
            if (dataRef != null) {
                String[] nameAndIndex = DataTreeResolver.splitDataRefItem(dataRef);
                fullName = SignatureElement.regExEscape(nameAndIndex[0] + "[" + nameAndIndex[1] + "].") + fullName;
            } else if ("subform".equals(parent.getName())) {
                fullName = ".*\\." + fullName;
            }
            parent = parent.getParent();
        }
        if (fullName.endsWith("\\.")) {
            fullName = fullName.substring(0, fullName.length() - 2);
        }
        if ((signatureFields = this.flattenerContext.getSignatureFields()) != null && !signatureFields.isEmpty() && this.flattenerContext.getReader() != null) {
            PdfStream stream;
            PdfDictionary ap;
            PdfDictionary signature = null;
            for (Map.Entry<String, PdfDictionary> entry : signatureFields.entrySet()) {
                if (!entry.getKey().matches(fullName)) continue;
                signature = entry.getValue();
            }
            if (signature != null && (ap = signature.getAsDict(PdfName.AP)) != null && (stream = ap.getAsStream(PdfName.N)) != null) {
                PdfArray bbox = stream.getAsArray(PdfName.BBOX);
                float height = 0.0f;
                try {
                    height = bbox.getAsNumber(3).floatValue() - bbox.getAsNumber(1).floatValue();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.writer = canvas.getPdfWriter();
                PdfObject obj = this.copyObject(stream);
                this.applyMargins(this.elementRec);
                canvas.addFormXObj((PdfStream)obj, new PdfName(fullName.replaceAll("\\\\", "")), 1.0f, 0.0f, 0.0f, 1.0f, this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - height);
                this.unapplyMargins(this.elementRec);
            }
        }
        return super.draw(canvas, parentBoundingBox);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    private static String regExEscape(String source) {
        String result = "";
        for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            result = charsToEscape.contains(Character.valueOf(c)) ? result + '\\' + c : result + c;
        }
        return result;
    }

    private PdfObject copyObject(PdfObject in) throws BadPdfFormatException, IOException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type()) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type() < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        System.out.println("CANNOT COPY type " + in.type());
        return null;
    }

    private PdfDictionary copyDictionary(PdfDictionary in) throws BadPdfFormatException, IOException {
        PdfDictionary out = new PdfDictionary();
        for (PdfName element : in.getKeys()) {
            PdfName key = element;
            PdfObject value = in.get(key);
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.put(key, res);
        }
        return out;
    }

    private PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException {
        if (this.copiedReferences == null) {
            this.copiedReferences = new ArrayList<PRIndirectReference>();
        }
        if (this.copiedReferences.contains(in)) {
            return in;
        }
        PdfObject obj = PdfReader.getPdfObjectRelease(in);
        PdfIndirectReference out = this.writer.addToBody(obj).getIndirectReference();
        this.copiedReferences.add(in);
        return out;
    }

    private PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray();
        ListIterator<PdfObject> i = in.listIterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.add(res);
        }
        return out;
    }

    protected PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        for (PdfName element : in.getKeys()) {
            PdfName key = element;
            PdfObject value = in.get(key);
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.put(key, res);
        }
        return out;
    }
}

