/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.tool.xml.xtra.xfa.js.IJsObject;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContainer;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataModel;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataValue;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.js.JsXfa;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsObject;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.Scriptable;

public class JsTree
extends RhinoJsObject {
    protected static final JsTree treeJsObject = new JsTree("tree");
    protected static final ConcurrentHashMap<String, String> shortcuts = new ConcurrentHashMap();
    protected FlattenerContext flattenerContext;

    public JsTree(String className) {
        super(className);
        this.setPrototype((Scriptable)rhinoJsObject);
        this.defineFunctionProperties(new String[]{"resolveNode"}, JsTree.class, 4);
        this.defineFunctionProperties(new String[]{"resolveNodes"}, JsTree.class, 4);
        this.defineProperty("all", JsTree.class, 1);
        this.defineProperty("index", JsTree.class, 1);
        this.defineProperty("somExpression", JsTree.class, 1);
    }

    public JsTree(IJsObject parent) {
        super(parent);
        this.setPrototype((Scriptable)treeJsObject);
        this.defineProperty("parent", parent);
        this.defineProperty("nodes", (Object)new RhinoJsNodeList());
    }

    public RhinoJsNodeList getAll() {
        RhinoJsNodeList nodeInstancesList = null;
        if (this.getParentScope() instanceof IJsObject) {
            Object nodeInstances;
            String name = this.retrieveName();
            Object object = nodeInstances = name != null ? ((IJsObject)this.getParentScope()).getOwnProperty(name) : null;
            if (nodeInstances instanceof RhinoJsNodeList) {
                nodeInstancesList = (RhinoJsNodeList)((Object)nodeInstances);
            } else if (nodeInstances instanceof JsTree) {
                nodeInstancesList = new RhinoJsNodeList();
                nodeInstancesList.append(nodeInstances);
            }
        }
        return nodeInstancesList;
    }

    public Object getIndex() {
        int index = 0;
        RhinoJsNodeList nodeInstancesList = null;
        if (this.getParentScope() instanceof IJsObject) {
            Object nodeInstances;
            String name = this.retrieveName();
            Object object = nodeInstances = name != null ? ((IJsObject)this.getParentScope()).getOwnProperty(name) : null;
            if (nodeInstances instanceof RhinoJsNodeList) {
                nodeInstancesList = (RhinoJsNodeList)((Object)nodeInstances);
                int indexOfThis = nodeInstancesList.indexOfCompareReferences(this);
                index = indexOfThis != -1 ? indexOfThis : (int)nodeInstancesList.getLength();
            }
        }
        return index;
    }

    public Object getSomExpression() {
        Object nameProperty = this.getProperty("name");
        String somExpression = nameProperty instanceof CharSequence ? nameProperty.toString() : this.retrieveName();
        somExpression = somExpression + "[" + this.getIndex() + "]";
        Scriptable parentScope = this.getParentScope();
        if (parentScope instanceof JsTree) {
            somExpression = ((JsTree)parentScope).getSomExpression() + "." + somExpression;
        }
        return somExpression;
    }

    public void addChild(JsTree child) {
        Object currentProperty;
        Object nameProperty;
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        if (nodes == null) {
            nodes = new RhinoJsNodeList();
            this.defineProperty("nodes", (Object)nodes);
        }
        nodes.append(child);
        String childName = child.retrieveName();
        if (childName == null && (nameProperty = child.getProperty("name")) instanceof String) {
            childName = nameProperty.toString();
        }
        if ((currentProperty = this.getOwnProperty(childName)) != null && currentProperty != this) {
            if (currentProperty instanceof RhinoJsNodeList) {
                RhinoJsNodeList nl = (RhinoJsNodeList)((Object)currentProperty);
                nl.append(child);
            } else if (currentProperty instanceof JsTree) {
                this.delete(childName);
                RhinoJsNodeList nl = new RhinoJsNodeList(new Object[]{currentProperty});
                nl.append(child);
                this.defineProperty(childName, (Object)nl);
            } else if (currentProperty instanceof String) {
                this.defineProperty(childName, child);
            }
        } else {
            this.defineProperty(childName, child);
        }
    }

    public JsTree resolveNode(String somExpressions) {
        return this.resolveNodeInt(somExpressions);
    }

    public JsTree resolveNodeInt(String somExpressions) {
        return this.searchNode(somExpressions, true);
    }

    public JsTree searchNodeDown(String somExpressions) {
        return this.searchNode(somExpressions, false);
    }

    public RhinoJsNodeList resolveNodes(String somExpressions) {
        return this.resolveNodesInt(somExpressions);
    }

    public RhinoJsNodeList resolveNodesInt(String somExpressions) {
        return this.searchNodes(somExpressions, true);
    }

    public JsTree searchNode(String somExpressions, boolean up) {
        Stack<String> somExpression = JsTree.splitSOM(somExpressions);
        if (somExpression != null) {
            return this.searchNodeByName(somExpression, up, false, (Integer)this.getIndex());
        }
        somExpressions = somExpressions.replace("#", "");
        return this.searchNodeById(somExpressions, up);
    }

    public JsTree strictSearchNode(String somExpressions) {
        Stack<String> somExpression = JsTree.splitSOM(somExpressions);
        if (somExpression != null) {
            return this.strictSearchNodeByName(somExpression);
        }
        return null;
    }

    protected RhinoJsNodeList searchNodes(String somExpressions, boolean up) {
        RhinoJsNodeList nodes = new RhinoJsNodeList();
        ArrayList<JsTree> nodesList = new ArrayList<JsTree>();
        nodesList.add(this);
        Stack<String> nodePath = JsTree.splitSOM(somExpressions);
        if (nodePath != null && "this".equals(nodePath.peek()) && this instanceof JsXfa && this.flattenerContext != null && this.flattenerContext.getCurrentNode() != null) {
            nodePath.pop();
            nodesList.clear();
            nodesList.add(this.flattenerContext.getCurrentNode());
        }
        if (nodePath != null && "parent".equals(nodePath.peek())) {
            nodePath.pop();
            ArrayList<JsTree> newList = new ArrayList<JsTree>();
            for (JsTree node : nodesList) {
                newList.add((JsTree)node.getParentScope());
            }
            nodesList.clear();
            nodesList.addAll(newList);
        }
        if (nodePath != null) {
            boolean matched = false;
            while (!nodePath.isEmpty()) {
                String nodeName = nodePath.pop();
                String nameKey = "name";
                if (nodeName.startsWith("#")) {
                    nodeName = nodeName.replace("#", "");
                    nameKey = "className";
                }
                XFAUtil.NameIndexPair nameIndexPair = XFAUtil.splitNameIndexPair(nodeName);
                nodeName = nameIndexPair.name;
                int nodeIndexValue = nameIndexPair.index;
                ListIterator<JsTree> nodeItr = nodesList.listIterator();
                while (nodeItr.hasNext()) {
                    JsTree currentNode = (JsTree)nodeItr.next();
                    RhinoJsNodeList matchedChildNodes = currentNode.searchNodesByName(nodeName, nameKey, up, matched);
                    if (matchedChildNodes != null) {
                        if (nodeIndexValue != -1) {
                            if (matchedChildNodes.getLength() <= (long)nodeIndexValue) continue;
                            nodeItr.set((JsTree)matchedChildNodes.item(nodeIndexValue));
                            continue;
                        }
                        nodeItr.remove();
                        int i = 0;
                        while ((long)i < matchedChildNodes.getLength()) {
                            nodeItr.add((JsTree)matchedChildNodes.item(i));
                            ++i;
                        }
                        continue;
                    }
                    Object resolvedProperty = currentNode.getProperty(nodeName);
                    if (resolvedProperty != null) {
                        if (resolvedProperty instanceof RhinoJsNodeList) {
                            Iterator iterator = ((RhinoJsNodeList)((Object)resolvedProperty)).iterator();
                            while (iterator.hasNext()) {
                                Object child = iterator.next();
                                if (child == null) continue;
                                nodes.append(child);
                            }
                        } else {
                            nodes.append(currentNode.getProperty(nodeName));
                        }
                    }
                    nodeItr.remove();
                }
                if (nodesList.isEmpty()) break;
                up = false;
                matched = true;
            }
            for (JsTree node : nodesList) {
                nodes.append(node);
            }
        } else if ((somExpressions = somExpressions.replace("#", "")).endsWith("[*]")) {
            RhinoJsNodeList resolvedNodes = this.searchNodesById(somExpressions.substring(0, somExpressions.length() - 3));
            if (resolvedNodes != null) {
                Iterator iterator = resolvedNodes.iterator();
                while (iterator.hasNext()) {
                    Object obj = iterator.next();
                    nodes.append(obj);
                }
            }
        } else {
            JsTree node = this.searchNodeById(somExpressions, up);
            if (node != null) {
                nodes.append(node);
            }
        }
        return nodes;
    }

    protected Object getNamePropertyByNameKey(String nameKey) {
        Object result = this.getProperty(nameKey);
        if (nameKey.equals("name") && !(result instanceof String)) {
            result = this.retrieveName();
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected JsTree searchNodeByName(Stack<String> somExpression, boolean up, boolean currentNodeIsMatched, int parentNodeIndex) {
        if (somExpression.size() == 0) {
            return this;
        }
        Stack subSomExpression = (Stack)somExpression.clone();
        String nodeName = ((String)subSomExpression.pop()).trim();
        String nameKey = "name";
        if (nodeName.startsWith("#")) {
            nodeName = nodeName.replace("#", "");
            nameKey = "className";
        } else {
            if (!currentNodeIsMatched && nodeName.equals(this.getNamePropertyByNameKey(nameKey)) || nodeName.isEmpty() || nodeName.equals("$") || nodeName.equals("this")) {
                return this.searchNodeByName(subSomExpression, false, true, (Integer)this.getIndex());
            }
            if (nodeName.equals("parent") && this.getParentScope() instanceof JsTree) {
                return ((JsTree)this.getParentScope()).searchNodeByName(subSomExpression, false, true, (Integer)this.getIndex());
            }
            if (nodeName.equals("dataNode") && this instanceof JsContainer && ((JsContainer)this).fetchDataNode(false) instanceof JsTree) {
                return ((JsTree)((JsContainer)this).fetchDataNode(false)).searchNodeByName(subSomExpression, false, true, (Integer)this.getIndex());
            }
            if (nodeName.equals("record") && this instanceof JsXfa) {
                return ((JsTree)((JsXfa)this).getRecord()).searchNodeByName(subSomExpression, false, true, (Integer)this.getIndex());
            }
        }
        XFAUtil.NameIndexPair nameIndexPair = XFAUtil.splitNameIndexPair(nodeName);
        nodeName = nameIndexPair.name;
        int nodeIndexValue = nameIndexPair.index;
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        ArrayList<JsTree> matchedNodes = new ArrayList<JsTree>();
        if (this instanceof SubFormPositioner) {
            for (Object resolvedObj : ((SubFormPositioner)this).resolveAllFromUnnamedSubformRecursively(nodeName)) {
                if (!(resolvedObj instanceof JsTree) || matchedNodes.contains(resolvedObj)) continue;
                matchedNodes.add((JsTree)resolvedObj);
            }
        }
        if (nodes != null) {
            this.get(nodeName, (Scriptable)this);
            int i = 0;
            while ((long)i < nodes.getLength()) {
                Object child = nodes.get(i, (Scriptable)nodes);
                if ((child instanceof JsDataGroup || child instanceof JsDataValue) && nameKey.equals("name") && nodeName.equals(((JsNode)child).retrieveName()) || child instanceof JsTree && nodeName.equals(((JsTree)child).getProperty(nameKey))) {
                    matchedNodes.add((JsTree)child);
                }
                ++i;
            }
        }
        int currentNodeIndex = (Integer)this.getIndex();
        if (!matchedNodes.isEmpty()) {
            if (nodeIndexValue == -1) {
                JsTree node = null;
                for (JsTree matchedNode : matchedNodes) {
                    int matchedNodeIndex = (Integer)matchedNode.getIndex();
                    if (node == null || parentNodeIndex == matchedNodeIndex) {
                        node = matchedNode.searchNodeByName(subSomExpression, false, true, currentNodeIndex);
                    }
                    if (parentNodeIndex != matchedNodeIndex || node == null) continue;
                    break;
                }
                if (node == null) return null;
                return node;
            }
            if (nodeIndexValue >= matchedNodes.size()) return ((JsTree)matchedNodes.get(matchedNodes.size() - 1)).searchNodeByName(subSomExpression, false, false, currentNodeIndex);
            return ((JsTree)matchedNodes.get(nodeIndexValue)).searchNodeByName(subSomExpression, false, true, currentNodeIndex);
        }
        if (up) {
            Object parent = this.getOwnProperty("parent");
            if (!(parent instanceof JsTree)) return null;
            if (!nodeName.equals(((JsTree)parent).getProperty(nameKey)) || !((JsTree)parent).getIndex().equals(nodeIndexValue)) return ((JsTree)parent).searchNodeByName(somExpression, up, false, currentNodeIndex);
            return ((JsTree)parent).searchNodeByName(subSomExpression, false, false, currentNodeIndex);
        }
        if (nodes == null) return null;
        int i = 0;
        while ((long)i < nodes.getLength()) {
            JsTree node;
            Object child = nodes.get(i, (Scriptable)nodes);
            if (child instanceof JsTree && (node = ((JsTree)child).searchNodeByName(somExpression, up, false, currentNodeIndex)) != null) {
                return node;
            }
            ++i;
        }
        return null;
    }

    protected JsTree strictSearchNodeByName(Stack<String> somExpression) {
        if (somExpression.size() == 0) {
            return this;
        }
        Stack subSomExpression = (Stack)somExpression.clone();
        String nodeName = ((String)subSomExpression.pop()).trim();
        String nameKey = "name";
        if (nodeName.startsWith("#")) {
            nodeName = nodeName.replace("#", "");
            nameKey = "className";
        } else if (nodeName.equals("dataNode") && this instanceof JsContainer && ((JsContainer)this).fetchDataNode(true) instanceof JsTree) {
            return ((JsTree)((JsContainer)this).fetchDataNode(true)).strictSearchNodeByName(subSomExpression);
        }
        XFAUtil.NameIndexPair nameIndexPair = XFAUtil.splitNameIndexPair(nodeName);
        nodeName = nameIndexPair.name;
        int nodeIndexValue = nameIndexPair.index;
        if (nodeName.equals("xfa") && this instanceof JsXfa && nodeIndexValue == 0) {
            return this.strictSearchNodeByName(subSomExpression);
        }
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        ArrayList<JsTree> matchedNodes = new ArrayList<JsTree>();
        if (nodes != null) {
            this.get(nodeName, (Scriptable)this);
            int i = 0;
            while ((long)i < nodes.getLength()) {
                Object child = nodes.get(i, (Scriptable)nodes);
                if (child instanceof JsTree && nodeName.equals(((JsTree)child).getProperty(nameKey))) {
                    matchedNodes.add((JsTree)child);
                }
                ++i;
            }
        }
        if (!matchedNodes.isEmpty() && matchedNodes.get(nodeIndexValue) != null) {
            return ((JsTree)matchedNodes.get(nodeIndexValue)).strictSearchNodeByName(subSomExpression);
        }
        return null;
    }

    public static Stack<String> splitSOM(String somExpression) {
        String[] nodes;
        if (somExpression.matches("^som\\(.*\\)")) {
            somExpression = somExpression.replaceAll("^som\\(", "").replaceAll("\\)$", "");
            nodes = somExpression.split("\\.");
        } else {
            nodes = somExpression.split("\\.");
            if (nodes.length == 1 && nodes[0].startsWith("#")) {
                return null;
            }
        }
        Stack<String> nodeStack = new Stack<String>();
        int somLength = nodes.length;
        for (int i = somLength - 1; i >= 0; --i) {
            String nodeName = nodes[i];
            if (shortcuts.containsKey(nodeName)) {
                nodeStack.addAll(JsTree.splitSOM(shortcuts.get(nodeName)));
                continue;
            }
            nodeStack.push(nodeName);
        }
        return nodeStack;
    }

    public JsTree searchNodeByClassName(String nodeName) {
        RhinoJsNodeList matchedNodes = this.searchNodesByName(nodeName, "className", false, false);
        if (matchedNodes != null) {
            return (JsTree)matchedNodes.item(0);
        }
        return null;
    }

    protected RhinoJsNodeList searchNodesByName(String nodeName, String nameKey, boolean up, boolean currentNodeIsMatched) {
        RhinoJsNodeList matchedNodes = new RhinoJsNodeList();
        if (nodeName.isEmpty() || !currentNodeIsMatched && nodeName.equals(this.getProperty(nameKey)) || nodeName.equals("$")) {
            matchedNodes.append(this);
        } else if (this instanceof JsXfa && "record".equals(nodeName) && "name".equals(nameKey)) {
            matchedNodes.append(((JsXfa)this).getRecord());
        } else {
            Object child;
            int i;
            RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
            if (nodes != null) {
                this.get(nodeName, (Scriptable)this);
                i = 0;
                while ((long)i < nodes.getLength()) {
                    child = nodes.get(i, (Scriptable)nodes);
                    if (child instanceof JsTree && nodeName.equals(((JsTree)child).getNamePropertyByNameKey(nameKey))) {
                        matchedNodes.append(child);
                    }
                    ++i;
                }
            }
            if (matchedNodes.getLength() == 0L && this instanceof SubFormPositioner && nameKey.equals("name")) {
                List<Object> resolvedInstances = ((SubFormPositioner)this).resolveAllFromUnnamedSubformRecursively(nodeName);
                for (Object resolvedInstance : resolvedInstances) {
                    if (!(resolvedInstance instanceof JsTree)) continue;
                    matchedNodes.append(resolvedInstance);
                }
            }
            if (matchedNodes.getLength() == 0L) {
                if (up) {
                    Object parent = this.getOwnProperty("parent");
                    if (parent instanceof JsTree) {
                        return ((JsTree)parent).searchNodesByName(nodeName, nameKey, up, false);
                    }
                } else if (nodes != null && !currentNodeIsMatched) {
                    i = 0;
                    while ((long)i < nodes.getLength()) {
                        RhinoJsNodeList node;
                        child = nodes.get(i, (Scriptable)nodes);
                        if (!(!(child instanceof JsTree) || this instanceof JsXfa && JsTree.isDataDomNode((JsTree)child) || (node = ((JsTree)child).searchNodesByName(nodeName, nameKey, up, false)) == null)) {
                            int j = 0;
                            while ((long)j < node.getLength()) {
                                matchedNodes.append(node.item(j));
                                ++j;
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        return matchedNodes.getLength() > 0L ? matchedNodes : null;
    }

    protected JsTree searchNodeById(String nodeId, boolean up) {
        Object parent;
        if (nodeId.equals(this.get("id", (Scriptable)this))) {
            return this;
        }
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                Object node = nodes.get(i, (Scriptable)nodes);
                if (node instanceof JsTree && nodeId.equals(((JsTree)node).get("id", (Scriptable)((JsTree)node)))) {
                    return (JsTree)node;
                }
                if (!up && node instanceof JsTree && (node = ((JsTree)node).searchNodeById(nodeId, false)) != null) {
                    return (JsTree)node;
                }
                ++i;
            }
        }
        if (up && (parent = this.get("parent", (Scriptable)this)) instanceof JsTree) {
            return ((JsTree)parent).searchNodeById(nodeId, false);
        }
        return null;
    }

    protected RhinoJsNodeList searchNodesById(String nodeId) {
        RhinoJsNodeList matchedNodes = new RhinoJsNodeList();
        RhinoJsNodeList nodes = (RhinoJsNodeList)((Object)this.getOwnProperty("nodes"));
        if (nodes != null) {
            int i = 0;
            while ((long)i < nodes.getLength()) {
                Object node = nodes.get(i, (Scriptable)nodes);
                if (node instanceof JsTree && nodeId.equals(((JsTree)node).get("id", (Scriptable)((JsTree)node)))) {
                    matchedNodes.append(node);
                }
                ++i;
            }
        }
        return matchedNodes;
    }

    public String retrieveName() {
        return (String)this.getProperty("name");
    }

    private static boolean isDataDomNode(JsTree node) {
        return node instanceof JsDataModel || node instanceof JsDataGroup || node instanceof JsDataValue;
    }

    static {
        shortcuts.put("$xfa", "xfa");
        shortcuts.put("$data", "xfa.datasets.data");
        shortcuts.put("$template", "xfa.template");
        shortcuts.put("$connectionSet", "xfa.connectionSet");
        shortcuts.put("$form", "xfa.form");
        shortcuts.put("$layout", "xfa.layout");
        shortcuts.put("$host", "xfa.host");
        shortcuts.put("$dataWindow", "xfa.dataWindow");
        shortcuts.put("$event", "xfa.event");
        shortcuts.put("!", "xfa.datasets.");
        shortcuts.put("$record", "xfa.data");
    }
}

