/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.css.XfaCssInheritanceRules;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataGroup;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataModel;
import com.itextpdf.tool.xml.xtra.xfa.js.JsDataValue;
import com.itextpdf.tool.xml.xtra.xfa.js.JsNode;
import com.itextpdf.tool.xml.xtra.xfa.pipe.DataContext;
import com.itextpdf.tool.xml.xtra.xfa.pipe.LocalContextElementHandlerPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XFAHtmlPipeline;
import com.itextpdf.tool.xml.xtra.xfa.tags.DataTag;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.RichTextTags;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class DataPipeline
extends AbstractPipeline<DataContext> {
    private DataTag dataDom;
    private JsNode jsXfa;
    private JsNode dataNodeDom;
    private JsDataModel datasetsNodeDom;
    private DataTag currentEntry;
    private boolean isData;
    private Stack<DataTag> dataTagsStack = new Stack();
    private final Pipeline<?> richTextPipeline;
    private final XFAHtmlPipeline xfaHtmlPipeline;
    private Tag richTextStartTag;
    private XFATemplateTag dataDescription;

    public DataPipeline(Pipeline<?> next, CssAppliers cssAppliers, JsNode jsXfa) {
        super(next);
        this.jsXfa = jsXfa;
        HtmlPipelineContext hpc = new HtmlPipelineContext(cssAppliers);
        hpc.setAcceptUnknown(true).setTagFactory(RichTextTags.getRichTextTagProcessorFactory());
        this.xfaHtmlPipeline = new XFAHtmlPipeline(hpc, new LocalContextElementHandlerPipeline(null));
        this.richTextPipeline = new CssResolverPipeline(new StyleAttrCSSResolver(new XfaCssInheritanceRules(), new CssFilesImpl(), CssUtils.getInstance()), this.xfaHtmlPipeline);
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        if (t.getName().equalsIgnoreCase("datasets") && t.getNameSpace().equalsIgnoreCase("xfa")) {
            this.datasetsNodeDom = new JsDataModel("datasets", this.jsXfa);
        } else if (t.getName().equalsIgnoreCase("dataDescription") && t.getNameSpace().equalsIgnoreCase("dd")) {
            this.dataDescription = (XFATemplateTag)t;
        } else if (t.getName().equalsIgnoreCase("data") && t.getNameSpace().equalsIgnoreCase("xfa")) {
            this.isData = true;
            DataTag rootDataTag = new DataTag(t.getName(), t.getAttributes());
            this.dataTagsStack.push(rootDataTag);
            this.dataNodeDom = new JsDataGroup(rootDataTag, (JsNode)this.datasetsNodeDom);
            this.datasetsNodeDom.addChild(this.dataNodeDom);
            rootDataTag.setNode(this.dataNodeDom);
        } else if (this.isData) {
            DataTag dataTag = new DataTag(t.getName(), t.getAttributes());
            if (this.dataDom == null) {
                this.dataDom = dataTag;
                JsDataGroup node = new JsDataGroup(this.dataDom, this.dataNodeDom);
                this.dataNodeDom.addChild(node);
                this.dataDom.setNode(node);
            } else if (!((DataContext)this.getLocalContext(context)).isRichText()) {
                if ("http://www.w3.org/1999/xhtml".equalsIgnoreCase(t.getAttributes().get("xmlns"))) {
                    this.richTextStartTag = t;
                    this.xfaHtmlPipeline.reset();
                    ((DataContext)this.getLocalContext(context)).setIsRichText(true);
                    Pipeline<?> rtp = ((DataContext)this.getLocalContext(context)).getRichTextPipeline();
                    while (null != (rtp = rtp.init(context))) {
                    }
                } else {
                    DataTag parentTag = this.dataTagsStack.peek();
                    parentTag.addChild(dataTag);
                    if (parentTag.getNode() == null) {
                        DataTag parentParentTag = (DataTag)parentTag.getParent();
                        JsDataGroup parentNode = new JsDataGroup(parentTag, parentParentTag.getNode());
                        parentTag.setNode(parentNode);
                        parentParentTag.getNode().addChild(parentNode);
                    }
                }
            }
            if (!((DataContext)this.getLocalContext(context)).isRichText()) {
                this.currentEntry = dataTag;
                this.dataTagsStack.push(this.currentEntry);
            }
        }
        return this.getNext(context);
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String content, ProcessObject po) throws PipelineException {
        if (null != this.currentEntry) {
            this.currentEntry.setValue(content);
        }
        return this.getNext(context);
    }

    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        if (this.isData) {
            if (t == this.richTextStartTag && "http://www.w3.org/1999/xhtml".equalsIgnoreCase(t.getAttributes().get("xmlns"))) {
                this.richTextStartTag = null;
                ((DataContext)this.getLocalContext(context)).setIsRichText(false);
                List list = (List)((ObjectContext)((LocalContextElementHandlerPipeline)((DataContext)this.getLocalContext(context)).getRichTextPipeline().getNext().getNext()).getLocalContext(context)).get();
                this.currentEntry.addRichTextList(list);
            } else if (this.dataTagsStack.size() > 0 && t.getName().equalsIgnoreCase(((DataTag)this.dataTagsStack.lastElement()).getName())) {
                DataTag closedTag = this.dataTagsStack.pop();
                if (closedTag.getNode() == null) {
                    JsNode parentNode = ((DataTag)closedTag.getParent()).getNode();
                    JsDataValue closedTagNode = new JsDataValue(closedTag, parentNode);
                    closedTag.setNode(closedTagNode);
                    parentNode.addChild(closedTagNode);
                }
                for (Map.Entry<String, String> attr : closedTag.getAttributes().entrySet()) {
                    DataTag attrTag = new DataTag(attr.getKey(), attr.getValue());
                    closedTag.addChild(attrTag);
                }
                DataTag dataTag = this.currentEntry = this.dataTagsStack.size() > 0 ? this.dataTagsStack.peek() : null;
            }
            if (this.isData && t.getName().equalsIgnoreCase("data") && t.getNameSpace().equalsIgnoreCase("xfa") && this.dataTagsStack.size() == 0) {
                this.isData = false;
            }
        } else if (t.getName().equalsIgnoreCase("dataDescription") && t.getNameSpace().equalsIgnoreCase("dd") && this.dataNodeDom != null && this.dataDom != null) {
            String dataName = this.dataDom.getName();
            this.applyDataDescriptionTemplate(this.dataNodeDom.getChild(dataName), (XFATemplateTag)t.getChild(dataName, ""));
        }
        return this.getNext(context);
    }

    private void applyDataDescriptionTemplate(JsNode dataNode, XFATemplateTag dataDescriptionNode) {
        if (dataNode == null || dataDescriptionNode == null) {
            return;
        }
        dataNode.setProtoTemplate(dataDescriptionNode);
        LinkedList<Tag> protoChildren = new LinkedList<Tag>();
        protoChildren.addAll(dataDescriptionNode.getChildren());
        while (!protoChildren.isEmpty()) {
            Tag protoChild = (Tag)protoChildren.poll();
            if ("group".equals(protoChild.getName()) && "dd".equals(protoChild.getNameSpace())) {
                protoChildren.addAll(protoChild.getChildren());
                continue;
            }
            List<FormNode> dataChildren = dataNode.retrieveChildren(protoChild.getName());
            for (FormNode dataChild : dataChildren) {
                this.applyDataDescriptionTemplate((JsNode)dataChild, (XFATemplateTag)protoChild);
            }
        }
    }

    public DataTag getDataDom() {
        return this.dataDom;
    }

    public void setDataDom(DataTag dataTag) {
        this.dataDom = dataTag;
    }

    public JsNode getDataNodeDom() {
        return this.dataNodeDom;
    }

    public void setDataNodeDom(JsNode dataNodeDom) {
        this.dataNodeDom = dataNodeDom;
    }

    public JsNode getDatasetsNodeDom() {
        return this.datasetsNodeDom;
    }

    public void setDataSetsNodeDom(JsDataModel datasetsNodeDom) {
        this.datasetsNodeDom = datasetsNodeDom;
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        DataContext dCtx = new DataContext();
        dCtx.setRichTextPipeline(this.richTextPipeline);
        context.put(this.getContextKey(), dCtx);
        return super.init(context);
    }

    public Pipeline<?> getNext(WorkerContext context) throws PipelineException {
        DataContext dataContext = (DataContext)this.getLocalContext(context);
        if (dataContext.isRichText()) {
            return dataContext.getRichTextPipeline();
        }
        return this.getNext();
    }
}

