/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.PdfAppearance;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfFormField;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RadioCheckField;
import java.io.IOException;

@Deprecated
public class PdfARadioCheckField
extends RadioCheckField {
    private static final PdfName off = new PdfName("Off");
    protected static final String check = "0.8 0 0 0.8 0.3 0.5 cm 0 0 m\n0.066 -0.026 l\n0.137 -0.15 l\n0.259 0.081 0.46 0.391 0.553 0.461 c\n0.604 0.489 l\n0.703 0.492 l\n0.543 0.312 0.255 -0.205 0.154 -0.439 c\n0.069 -0.399 l\n0.035 -0.293 -0.039 -0.136 -0.091 -0.057 c\nh\nf\n";
    protected static final String circle = "1 0 0 1 0.86 0.5 cm 0 0 m\n0 0.204 -0.166 0.371 -0.371 0.371 c\n-0.575 0.371 -0.741 0.204 -0.741 0 c\n-0.741 -0.204 -0.575 -0.371 -0.371 -0.371 c\n-0.166 -0.371 0 -0.204 0 0 c\nf\n";
    protected static final String cross = "1 0 0 1 0.85 0.8 cm 0 0 m\n-0.172 -0.027 l\n-0.332 -0.184 l\n-0.443 -0.019 l\n-0.475 -0.009 l\n-0.568 -0.168 l\n-0.453 -0.324 l\n-0.58 -0.497 l\n-0.59 -0.641 l\n-0.549 -0.627 l\n-0.543 -0.612 -0.457 -0.519 -0.365 -0.419 c\n-0.163 -0.572 l\n-0.011 -0.536 l\n-0.004 -0.507 l\n-0.117 -0.441 l\n-0.246 -0.294 l\n-0.132 -0.181 l\n0.031 -0.04 l\nh\nf\n";
    protected static final String diamond = "1 0 0 1 0.55 0.12 cm 0 0 m\n0.376 0.376 l\n0 0.751 l\n-0.376 0.376 l\nh\nf\n";
    protected static final String square = "1 0 0 1 0.885 0.835 cm 0 0 -0.669 -0.67 re\nf\n";
    protected static final String star = "0.95 0 0 0.95 0.9 0.6 cm 0 0 m\n-0.291 0 l\n-0.381 0.277 l\n-0.47 0 l\n-0.761 0 l\n-0.526 -0.171 l\n-0.616 -0.448 l\n-0.381 -0.277 l\n-0.145 -0.448 l\n-0.236 -0.171 l\nh\nf\n";
    protected static String[] typeStreams = new String[]{"0.8 0 0 0.8 0.3 0.5 cm 0 0 m\n0.066 -0.026 l\n0.137 -0.15 l\n0.259 0.081 0.46 0.391 0.553 0.461 c\n0.604 0.489 l\n0.703 0.492 l\n0.543 0.312 0.255 -0.205 0.154 -0.439 c\n0.069 -0.399 l\n0.035 -0.293 -0.039 -0.136 -0.091 -0.057 c\nh\nf\n", "1 0 0 1 0.86 0.5 cm 0 0 m\n0 0.204 -0.166 0.371 -0.371 0.371 c\n-0.575 0.371 -0.741 0.204 -0.741 0 c\n-0.741 -0.204 -0.575 -0.371 -0.371 -0.371 c\n-0.166 -0.371 0 -0.204 0 0 c\nf\n", "1 0 0 1 0.85 0.8 cm 0 0 m\n-0.172 -0.027 l\n-0.332 -0.184 l\n-0.443 -0.019 l\n-0.475 -0.009 l\n-0.568 -0.168 l\n-0.453 -0.324 l\n-0.58 -0.497 l\n-0.59 -0.641 l\n-0.549 -0.627 l\n-0.543 -0.612 -0.457 -0.519 -0.365 -0.419 c\n-0.163 -0.572 l\n-0.011 -0.536 l\n-0.004 -0.507 l\n-0.117 -0.441 l\n-0.246 -0.294 l\n-0.132 -0.181 l\n0.031 -0.04 l\nh\nf\n", "1 0 0 1 0.55 0.12 cm 0 0 m\n0.376 0.376 l\n0 0.751 l\n-0.376 0.376 l\nh\nf\n", "1 0 0 1 0.885 0.835 cm 0 0 -0.669 -0.67 re\nf\n", "0.95 0 0 0.95 0.9 0.6 cm 0 0 m\n-0.291 0 l\n-0.381 0.277 l\n-0.47 0 l\n-0.761 0 l\n-0.526 -0.171 l\n-0.616 -0.448 l\n-0.381 -0.277 l\n-0.145 -0.448 l\n-0.236 -0.171 l\nh\nf\n"};

    public PdfARadioCheckField(PdfWriter writer, Rectangle box, String fieldName, String onValue) {
        super(writer, box, fieldName, onValue);
    }

    @Override
    protected PdfFormField getField(boolean isRadio) throws IOException, DocumentException {
        PdfDictionary n;
        PdfFormField field = super.getField(isRadio);
        PdfDictionary ap = field.getAsDict(PdfName.AP);
        if (ap != null && (n = ap.getAsDict(PdfName.N)) != null) {
            PdfObject stream = null;
            stream = this.isChecked() ? n.get(new PdfName(this.getOnValue())) : n.get(off);
            if (stream != null) {
                ap.put(PdfName.N, stream);
            }
        }
        return field;
    }

    @Override
    public void setCheckType(int checkType) {
        if (checkType < 1 || checkType > 6) {
            checkType = 2;
        }
        this.checkType = checkType;
    }

    @Override
    public PdfAppearance getAppearance(boolean isRadio, boolean on) throws IOException, DocumentException {
        if (isRadio && this.checkType == 2) {
            return this.getAppearanceRadioCircle(on);
        }
        PdfAppearance app = this.getBorderAppearance();
        if (!on) {
            return app;
        }
        boolean borderExtra = this.borderStyle == 2 || this.borderStyle == 3;
        float bw2 = this.borderWidth;
        if (borderExtra) {
            bw2 *= 2.0f;
        }
        float offsetX = borderExtra ? 2.0f * this.borderWidth : this.borderWidth;
        offsetX = Math.max(offsetX, 1.0f);
        float offX = Math.min(bw2, offsetX);
        float wt = this.box.getWidth() - 2.0f * offX;
        float ht = this.box.getHeight() - 2.0f * offX;
        app.saveState();
        app.rectangle(offX, offX, wt, ht);
        app.clip();
        app.newPath();
        if (this.textColor == null) {
            app.resetGrayFill();
        } else {
            app.setColorFill(this.textColor);
        }
        float size = Math.min(this.box.getWidth(), this.box.getHeight());
        app.concatCTM(size, 0.0f, 0.0f, size, 0.0f, 0.0f);
        app.getInternalBuffer().append(typeStreams[this.checkType - 1]);
        app.restoreState();
        return app;
    }

    @Override
    protected BaseFont getRealFont() throws IOException, DocumentException {
        return null;
    }
}

