/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css.parser;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssSelectorItem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public class CssSelectorParser {
    private static final String selectorPatternString = "(\\*)|([_a-zA-Z][\\w-]*)|(\\.[_a-zA-Z][\\w-]*)|(#[_a-z][\\w-]*)|(\\[[_a-zA-Z][\\w-]*(([~^$*|])?=((\"[\\w-]+\")|([\\w-]+)))?\\])|(:[\\w()-]*)|( )|(\\+)|(>)|(~)";
    private static final Pattern selectorPattern = Pattern.compile("(\\*)|([_a-zA-Z][\\w-]*)|(\\.[_a-zA-Z][\\w-]*)|(#[_a-z][\\w-]*)|(\\[[_a-zA-Z][\\w-]*(([~^$*|])?=((\"[\\w-]+\")|([\\w-]+)))?\\])|(:[\\w()-]*)|( )|(\\+)|(>)|(~)");
    private static final int a = 65536;
    private static final int b = 256;
    private static final int c = 1;

    public static List<CssSelectorItem> createCssSelector(String selector) {
        ArrayList<CssSelectorItem> cssSelectorItems = new ArrayList<CssSelectorItem>();
        Matcher itemMatcher = selectorPattern.matcher(selector);
        boolean isTagSelector = false;
        int crc = 0;
        while (itemMatcher.find()) {
            String selectorItem = itemMatcher.group(0);
            crc += selectorItem.length();
            switch (selectorItem.charAt(0)) {
                case '#': {
                    cssSelectorItems.add(new CssIdSelector(selectorItem.substring(1)));
                    break;
                }
                case '.': {
                    cssSelectorItems.add(new CssClassSelector(selectorItem.substring(1)));
                    break;
                }
                case '[': {
                    cssSelectorItems.add(new CssAttributeSelector(selectorItem));
                    break;
                }
                case ':': {
                    cssSelectorItems.add(new CssPseudoSelector(selectorItem));
                    break;
                }
                case ' ': 
                case '+': 
                case '>': 
                case '~': {
                    if (cssSelectorItems.size() == 0) {
                        return null;
                    }
                    CssSelectorItem lastItem = (CssSelectorItem)cssSelectorItems.get(cssSelectorItems.size() - 1);
                    CssSeparatorSelector currItem = new CssSeparatorSelector(selectorItem.charAt(0));
                    if (lastItem instanceof CssSeparatorSelector) {
                        if (selectorItem.charAt(0) == ' ') break;
                        if (lastItem.getSeparator() == ' ') {
                            cssSelectorItems.set(cssSelectorItems.size() - 1, currItem);
                            break;
                        }
                        return null;
                    }
                    cssSelectorItems.add(currItem);
                    isTagSelector = false;
                    break;
                }
                default: {
                    if (isTagSelector) {
                        return null;
                    }
                    isTagSelector = true;
                    cssSelectorItems.add(new CssTagSelector(selectorItem));
                }
            }
        }
        if (selector.length() == 0 || selector.length() != crc) {
            return null;
        }
        return cssSelectorItems;
    }

    static class CssSeparatorSelector
    implements CssSelectorItem {
        private char separator;

        CssSeparatorSelector(char separator) {
            this.separator = separator;
        }

        @Override
        public char getSeparator() {
            return this.separator;
        }

        @Override
        public boolean matches(Tag t) {
            return false;
        }

        @Override
        public int getSpecificity() {
            return 0;
        }

        public String toString() {
            return String.valueOf(this.separator);
        }
    }

    static class CssPseudoSelector
    implements CssSelectorItem {
        private String selector;

        CssPseudoSelector(String selector) {
            this.selector = selector;
        }

        @Override
        public boolean matches(Tag t) {
            return false;
        }

        @Override
        public char getSeparator() {
            return '\u0000';
        }

        @Override
        public int getSpecificity() {
            return 0;
        }

        public String toString() {
            return this.selector;
        }
    }

    static class CssAttributeSelector
    implements CssSelectorItem {
        private String property;
        private char matchSymbol = '\u0000';
        private String value = null;

        CssAttributeSelector(String attrSelector) {
            int indexOfEqual = attrSelector.indexOf(61);
            if (indexOfEqual == -1) {
                this.property = attrSelector.substring(1, attrSelector.length() - 1);
            } else {
                this.value = attrSelector.charAt(indexOfEqual + 1) == '\"' ? attrSelector.substring(indexOfEqual + 2, attrSelector.length() - 2) : attrSelector.substring(indexOfEqual + 1, attrSelector.length() - 1);
                this.matchSymbol = attrSelector.charAt(indexOfEqual - 1);
                if ("~^$*|".indexOf(this.matchSymbol) == -1) {
                    this.matchSymbol = '\u0000';
                    this.property = attrSelector.substring(1, indexOfEqual);
                } else {
                    this.property = attrSelector.substring(1, indexOfEqual - 1);
                }
            }
        }

        @Override
        public char getSeparator() {
            return '\u0000';
        }

        @Override
        public boolean matches(Tag t) {
            if (t == null) {
                return false;
            }
            String attrValue = t.getAttributes().get(this.property);
            if (attrValue == null) {
                return false;
            }
            if (this.value == null) {
                return true;
            }
            switch (this.matchSymbol) {
                case '|': {
                    String pattern = String.format("^%s-?", this.value);
                    if (!Pattern.compile(pattern).matcher(attrValue).find()) break;
                    return true;
                }
                case '^': {
                    if (!attrValue.startsWith(this.value)) break;
                    return true;
                }
                case '$': {
                    if (!attrValue.endsWith(this.value)) break;
                    return true;
                }
                case '~': {
                    String pattern = String.format("(^%s\\s+)|(\\s+%s\\s+)|(\\s+%s$)", this.value, this.value, this.value);
                    if (!Pattern.compile(pattern).matcher(attrValue).find()) break;
                    return true;
                }
                case '\u0000': {
                    if (!attrValue.equals(this.value)) break;
                    return true;
                }
                case '*': {
                    if (!attrValue.contains(this.value)) break;
                    return true;
                }
            }
            return false;
        }

        @Override
        public int getSpecificity() {
            return 256;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append('[').append(this.property);
            if (this.matchSymbol != '\u0000') {
                buf.append(this.matchSymbol);
            }
            if (this.value != null) {
                buf.append('=').append('\"').append(this.value).append('\"');
            }
            buf.append(']');
            return buf.toString();
        }
    }

    static class CssIdSelector
    implements CssSelectorItem {
        private String id;

        CssIdSelector(String id) {
            this.id = id;
        }

        @Override
        public boolean matches(Tag t) {
            String id = t.getAttributes().get("id");
            return id != null && this.id.equals(id.trim());
        }

        @Override
        public char getSeparator() {
            return '\u0000';
        }

        @Override
        public int getSpecificity() {
            return 65536;
        }

        public String toString() {
            return "#" + this.id;
        }
    }

    static class CssClassSelector
    implements CssSelectorItem {
        private String className;

        CssClassSelector(String className) {
            this.className = className;
        }

        @Override
        public boolean matches(Tag t) {
            String[] classNames;
            String classAttr = t.getAttributes().get("class");
            if (classAttr == null || classAttr.length() == 0) {
                return false;
            }
            for (String currClassName : classNames = classAttr.split(" ")) {
                if (!this.className.equals(currClassName.trim())) continue;
                return true;
            }
            return false;
        }

        @Override
        public char getSeparator() {
            return '\u0000';
        }

        @Override
        public int getSpecificity() {
            return 256;
        }

        public String toString() {
            return "." + this.className;
        }
    }

    static class CssTagSelector
    implements CssSelectorItem {
        private String t;
        private boolean isUniversal;

        CssTagSelector(String t) {
            this.t = t;
            this.isUniversal = this.t.equals("*");
        }

        @Override
        public boolean matches(Tag t) {
            return this.isUniversal || this.t.equals(t.getName());
        }

        @Override
        public char getSeparator() {
            return '\u0000';
        }

        @Override
        public int getSpecificity() {
            if (this.isUniversal) {
                return 0;
            }
            return 1;
        }

        public String toString() {
            return this.t;
        }
    }
}

