/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.checksum;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.apply.XFACssAppliersImpl;
import com.itextpdf.tool.xml.xtra.xfa.checksum.ChecksumXFAWorker;
import com.itextpdf.tool.xml.xtra.xfa.checksum.XFAChecksumXMLParser;
import com.itextpdf.tool.xml.xtra.xfa.pipe.TemplateBuilderPipeline;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

public class XFANormalizer {
    public static final String PROCESSING_INSTRUCTION_CONTENTS = "xfa-full-processing-instruction-contents";
    private StringBuilder sb = new StringBuilder();
    private StringBuilder contentBuilder = new StringBuilder();

    public static String getNormalizedXml(ByteArrayInputStream inputStream) {
        inputStream.reset();
        TemplateBuilderPipeline template = new TemplateBuilderPipeline(new XFACssAppliersImpl());
        XFANormalizer normalizer = new XFANormalizer();
        ChecksumXFAWorker worker = new ChecksumXFAWorker(template, normalizer);
        XFAChecksumXMLParser parser = new XFAChecksumXMLParser(false, worker);
        parser.setDecodeSpecialChars(false);
        try {
            parser.parse((InputStream)inputStream, true);
            return normalizer.getResult();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public void start(Tag t) {
        this.sb.append((CharSequence)this.contentBuilder);
        this.contentBuilder.setLength(0);
        String fullTagName = t.getNameSpace().length() > 0 ? t.getNameSpace() + ":" + t.getName() : t.getName();
        this.sb.append("<");
        if (!t.getName().startsWith("?")) {
            this.sb.append(fullTagName);
            for (Map.Entry<String, String> entry : t.getAttributes().entrySet()) {
                this.sb.append(" ").append(entry.getKey());
                this.sb.append("=\"").append(entry.getValue()).append("\"");
            }
        } else {
            String fullAttrStr = t.getAttributes().get(PROCESSING_INSTRUCTION_CONTENTS);
            if (fullAttrStr != null && fullAttrStr.length() > 0) {
                this.sb.append(fullAttrStr);
            }
        }
        this.sb.append(">");
    }

    public void content(String content) {
        this.contentBuilder.append(content);
    }

    public void end(Tag t) {
        String fullTagName;
        this.sb.append((CharSequence)this.contentBuilder);
        this.contentBuilder.setLength(0);
        String string = fullTagName = t.getNameSpace().length() > 0 ? t.getNameSpace() + ":" + t.getName() : t.getName();
        if (!t.getName().startsWith("?")) {
            this.sb.append("</").append(fullTagName).append(">");
        }
    }

    public String getResult() {
        return this.sb.toString();
    }
}

