/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.BadElementException;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Image;
import com.itextpdf.text.ImgRaw;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.codec.Base64;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.io.IOException;

public class ImageElement
extends ContentElement {
    private Image img = null;

    public ImageElement(FormNode elementTag, XFARectangle elementRec, Document document, String data) {
        super(elementTag, elementRec, document);
        String transferEncoding = "base64";
        if (this.attributes.get("transferEncoding") != null) {
            transferEncoding = (String)this.attributes.get("transferEncoding");
        }
        try {
            if (data != null) {
                if ("base64".equalsIgnoreCase(transferEncoding)) {
                    byte[] buf = Base64.decode(data);
                    if (buf != null) {
                        this.img = Image.getInstance(buf);
                    }
                } else {
                    this.img = Image.getInstance(data.getBytes());
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (BadElementException badElementException) {
            // empty catch block
        }
        this.applyAspect();
    }

    public ImageElement(FormNode elementTag, XFARectangle elementRec, Document document, Image img) {
        super(elementTag, elementRec, document);
        this.img = img;
        this.applyAspect();
    }

    private void applyAspect() {
        String aspect = "fit";
        if (this.attributes.get("aspect") != null) {
            aspect = (String)this.attributes.get("aspect");
        }
        Float width = this.elementRec.getWidth();
        Float height = this.elementRec.getHeight();
        if (this.img != null) {
            float heightRatio;
            float widthRatio;
            float scaledHeight;
            if (this.img.getDpiX() != 0 && this.img.getDpiY() != 0 || this.img instanceof ImgRaw) {
                float dpiX = this.img.getDpiX() != 0 ? (float)this.img.getDpiX() : 96.0f;
                float dpiY = this.img.getDpiY() != 0 ? (float)this.img.getDpiY() : 96.0f;
                this.img.scaleAbsoluteWidth(this.img.getScaledWidth() / dpiX * 72.0f);
                this.img.scaleAbsoluteHeight(this.img.getScaledHeight() / dpiY * 72.0f);
            }
            if ("actual".equalsIgnoreCase(aspect)) {
                scaledHeight = this.img.getScaledHeight();
                this.img.setAbsolutePosition(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - scaledHeight);
            } else if ("fit".equalsIgnoreCase(aspect)) {
                if (width != null && height != null) {
                    this.img.scaleToFit(width.floatValue(), height.floatValue());
                } else if (width != null) {
                    this.img.scaleToFit(width.floatValue(), this.img.getScaledHeight());
                } else if (height != null) {
                    this.img.scaleToFit(this.img.getScaledWidth(), height.floatValue());
                }
                scaledHeight = this.img.getScaledHeight();
                this.img.setAbsolutePosition(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - scaledHeight);
            } else if ("none".equalsIgnoreCase(aspect)) {
                if (width != null) {
                    this.img.scaleAbsoluteWidth(width.floatValue());
                }
                if (height != null) {
                    this.img.scaleAbsoluteHeight(height.floatValue());
                }
                scaledHeight = this.img.getScaledHeight();
                this.img.setAbsolutePosition(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - scaledHeight);
            } else if ("width".equalsIgnoreCase(aspect)) {
                widthRatio = width.floatValue() / this.img.getWidth();
                heightRatio = height.floatValue() / this.img.getHeight();
                height = Float.valueOf(height.floatValue() * (widthRatio / heightRatio));
                this.img.scaleToFit(width.floatValue(), height.floatValue());
                this.img.setAbsolutePosition(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - height.floatValue());
            } else if ("height".equalsIgnoreCase(aspect)) {
                widthRatio = width.floatValue() / this.img.getWidth();
                heightRatio = height.floatValue() / this.img.getHeight();
                width = Float.valueOf(width.floatValue() * (heightRatio / widthRatio));
                this.img.scaleToFit(width.floatValue(), height.floatValue());
                this.img.setAbsolutePosition(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - height.floatValue());
            }
            if (width == null) {
                this.elementRec.setWidth(Float.valueOf(this.img.getScaledWidth()));
            }
            if (height == null) {
                this.elementRec.setHeight(Float.valueOf(this.img.getScaledHeight()));
            }
        }
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException {
        if (this.img != null) {
            canvas.saveState();
            canvas.rectangle(this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue() - this.elementRec.getHeight().floatValue(), this.elementRec.getWidth().floatValue(), this.elementRec.getHeight().floatValue());
            canvas.eoClip();
            canvas.newPath();
            if (canvas.isTagged()) {
                canvas.openMCBlock(this.img);
            }
            canvas.addImage(this.img);
            if (canvas.isTagged()) {
                canvas.closeMCBlock(this.img);
            }
            canvas.restoreState();
        }
        return PositionResult.State.FULL_CONTENT;
    }

    @Override
    public boolean isEmpty() {
        return this.img == null;
    }

    @Override
    public void move(float dx, float dy) {
        super.move(dx, dy);
        if (this.img != null) {
            this.img.setAbsolutePosition(this.img.getAbsoluteX() + dx, this.img.getAbsoluteY() + dy);
        }
    }
}

