/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.awt.geom.AffineTransform;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentElement;
import com.itextpdf.tool.xml.xtra.xfa.element.IContentTextElement;
import com.itextpdf.tool.xml.xtra.xfa.element.PositionResult;
import com.itextpdf.tool.xml.xtra.xfa.element.UiElement;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFARectangle;
import java.io.IOException;

public class TextEditElement
extends UiElement {
    protected boolean isBorderDrawn = true;

    public TextEditElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement) {
        this(elementTag, elementRec, document, contentElement, null);
    }

    public TextEditElement(FormNode elementTag, XFARectangle elementRec, Document document, ContentElement contentElement, Integer textIndependentRotateAngle) {
        super(elementTag, elementRec, document, contentElement);
        this.independentRotateAngle = textIndependentRotateAngle;
        if (this.contentElement instanceof IContentTextElement) {
            Float width;
            this.applyMargins(this.elementRec);
            if (textIndependentRotateAngle != null && textIndependentRotateAngle % 180 == 90) {
                width = this.elementRec.getWidth();
                this.elementRec.setWidth(this.elementRec.getHeight());
                this.elementRec.setHeight(width);
            }
            ((IContentTextElement)((Object)this.contentElement)).createColumnText(this.elementRec);
            if (textIndependentRotateAngle != null && textIndependentRotateAngle % 180 == 90) {
                width = this.elementRec.getWidth();
                this.elementRec.setWidth(this.elementRec.getHeight());
                this.elementRec.setHeight(width);
            }
            this.unapplyMargins(this.elementRec);
        }
    }

    @Override
    public PositionResult.State draw(PdfContentByte canvas, XFARectangle parentBoundingBox) throws DocumentException, IOException {
        if (this.isBorderDrawn) {
            this.drawBorder(canvas, parentBoundingBox);
        }
        PositionResult.State state = PositionResult.State.FULL_CONTENT;
        if (this.contentElement != null) {
            Float width;
            this.applyMargins(this.elementRec);
            if (this.independentRotateAngle != null) {
                canvas.saveState();
                canvas.transform(AffineTransform.getRotateInstance(Math.toRadians(this.independentRotateAngle.intValue()), this.elementRec.getLlx().floatValue(), this.elementRec.getUry().floatValue()));
                switch (this.independentRotateAngle % 360) {
                    case 90: {
                        canvas.transform(AffineTransform.getTranslateInstance(-this.elementRec.getHeight().floatValue(), 0.0));
                        break;
                    }
                    case 180: {
                        canvas.transform(AffineTransform.getTranslateInstance(-this.elementRec.getWidth().floatValue(), this.elementRec.getHeight().floatValue()));
                        break;
                    }
                    case 270: {
                        canvas.transform(AffineTransform.getTranslateInstance(0.0, this.elementRec.getWidth().floatValue()));
                    }
                }
                if (this.independentRotateAngle % 180 == 90) {
                    width = this.elementRec.getWidth();
                    this.elementRec.setWidth(this.elementRec.getHeight());
                    this.elementRec.setHeight(width);
                }
            }
            state = this.contentElement.draw(canvas, parentBoundingBox);
            if (this.independentRotateAngle != null) {
                canvas.restoreState();
                if (this.independentRotateAngle % 180 == 90) {
                    width = this.elementRec.getWidth();
                    this.elementRec.setWidth(this.elementRec.getHeight());
                    this.elementRec.setHeight(width);
                }
            }
            this.unapplyMargins(this.elementRec);
        }
        this.positionState = state;
        return this.positionState;
    }

    @Override
    protected boolean isTextWidget() {
        return true;
    }

    public void setBorderDrawn(boolean borderDrawn) {
        this.isBorderDrawn = borderDrawn;
    }
}

