/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.element;

import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.HyphenationEvent;
import com.itextpdf.text.pdf.hyphenation.Hyphenation;
import com.itextpdf.text.pdf.hyphenation.Hyphenator;
import com.itextpdf.tool.xml.xtra.xfa.XFALocale;
import com.itextpdf.tool.xml.xtra.xfa.resolver.FlattenerContext;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.util.ArrayList;

public class XFAHyphenation
implements HyphenationEvent {
    public static final String WORD_CHARACTER_COUNT = "wordCharacterCount";
    public static final String REMAIN_CHARACTER_COUNT = "remainCharacterCount";
    public static final String PUSH_CHARACTER_COUNT = "pushCharacterCount";
    public static final String EXCLUDE_ALL_CAPS = "excludeAllCaps";
    public static final String EXCLUDE_INITIAL_CAP = "excludeInitialCap";
    protected Hyphenator hyphenator;
    protected String post;
    protected XFALocale locale;
    protected int wordCharacterCount = 7;
    protected int remainCharacterCount = 3;
    protected int pushCharacterCount = 3;
    protected boolean excludeAllCaps = false;
    protected boolean excludeInitialCap = false;

    public XFAHyphenation() {
    }

    public XFAHyphenation(XFALocale locale, FormNode hyphenationNode, FlattenerContext flattenerContext) {
        this.locale = locale;
        String useAttr = hyphenationNode.retrieveAttribute("use");
        if (useAttr != null) {
            hyphenationNode = (FormNode)((Object)flattenerContext.getDomPositioner().searchNodeDown(useAttr));
        }
        if (hyphenationNode != null) {
            this.wordCharacterCount = XFAUtil.parseInt(hyphenationNode.retrieveAttribute(WORD_CHARACTER_COUNT), this.wordCharacterCount);
            this.remainCharacterCount = XFAUtil.parseInt(hyphenationNode.retrieveAttribute(REMAIN_CHARACTER_COUNT), this.remainCharacterCount);
            this.pushCharacterCount = XFAUtil.parseInt(hyphenationNode.retrieveAttribute(PUSH_CHARACTER_COUNT), this.pushCharacterCount);
            if (Integer.valueOf(1).equals(XFAUtil.parseInt(hyphenationNode.retrieveAttribute(EXCLUDE_ALL_CAPS)))) {
                this.excludeAllCaps = true;
            }
            if (Integer.valueOf(1).equals(XFAUtil.parseInt(hyphenationNode.retrieveAttribute(EXCLUDE_INITIAL_CAP)))) {
                this.excludeInitialCap = true;
            }
        }
        this.hyphenator = new Hyphenator(locale.getLocale().getLanguage(), locale.getLocale().getCountry(), this.remainCharacterCount, this.pushCharacterCount);
    }

    private boolean isAllCaps(String str) {
        return str.toUpperCase(this.locale.getLocale()).equals(str);
    }

    private boolean isInitialCap(String str) {
        if (str.isEmpty()) {
            return false;
        }
        String firstLetter = str.substring(0, 1);
        return firstLetter.toUpperCase(this.locale.getLocale()).equals(firstLetter) && !this.isAllCaps(str);
    }

    private boolean containsDigit(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) < '0' || str.charAt(i) > '9') continue;
            return true;
        }
        return false;
    }

    @Override
    public String getHyphenSymbol() {
        return "-";
    }

    @Override
    public String getHyphenatedWordPre(String word, BaseFont font, float fontSize, float remainingWidth) {
        int k;
        Hyphenation hyphenation;
        if (this.containsDigit(word) || this.excludeAllCaps && this.isAllCaps(word) || this.excludeInitialCap && this.isInitialCap(word)) {
            this.post = word;
            return "";
        }
        this.post = word;
        String hyphen = this.getHyphenSymbol();
        float hyphenWidth = font.getWidthPoint(hyphen, fontSize);
        if (hyphenWidth > remainingWidth) {
            return "";
        }
        Hyphenation hyphenation2 = hyphenation = this.hyphenator != null ? this.hyphenator.hyphenate(word) : this.hyphenateBasedOnSoftHyphens(word);
        if (hyphenation == null) {
            return "";
        }
        int len = hyphenation.length();
        for (k = 0; k < len && !(font.getWidthPoint(hyphenation.getPreHyphenText(k), fontSize) + hyphenWidth > remainingWidth); ++k) {
        }
        if (--k < 0) {
            return "";
        }
        this.post = hyphenation.getPostHyphenText(k);
        return hyphenation.getPreHyphenText(k) + hyphen;
    }

    @Override
    public String getHyphenatedWordPost() {
        return this.post;
    }

    private Hyphenation hyphenateBasedOnSoftHyphens(String word) {
        int leftInd;
        int curSoftHyphenIndex;
        int softHyphen = 173;
        ArrayList<Integer> softHyphens = new ArrayList<Integer>();
        int lastSoftHyphenIndex = -1;
        while ((curSoftHyphenIndex = word.indexOf(173, lastSoftHyphenIndex + 1)) > 0) {
            softHyphens.add(curSoftHyphenIndex);
            lastSoftHyphenIndex = curSoftHyphenIndex;
        }
        int rightInd = softHyphens.size() - 1;
        for (leftInd = 0; leftInd < softHyphens.size() && word.substring(0, (Integer)softHyphens.get(leftInd)).replace(String.valueOf('\u00ad'), "").length() < this.pushCharacterCount; ++leftInd) {
        }
        while (rightInd >= 0 && word.substring((Integer)softHyphens.get(rightInd) + 1).replace(String.valueOf('\u00ad'), "").length() < this.remainCharacterCount) {
            --rightInd;
        }
        if (leftInd <= rightInd) {
            int[] hyphenationPoints = new int[rightInd - leftInd + 1];
            for (int i = leftInd; i <= rightInd; ++i) {
                hyphenationPoints[i - leftInd] = (Integer)softHyphens.get(i);
            }
            return new Hyphenation(word, hyphenationPoints);
        }
        return null;
    }
}

