/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.js;

import com.itextpdf.text.Element;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.xtra.xfa.XFAWorker;
import com.itextpdf.tool.xml.xtra.xfa.element.CaptionElement;
import com.itextpdf.tool.xml.xtra.xfa.element.ContentArea;
import com.itextpdf.tool.xml.xtra.xfa.js.IJsObject;
import com.itextpdf.tool.xml.xtra.xfa.js.JsContent;
import com.itextpdf.tool.xml.xtra.xfa.js.JsInstanceManager;
import com.itextpdf.tool.xml.xtra.xfa.js.JsManifest;
import com.itextpdf.tool.xml.xtra.xfa.js.JsOccur;
import com.itextpdf.tool.xml.xtra.xfa.js.JsScript;
import com.itextpdf.tool.xml.xtra.xfa.js.JsTree;
import com.itextpdf.tool.xml.xtra.xfa.js.JsValueNode;
import com.itextpdf.tool.xml.xtra.xfa.js.ResourceUtil;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoExecutionError;
import com.itextpdf.tool.xml.xtra.xfa.js.RhinoJsNodeList;
import com.itextpdf.tool.xml.xtra.xfa.positioner.ContentPositioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.Positioner;
import com.itextpdf.tool.xml.xtra.xfa.positioner.SubFormPositioner;
import com.itextpdf.tool.xml.xtra.xfa.tags.FormNode;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import java.io.ByteArrayInputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;

public class JsNode
extends JsTree
implements FormNode {
    protected static final JsNode nodeJsObject = new JsNode("node");
    protected static Charset utf8Charset = Charset.forName("UTF-8");
    public static Tag UNIVERSAL_PROTOTYPE_ROOT;
    protected static final Map<String, JsNode> nodes;
    protected static final JsContent textJsObject;
    protected Tag tag;
    protected Tag protoTemplate;
    protected Map<Tag, JsInstanceManager> instanceManagerByTemplate = new HashMap<Tag, JsInstanceManager>();
    private List<JsNode> addAfterMeList;

    public JsNode(String className) {
        super(className);
        this.defineProperty("isNull", JsNode.class, 1);
        this.defineProperty("isContainer", JsNode.class, 1);
        this.defineProperty("oneOfChild", JsNode.class, 0);
        this.defineFunctionProperties(new String[]{"loadXML"}, JsNode.class, 4);
        this.defineFunctionProperties(new String[]{"isPropertySpecified"}, JsNode.class, 4);
        this.setPrototype((Scriptable)treeJsObject);
    }

    public JsNode(Tag tag, IJsObject parent) {
        super(parent);
        this.tag = tag;
        if (parent instanceof JsNode) {
            this.flattenerContext = ((JsNode)parent).flattenerContext;
            if (((JsNode)parent).protoTemplate != null) {
                this.protoTemplate = ((JsNode)parent).protoTemplate.getChild(tag.getName(), "");
            }
        }
        this.setPrototype((Scriptable)nodeJsObject);
        String name = tag.getAttributes().get("name");
        if (name != null) {
            this.defineProperty("name", name);
        }
        for (Map.Entry<String, String> attribute : tag.getAttributes().entrySet()) {
            String key = attribute.getKey();
            this.defineProperty(key, attribute.getValue());
        }
    }

    public void put(String name, Scriptable start, Object value) {
        super.put(name, start, value);
        if (this == start) {
            this.putCallback(name, value);
        }
    }

    protected void putCallback(String name, Object value) {
        if (this.flattenerContext != null && this.flattenerContext.isValidateLayout()) {
            JsNode positioner;
            for (positioner = this; positioner != null && !(positioner instanceof Positioner); positioner = positioner.getParentScope()) {
            }
            if (positioner != null) {
                if (name.equals("presence")) {
                    this.flattenerContext.getDomPositioner().setLayoutOutOfDate(true);
                } else {
                    ((Positioner)positioner).setLayoutOutOfDate(true);
                }
            }
        }
    }

    public JsNode(String name, IJsObject parent) {
        super(parent);
        this.tag = null;
        if (parent instanceof JsNode && ((JsNode)parent).protoTemplate != null) {
            this.protoTemplate = ((JsNode)parent).protoTemplate.getChild(name, "");
            this.flattenerContext = ((JsNode)parent).flattenerContext;
        }
        this.setPrototype((Scriptable)nodeJsObject);
        if (name != null) {
            this.defineProperty("name", name);
        }
    }

    protected JsNode(JsNode parent) {
        super(parent);
    }

    public JsNode(Tag tag, IJsObject parent, JsNode prototypeNode) {
        this(tag, parent);
        this.setPrototype((Scriptable)prototypeNode);
        if (!tag.getName().equals(prototypeNode.retrieveAttribute("className"))) {
            this.defineProperty("className", tag.getName());
        }
    }

    public Object get(String name, Scriptable start) {
        Object baseResult = super.get(name, start);
        if (baseResult == Scriptable.NOT_FOUND && !"event".equals(name)) {
            Object result;
            Tag foundChild;
            if (this.tag != null && (foundChild = this.tag.getChild(name, "")) != null && (result = this.addChild(foundChild, true)) != null) {
                return result;
            }
            result = this.getPrototypeObject(name);
            if (result != null) {
                return result;
            }
        }
        return baseResult;
    }

    protected Object getPrototypeObject(String name) {
        Tag foundChild;
        if (this.protoTemplate != null && (foundChild = this.protoTemplate.getChild(name, "")) != null) {
            JsNode result = "occur".equals(name) && this instanceof Positioner ? new JsOccur((Positioner)this) : new JsNode(foundChild.getName(), (IJsObject)this);
            this.addChild(result);
            return result;
        }
        return null;
    }

    public boolean getIsNull() {
        Object value = JsNode.getProperty((Scriptable)this, (String)"rawValue");
        if (value == Scriptable.NOT_FOUND) {
            value = this.getProperty("value");
        }
        if (value instanceof NativeJavaObject) {
            value = ((NativeJavaObject)value).unwrap();
        }
        return value == null || value.toString().isEmpty();
    }

    public boolean getIsContainer() {
        return this instanceof SubFormPositioner;
    }

    public void loadXML(String xml, boolean ignoreRootNode, boolean overrideCurrentInformation) {
        if ("exData".equals(this.retrieveName())) {
            try {
                XFAWorker.RichTextParseResult parseResult = XFAWorker.parseRichTextPart(new ByteArrayInputStream(xml.getBytes(utf8Charset)), this.flattenerContext.getFontProvider(), utf8Charset);
                Tag tag = parseResult.getRichTextRootTag();
                List<Element> elements = parseResult.getRichTextElements();
                ((XFATemplateTag)this.tag).addRichTextList(elements);
                ((Positioner)this.getParent().getParent()).setRawValue(elements);
                this.tag.getChildren().clear();
                this.tag.getChildren().add(tag);
                this.delete(tag.getName());
                this.delete("nodes");
                this.addChild(tag);
            }
            catch (Exception parseResult) {}
        } else {
            try {
                Tag tag = XFAWorker.parseTemplatePart(new ByteArrayInputStream(xml.getBytes(utf8Charset)), utf8Charset);
                if ("image".equals(tag.getName()) && "value".equals(this.retrieveName())) {
                    tag.setParent(this.tag);
                    this.tag.getChildren().clear();
                    this.tag.getChildren().add(tag);
                    this.delete(tag.getName());
                    this.delete("nodes");
                    this.addChild(tag);
                    if (this.getParent() instanceof ContentPositioner) {
                        ((ContentPositioner)this.getParent()).initValues();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean isPropertySpecified(String propertyName) {
        return this.retrieveAttribute(propertyName) != null;
    }

    public JsNode getOneOfChild() {
        List<FormNode> children = this.retrieveChildren();
        return children.size() == 1 && children.get(0) instanceof JsNode ? (JsNode)children.get(0) : null;
    }

    public void setOneOfChild(JsNode child) {
        throw new RhinoExecutionError("Not implemented");
    }

    public JsNode addChild(Tag tag, boolean addAllChildren) {
        String tagName = tag.getName();
        JsNode node = null;
        if ("text".equals(tagName) || "script".equals(tagName) || "image".equals(tagName)) {
            node = new JsContent(tag, this, nodes.get(tagName));
            if ("text".equals(tagName) && this instanceof JsValueNode && this.getParent() instanceof ContentPositioner) {
                node.defineProperty("value", ((ContentPositioner)this.getParent()).getRawValue());
            }
        } else if (addAllChildren && "value".equals(tagName) && this instanceof ContentPositioner) {
            node = new JsValueNode(tag, (IJsObject)this);
        } else if ("contentArea".equals(tagName)) {
            node = new ContentArea(tag, this);
        } else if ("caption".equals(tagName)) {
            node = new CaptionElement(tag, (IJsObject)this);
        } else {
            JsNode prototypeNode = nodes.get(tagName);
            if (tagName.equals("proto")) {
                addAllChildren = true;
            } else if (prototypeNode == null && addAllChildren) {
                prototypeNode = nodeJsObject;
            } else if (prototypeNode == null && tag.getAttributes().containsKey("id")) {
                addAllChildren = true;
                prototypeNode = nodeJsObject;
            }
            if (prototypeNode != null) {
                node = new JsNode(tag, this, prototypeNode);
            }
        }
        if (node != null) {
            for (Tag child : tag) {
                if ("variables".equals(tagName)) {
                    this.addVariable(child);
                    node.addVariable(child);
                    continue;
                }
                node.addChild(child, addAllChildren);
            }
            if (addAllChildren && !node.getTag().getAttributes().containsKey("name")) {
                node.defineProperty("name", tagName);
            }
            this.addChild(node);
        }
        return node;
    }

    public void addChild(Tag tag) {
        this.addChild(tag, false);
    }

    public void addVariable(Tag variableTag) {
        if ("text".equals(variableTag.getName())) {
            this.addChild(new JsContent(variableTag, this, textJsObject));
        } else if ("script".equals(variableTag.getName())) {
            this.addChild(new JsScript(variableTag, (IJsObject)this));
        } else if ("manifest".equals(variableTag.getName())) {
            this.addChild(new JsManifest(variableTag, this));
        }
    }

    public RhinoJsNodeList getNodes() {
        Object obj = this.getOwnProperty("nodes");
        if (obj instanceof RhinoJsNodeList) {
            return (RhinoJsNodeList)((Object)obj);
        }
        return null;
    }

    public JsNode getChild(String name) {
        Object obj;
        Object childNode = this.getOwnProperty(name);
        if (childNode instanceof JsNode) {
            return (JsNode)childNode;
        }
        if (childNode instanceof RhinoJsNodeList && ((RhinoJsNodeList)((Object)childNode)).getLength() > 0L && (obj = ((RhinoJsNodeList)((Object)childNode)).item(0)) instanceof JsNode) {
            return (JsNode)obj;
        }
        return null;
    }

    public Tag getTag() {
        return this.tag;
    }

    public JsNode getParent() {
        Object parentNode = this.getOwnProperty("parent");
        if (parentNode instanceof JsNode) {
            return (JsNode)parentNode;
        }
        return null;
    }

    public void addAfterMe(JsNode node) {
        if (this.addAfterMeList == null) {
            this.addAfterMeList = new ArrayList<JsNode>();
        }
        this.addAfterMeList.add(node);
    }

    @Override
    public void addChild(JsTree child) {
        super.addChild(child);
        if (child instanceof JsNode && ((JsNode)child).addAfterMeList != null) {
            for (JsNode t1 : ((JsNode)child).addAfterMeList) {
                this.addChild(t1);
            }
            ((JsNode)child).addAfterMeList.clear();
            ((JsNode)child).addAfterMeList = null;
        }
    }

    @Override
    public FormNode retrieveChild(String name) {
        FormNode tagChild;
        if (!this.has(name, (Scriptable)this) && this.tag instanceof XFATemplateTag && (tagChild = ((XFATemplateTag)this.tag).retrieveLastChild(name)) != null) {
            return tagChild;
        }
        return this.getChild(name);
    }

    @Override
    public FormNode retrieveChild(String ... path) {
        String name;
        FormNode result = this;
        String[] stringArray = path;
        int n = stringArray.length;
        for (int i = 0; i < n && (result = result.retrieveChild(name = stringArray[i])) != null; ++i) {
        }
        return result;
    }

    @Override
    public List<FormNode> retrieveChildren() {
        RhinoJsNodeList nodeList = this.getNodes();
        int nodeListLen = nodeList != null ? (int)nodeList.getLength() : 0;
        ArrayList<FormNode> children = new ArrayList<FormNode>(nodeListLen);
        for (int ind = 0; ind < nodeListLen; ++ind) {
            children.add((FormNode)nodeList.get(ind, (Scriptable)nodeList));
        }
        return children;
    }

    @Override
    public List<FormNode> retrieveChildren(String name) {
        RhinoJsNodeList nodeList = this.getNodes();
        int nodeListLen = nodeList != null ? (int)nodeList.getLength() : 0;
        ArrayList<FormNode> children = new ArrayList<FormNode>();
        for (int ind = 0; ind < nodeListLen; ++ind) {
            Object child = nodeList.get(ind, (Scriptable)nodeList);
            if (!((JsNode)child).retrieveName().equals(name)) continue;
            children.add((JsNode)child);
        }
        return children;
    }

    @Override
    public String retrieveName() {
        String name = this.getStringProperty("name");
        if (name == null && this.tag != null) {
            name = this.tag.getAttributes().get("name");
        }
        if (name == null && this.tag != null) {
            name = this.tag.getName();
        }
        return name;
    }

    @Override
    public Map<String, String> retrieveAttributes() {
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (Object index : this.getAllIds()) {
            Object value;
            if (!(index instanceof CharSequence) || !((value = this.get(index.toString(), (Scriptable)this)) instanceof CharSequence)) continue;
            attributes.put(index.toString(), value.toString());
        }
        return attributes;
    }

    @Override
    public String retrieveAttribute(String attributeName) {
        Object value = this.get(attributeName, (Scriptable)this);
        if (value instanceof CharSequence) {
            return value.toString();
        }
        return null;
    }

    @Override
    public FormNode retrieveParent() {
        return this.getParent();
    }

    @Override
    public String retrieveValue() {
        return this.getStringProperty("value");
    }

    @Override
    public List<Element> retrieveRichText() {
        if (this.tag instanceof XFATemplateTag) {
            return ((XFATemplateTag)this.tag).getRichText();
        }
        return null;
    }

    @Override
    public List<String> retrieveContent() {
        return Collections.singletonList(this.retrieveValue());
    }

    @Override
    public boolean isHidden() {
        String presence = this.retrieveAttribute("presence");
        return presence != null && presence.toString().equals("hidden");
    }

    public boolean isInactive() {
        String presence = this.retrieveAttribute("presence");
        return presence != null && presence.toString().equals("inactive");
    }

    public static JsNode getNotNullXFAPrototype(String className) {
        JsNode result = nodes.get(className);
        if (result == null) {
            result = nodeJsObject;
        }
        return result;
    }

    public JsInstanceManager getInstanceManagerByTemplate(Tag templateTag) {
        return this.instanceManagerByTemplate.get(templateTag);
    }

    public void addInstanceManagerForTemplate(Tag tag, JsInstanceManager instanceManager) {
        this.instanceManagerByTemplate.put(tag, instanceManager);
    }

    public void setProtoTemplate(XFATemplateTag protoTemplate) {
        this.protoTemplate = protoTemplate;
    }

    public Tag getProtoTemplate() {
        return this.protoTemplate;
    }

    @Override
    public String retrieveTagName() {
        return this.tag != null ? this.tag.getName() : null;
    }

    static {
        nodes = new HashMap<String, JsNode>();
        textJsObject = new JsContent("text");
        try {
            UNIVERSAL_PROTOTYPE_ROOT = XFAWorker.parseTemplatePart(ResourceUtil.getResourceAsStream("prototype.xml"), utf8Charset);
        }
        catch (Exception exception) {
            // empty catch block
        }
        nodes.put("image", new JsNode("image"));
        nodes.put("items", new JsNode("items"));
        nodes.put("proto", new JsNode("proto"));
        nodes.put("script", JsScript.scriptJsObject);
        nodes.put("text", textJsObject);
        nodes.put("variables", new JsNode("variables"));
    }
}

