/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.css.CssFilesImpl;
import com.itextpdf.tool.xml.css.CssUtils;
import com.itextpdf.tool.xml.css.StyleAttrCSSResolver;
import com.itextpdf.tool.xml.css.XfaCssInheritanceRules;
import com.itextpdf.tool.xml.html.CssAppliers;
import com.itextpdf.tool.xml.parser.XMLParser;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.pipeline.css.CssResolverPipeline;
import com.itextpdf.tool.xml.pipeline.ctx.ObjectContext;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipeline;
import com.itextpdf.tool.xml.pipeline.html.HtmlPipelineContext;
import com.itextpdf.tool.xml.xtra.xfa.XFAWorker;
import com.itextpdf.tool.xml.xtra.xfa.pipe.LocalContextElementHandlerPipeline;
import com.itextpdf.tool.xml.xtra.xfa.pipe.XFAFlattenerData;
import com.itextpdf.tool.xml.xtra.xfa.resolver.HrefReference;
import com.itextpdf.tool.xml.xtra.xfa.resolver.IHrefResolver;
import com.itextpdf.tool.xml.xtra.xfa.tags.RichTextTags;
import com.itextpdf.tool.xml.xtra.xfa.tags.XFATemplateTag;
import com.itextpdf.tool.xml.xtra.xfa.util.XFAUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateBuilderPipeline
extends AbstractPipeline<ObjectContext<XFAFlattenerData>> {
    static final Logger logger = LoggerFactory.getLogger(TemplateBuilderPipeline.class);
    private static final String XfaSchema = "http://www.xfa.org/schema/xfa-template/";
    private final Pipeline<?> richTextPipeline;
    private IHrefResolver hrefResolver;
    private boolean legacyPlusPrint = false;
    private float xfaVersion = 3.3f;

    public TemplateBuilderPipeline(CssAppliers cssAppliers) {
        super(null);
        HtmlPipelineContext hpc = new HtmlPipelineContext(cssAppliers);
        hpc.setAcceptUnknown(true).setTagFactory(RichTextTags.getRichTextTagProcessorFactory());
        this.richTextPipeline = new CssResolverPipeline(new StyleAttrCSSResolver(new XfaCssInheritanceRules(), new CssFilesImpl(), CssUtils.getInstance()), new HtmlPipeline(hpc, new LocalContextElementHandlerPipeline(null)));
        this.hrefResolver = null;
    }

    public TemplateBuilderPipeline(CssAppliers cssAppliers, IHrefResolver hrefResolver) {
        this(cssAppliers);
        this.hrefResolver = hrefResolver;
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        String tag = t.getName();
        if (tag.charAt(0) == '?') {
            this.processInstruction(t);
        }
        XFAFlattenerData flattenerData = (XFAFlattenerData)((ObjectContext)this.getLocalContext(context)).get();
        if ("template".equalsIgnoreCase(tag)) {
            if (flattenerData.getTemplateDom() == null) {
                String xmlns;
                flattenerData.setTemplateDom((XFATemplateTag)t);
                if (t.getAttributes() != null && (xmlns = t.getAttributes().get("xmlns")) != null && xmlns.startsWith(XfaSchema)) {
                    this.xfaVersion = this.getVersionFromUrl(xmlns);
                    this.legacyPlusPrint = this.xfaVersion < 2.5f;
                }
            }
        } else if ("subform".equalsIgnoreCase(tag) || "subformSet".equalsIgnoreCase(tag) || "field".equalsIgnoreCase(tag) || "draw".equalsIgnoreCase(tag) || "exclGroup".equalsIgnoreCase(tag) || "area".equalsIgnoreCase(tag)) {
            Map<String, String> attributes;
            if (t instanceof XFATemplateTag && !(attributes = t.getAttributes()).containsKey("locale") && t.getParent() != null && t.getParent().getAttributes().containsKey("locale")) {
                t.getAttributes().put("locale", t.getParent().getAttributes().get("locale"));
            }
        } else if ("text/html".equalsIgnoreCase(t.getAttributes().get("contentType"))) {
            flattenerData.setRichTextBlockTag(t);
            Pipeline<?> rtp = flattenerData.getRichTextPipeline();
            while (null != (rtp = rtp.init(context))) {
            }
        } else if (flattenerData.getRichTextBlockTag() == t.getParent() && ("http://www.w3.org/1999/xhtml".equals(t.getAttributes().get("xmlns")) || "xhtml".equals(t.getNameSpace()))) {
            flattenerData.setRichTextHtmlRootTag(t);
        }
        return this.getNext(context);
    }

    @Override
    public Pipeline<?> content(WorkerContext context, Tag t, String content, ProcessObject po) throws PipelineException {
        if (t instanceof XFATemplateTag && content.trim().length() > 0) {
            ((XFATemplateTag)t).addContent(content);
        }
        return this.getNext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Pipeline<?> close(WorkerContext context, Tag t, ProcessObject po) throws PipelineException {
        String tag = t.getName();
        if ("subform".equalsIgnoreCase(tag) || "field".equalsIgnoreCase(tag) || "draw".equalsIgnoreCase(tag) || "exclGroup".equalsIgnoreCase(tag) || "area".equalsIgnoreCase(tag) || "subformSet".equalsIgnoreCase(tag)) {
            if (t instanceof XFATemplateTag) {
                String matchValue;
                Map<String, String> attributes = t.getAttributes();
                String dataRef = null;
                if (attributes != null) {
                    dataRef = attributes.get("name");
                }
                String refValue = dataRef;
                Tag bindTag = ((XFATemplateTag)t).getBind();
                if (bindTag != null && (attributes = bindTag.getAttributes()) != null && (matchValue = attributes.get("match")) != null && matchValue.equals("dataRef")) {
                    refValue = attributes.get("ref");
                    dataRef = XFAUtil.checkSomExpression(refValue);
                }
                ((XFATemplateTag)t).setDataRef(dataRef);
                ((XFATemplateTag)t).setFullDataRef(refValue);
            }
        } else if ("text/html".equalsIgnoreCase(t.getAttributes().get("contentType"))) {
            ((XFAFlattenerData)((ObjectContext)this.getLocalContext(context)).get()).setRichTextBlockTag(null);
            List list = (List)((ObjectContext)((LocalContextElementHandlerPipeline)((XFAFlattenerData)((ObjectContext)this.getLocalContext(context)).get()).getRichTextPipeline().getNext().getNext()).getLocalContext(context)).get();
            ((XFATemplateTag)t).addRichTextList(list);
        }
        if (this.hrefResolver != null) {
            HrefReference hrefReference = null;
            String useHref = null;
            if (t.getAttributes() != null) {
                useHref = t.getAttributes().get("usehref");
            }
            if (useHref != null) {
                hrefReference = new HrefReference(useHref);
            }
            if (hrefReference != null) {
                XFAWorker worker = null;
                String currentXdpPath = this.hrefResolver.getCurrentXdpPath();
                try {
                    worker = new XFAWorker(this, t, hrefReference.getSomExpression());
                    worker.getWorkerContext().setCurrentTag(null);
                    XMLParser parser = new XMLParser(false, worker);
                    String path = this.hrefResolver.resolve(hrefReference.getPath());
                    this.hrefResolver.setCurrentXdpPath(path);
                    parser.parse((InputStream)new BufferedInputStream(new FileInputStream(new File(path))), true);
                }
                catch (Exception exc) {
                    if (logger.isErrorEnabled()) {
                        logger.error("External XDP fragment processing failed: " + exc.getLocalizedMessage() + "\nusehref: " + useHref, (Throwable)exc);
                    }
                }
                finally {
                    this.hrefResolver.setCurrentXdpPath(currentXdpPath);
                    if (worker != null) {
                        worker.getWorkerContext().setCurrentTag(t);
                    }
                    hrefReference.getSomExpression().init();
                }
            }
        }
        return this.getNext(context);
    }

    public Pipeline<?> getNext(WorkerContext context) throws PipelineException {
        XFAFlattenerData xfaFlattenerData = (XFAFlattenerData)((ObjectContext)this.getLocalContext(context)).get();
        if (xfaFlattenerData.isRichText()) {
            return xfaFlattenerData.getRichTextPipeline();
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        XFAFlattenerData t = new XFAFlattenerData();
        t.setRichTextPipeline(this.richTextPipeline);
        context.put(this.getContextKey(), new ObjectContext<XFAFlattenerData>(t));
        return super.init(context);
    }

    public boolean isLegacyPlusPrint() {
        return this.legacyPlusPrint;
    }

    public float getXfaVersion() {
        return this.xfaVersion;
    }

    public void processInstruction(Tag t) {
        if ("?originalXFAVersion".equals(t.getName())) {
            this.legacyPlusPrint = false;
            if (t.getAttributes() == null) {
                return;
            }
            for (String key : t.getAttributes().keySet()) {
                if (key.startsWith("LegacyPlusPrint:") && key.length() == 17) {
                    if (key.charAt(16) == '0') {
                        this.legacyPlusPrint = false;
                        break;
                    }
                    if (key.charAt(16) == '1') {
                        this.legacyPlusPrint = true;
                        break;
                    }
                }
                if (!key.startsWith(XfaSchema)) continue;
                this.xfaVersion = this.getVersionFromUrl(key);
                this.legacyPlusPrint = this.xfaVersion < 2.5f;
            }
        }
    }

    float getVersionFromUrl(String url) {
        float version;
        try {
            version = Float.parseFloat(url.substring(XfaSchema.length(), url.length() - 1));
        }
        catch (NumberFormatException e) {
            version = 0.0f;
        }
        return version;
    }
}

