/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.util;

import com.itextpdf.awt.geom.Point;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BadPdfFormatException;
import com.itextpdf.text.pdf.PRIndirectReference;
import com.itextpdf.text.pdf.PRStream;
import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfBoolean;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfLiteral;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.PdfStream;
import com.itextpdf.text.pdf.PdfWriter;
import com.itextpdf.text.pdf.RefKey;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class XFAPageAnnotationsCopier {
    private HashMap<RefKey, IndirectReferences> indirects = new HashMap();
    private PdfWriter writer;
    private boolean flatten = false;
    private static final Set<PdfName> supportedAnnotationTypes = new HashSet<PdfName>(Collections.singletonList(PdfName.LINE));

    public XFAPageAnnotationsCopier(PdfWriter writer, boolean flatten) {
        this.writer = writer;
        this.flatten = flatten;
    }

    public void copySupportedAnnotations(PdfReader reader, int pageNum) {
        PdfDictionary pageN = reader.getPageN(pageNum);
        PdfObject annotsObj = PdfReader.getPdfObject(pageN.get(PdfName.ANNOTS), pageN);
        if (annotsObj == null || !annotsObj.isArray()) {
            return;
        }
        PdfArray origPageAnnots = (PdfArray)annotsObj;
        ArrayList<PdfIndirectReference> annotsToCopy = new ArrayList<PdfIndirectReference>();
        for (int i = 0; i < origPageAnnots.size(); ++i) {
            PdfDictionary annotDict;
            PdfName subtype;
            PdfObject obj;
            PdfIndirectReference origAnnotIndRef = origPageAnnots.getAsIndirectObject(i);
            if (origAnnotIndRef == null || (obj = PdfReader.getPdfObject(origAnnotIndRef)) == null || !obj.isDictionary() || !supportedAnnotationTypes.contains(subtype = (annotDict = (PdfDictionary)obj).getAsName(PdfName.SUBTYPE))) continue;
            annotsToCopy.add(origAnnotIndRef);
        }
        if (annotsToCopy.isEmpty()) {
            return;
        }
        if (this.flatten) {
            this.flattenAnnots(annotsToCopy);
        } else {
            this.copyAnnots(pageNum, origPageAnnots, annotsToCopy);
        }
    }

    private void copyAnnots(int pageNum, PdfArray origPageAnnots, List<PdfIndirectReference> annotsToCopy) {
        LinkedHashMap<RefKey, PdfDictionary> origRefToCopiedAnnotDict = new LinkedHashMap<RefKey, PdfDictionary>();
        for (int i = 0; i < annotsToCopy.size(); ++i) {
            try {
                PdfIndirectReference annotToCopyIndRef = annotsToCopy.get(i);
                PdfObject obj = PdfReader.getPdfObject(annotToCopyIndRef);
                PdfDictionary annotToCopy = (PdfDictionary)obj;
                PdfDictionary copiedAnnot = this.copyDictionary(annotToCopy, true);
                PdfNumber flagsObj = copiedAnnot.getAsNumber(PdfName.F);
                int flags = 0;
                if (flagsObj != null) {
                    flags = flagsObj.intValue();
                }
                copiedAnnot.put(PdfName.F, new PdfNumber(flags |= 4));
                origRefToCopiedAnnotDict.put(new RefKey(annotToCopyIndRef), copiedAnnot);
                continue;
            }
            catch (IOException annotToCopyIndRef) {
                continue;
            }
            catch (BadPdfFormatException annotToCopyIndRef) {
                // empty catch block
            }
        }
        PdfArray newPageAnnots = new PdfArray();
        PdfIndirectReference writerPageReference = this.writer.getPageReference(pageNum);
        for (int i = 0; i < origPageAnnots.size(); ++i) {
            PdfIndirectReference parentAnnotIRef;
            PdfDictionary copiedParentAnnot;
            PdfDictionary origAnnotDict;
            PdfName subtype;
            PdfObject obj;
            PdfIndirectReference origAnnotIndRef = origPageAnnots.getAsIndirectObject(i);
            if (origAnnotIndRef == null || (obj = PdfReader.getPdfObject(origAnnotIndRef)) == null || !obj.isDictionary() || !PdfName.POPUP.equals(subtype = (origAnnotDict = (PdfDictionary)obj).getAsName(PdfName.SUBTYPE)) || (copiedParentAnnot = (PdfDictionary)origRefToCopiedAnnotDict.get(new RefKey(parentAnnotIRef = origAnnotDict.getAsIndirectObject(PdfName.PARENT)))) == null) continue;
            PdfDictionary copiedPopupAnnot = null;
            try {
                copiedPopupAnnot = this.copyDictionary(origAnnotDict, true);
            }
            catch (IOException iOException) {
            }
            catch (BadPdfFormatException badPdfFormatException) {
                // empty catch block
            }
            if (copiedPopupAnnot == null) continue;
            PdfIndirectReference copiedPopupRef = this.writer.getPdfIndirectReference();
            PdfIndirectReference copiedAnnotRef = this.writer.getPdfIndirectReference();
            copiedPopupAnnot.put(PdfName.PARENT, copiedAnnotRef);
            copiedParentAnnot.put(PdfName.POPUP, copiedPopupRef);
            copiedPopupAnnot.put(PdfName.P, writerPageReference);
            copiedParentAnnot.put(PdfName.P, writerPageReference);
            origRefToCopiedAnnotDict.remove(new RefKey(parentAnnotIRef));
            try {
                this.writer.addToBody((PdfObject)copiedParentAnnot, copiedAnnotRef);
                this.writer.addToBody((PdfObject)copiedPopupAnnot, copiedPopupRef);
                newPageAnnots.add(copiedAnnotRef);
                newPageAnnots.add(copiedPopupRef);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (PdfDictionary copiedAnnot : origRefToCopiedAnnotDict.values()) {
            PdfIndirectReference annotRef = this.writer.getPdfIndirectReference();
            copiedAnnot.put(PdfName.P, writerPageReference);
            try {
                this.writer.addToBody((PdfObject)copiedAnnot, annotRef);
                newPageAnnots.add(annotRef);
            }
            catch (IOException iOException) {}
        }
        this.writer.addPageDictEntry(PdfName.ANNOTS, newPageAnnots);
    }

    private void flattenAnnots(List<PdfIndirectReference> annotsToCopy) {
        for (int i = 0; i < annotsToCopy.size(); ++i) {
            try {
                PdfObject stateAppObj;
                PdfName as_p;
                PdfObject appRef;
                int flags;
                PdfIndirectReference annotToCopyIndRef = annotsToCopy.get(i);
                PdfDictionary annDic = (PdfDictionary)PdfReader.getPdfObject(annotToCopyIndRef);
                PdfNumber ff = annDic.getAsNumber(PdfName.F);
                int n = flags = ff != null ? ff.intValue() : 0;
                if ((flags & 4) == 0 || (flags & 2) != 0 || (appRef = annDic.get(PdfName.AP)) == null) continue;
                PdfDictionary appDic = appRef instanceof PdfIndirectReference ? (PdfDictionary)PdfReader.getPdfObject(appRef) : (PdfDictionary)appRef;
                PdfObject objN = appDic.get(PdfName.N);
                if (objN.isIndirect()) {
                    objN = PdfReader.getPdfObject(objN);
                }
                PdfStream appFormXObject = null;
                if (objN.isStream()) {
                    appFormXObject = (PdfStream)objN;
                } else if (objN.isDictionary() && (as_p = annDic.getAsName(PdfName.AS)) != null && (stateAppObj = ((PdfDictionary)objN).get(as_p)) instanceof PdfIndirectReference && (stateAppObj = PdfReader.getPdfObject(stateAppObj)).isStream()) {
                    appFormXObject = (PdfStream)stateAppObj;
                }
                if (appFormXObject == null || !(appFormXObject instanceof PRStream)) continue;
                appFormXObject = this.copyStream((PRStream)appFormXObject);
                appFormXObject.put(PdfName.SUBTYPE, PdfName.FORM);
                Rectangle rect = PdfReader.getNormalizedRectangle(annDic.getAsArray(PdfName.RECT));
                Rectangle bBox = PdfReader.getNormalizedRectangle(appFormXObject.getAsArray(PdfName.BBOX));
                PdfContentByte cb = this.writer.getDirectContent();
                if (appFormXObject.getAsArray(PdfName.MATRIX) != null && !Arrays.equals(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0}, appFormXObject.getAsArray(PdfName.MATRIX).asDoubleArray())) {
                    double[] matrix = appFormXObject.getAsArray(PdfName.MATRIX).asDoubleArray();
                    Rectangle transformBBox = this.transformBBoxByMatrix(bBox, matrix);
                    cb.addFormXObj(appFormXObject, new PdfName("Annot_" + i), rect.getWidth() / transformBBox.getWidth(), 0.0f, 0.0f, rect.getHeight() / transformBBox.getHeight(), rect.getLeft(), rect.getBottom());
                    continue;
                }
                float heightCorrection = -bBox.getBottom();
                float widthCorrection = -bBox.getLeft();
                cb.addFormXObj(appFormXObject, new PdfName("Annot_" + i), rect.getWidth() / bBox.getWidth(), 0.0f, 0.0f, rect.getHeight() / bBox.getHeight(), rect.getLeft() + widthCorrection, rect.getBottom() + heightCorrection);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private PdfDictionary copyDictionary(PdfDictionary in) throws IOException, BadPdfFormatException {
        return this.copyDictionary(in, false);
    }

    private PdfDictionary copyDictionary(PdfDictionary in, boolean isAnnotDict) throws IOException, BadPdfFormatException {
        PdfDictionary out = new PdfDictionary(in.size());
        Iterator<PdfName> iterator = in.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfObject value;
            PdfObject res;
            PdfName element;
            PdfName key = element = iterator.next();
            if (isAnnotDict && (key.equals(PdfName.P) || key.equals(PdfName.PARENT) || key.equals(PdfName.POPUP)) || (res = this.copyObject(value = in.get(key))) == null) continue;
            out.put(key, res);
        }
        return out;
    }

    private PdfStream copyStream(PRStream in) throws IOException, BadPdfFormatException {
        PRStream out = new PRStream(in, null);
        for (PdfName element : in.getKeys()) {
            PdfName key = element;
            PdfObject value = in.get(key);
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.put(key, res);
        }
        return out;
    }

    private PdfArray copyArray(PdfArray in) throws IOException, BadPdfFormatException {
        PdfArray out = new PdfArray(in.size());
        ListIterator<PdfObject> i = in.listIterator();
        while (i.hasNext()) {
            PdfObject value = (PdfObject)i.next();
            PdfObject res = this.copyObject(value);
            if (res == null) continue;
            out.add(res);
        }
        return out;
    }

    private PdfObject copyObject(PdfObject in) throws IOException, BadPdfFormatException {
        if (in == null) {
            return PdfNull.PDFNULL;
        }
        switch (in.type()) {
            case 6: {
                return this.copyDictionary((PdfDictionary)in);
            }
            case 10: {
                return this.copyIndirect((PRIndirectReference)in);
            }
            case 5: {
                return this.copyArray((PdfArray)in);
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 8: {
                return in;
            }
            case 7: {
                return this.copyStream((PRStream)in);
            }
        }
        if (in.type() < 0) {
            String lit = ((PdfLiteral)in).toString();
            if (lit.equals("true") || lit.equals("false")) {
                return new PdfBoolean(lit);
            }
            return new PdfLiteral(lit);
        }
        return null;
    }

    private PdfIndirectReference copyIndirect(PRIndirectReference in) throws IOException, BadPdfFormatException {
        PdfIndirectReference theRef;
        RefKey key = new RefKey((PdfIndirectReference)in);
        IndirectReferences iRef = this.indirects.get(key);
        if (iRef != null) {
            theRef = iRef.getRef();
            if (iRef.getCopied()) {
                return theRef;
            }
        } else {
            theRef = this.writer.getPdfIndirectReference();
            iRef = new IndirectReferences(theRef);
            this.indirects.put(key, iRef);
        }
        PdfObject obj = PdfReader.getPdfObjectRelease(in);
        PdfObject res = this.copyObject(obj);
        iRef.setCopied();
        if (res != null) {
            this.writer.addToBody(res, theRef);
            return theRef;
        }
        this.indirects.remove(key);
        return null;
    }

    private Rectangle transformBBoxByMatrix(Rectangle bBox, double[] matrix) {
        ArrayList<Double> xArr = new ArrayList<Double>();
        ArrayList<Double> yArr = new ArrayList<Double>();
        Point p1 = this.transformPoint(bBox.getLeft(), bBox.getBottom(), matrix);
        xArr.add(p1.x);
        yArr.add(p1.y);
        Point p2 = this.transformPoint(bBox.getRight(), bBox.getTop(), matrix);
        xArr.add(p2.x);
        yArr.add(p2.y);
        Point p3 = this.transformPoint(bBox.getLeft(), bBox.getTop(), matrix);
        xArr.add(p3.x);
        yArr.add(p3.y);
        Point p4 = this.transformPoint(bBox.getRight(), bBox.getBottom(), matrix);
        xArr.add(p4.x);
        yArr.add(p4.y);
        return new Rectangle(((Double)Collections.min(xArr)).floatValue(), ((Double)Collections.min(yArr)).floatValue(), ((Double)Collections.max(xArr)).floatValue(), ((Double)Collections.max(yArr)).floatValue());
    }

    private Point transformPoint(double x, double y, double[] matrix) {
        Point point = new Point();
        point.x = matrix[0] * x + matrix[2] * y + matrix[4];
        point.y = matrix[1] * x + matrix[3] * y + matrix[5];
        return point;
    }

    private static class IndirectReferences {
        PdfIndirectReference theRef;
        boolean hasCopied;

        IndirectReferences(PdfIndirectReference ref) {
            this.theRef = ref;
            this.hasCopied = false;
        }

        void setCopied() {
            this.hasCopied = true;
        }

        boolean getCopied() {
            return this.hasCopied;
        }

        PdfIndirectReference getRef() {
            return this.theRef;
        }

        public String toString() {
            String ext = "";
            if (this.hasCopied) {
                ext = ext + " Copied";
            }
            return this.getRef() + ext;
        }
    }
}

