/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.io;

import com.itextpdf.text.io.GroupedRandomAccessSource;
import com.itextpdf.text.io.MappedChannelRandomAccessSource;
import com.itextpdf.text.io.RandomAccessSource;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Iterator;
import java.util.LinkedList;

@Deprecated
class PagedChannelRandomAccessSource
extends GroupedRandomAccessSource
implements RandomAccessSource {
    public static final int DEFAULT_TOTAL_BUFSIZE = 0x4000000;
    public static final int DEFAULT_MAX_OPEN_BUFFERS = 16;
    private final int bufferSize;
    private final FileChannel channel;
    private final MRU<RandomAccessSource> mru;

    public PagedChannelRandomAccessSource(FileChannel channel) throws IOException {
        this(channel, 0x4000000, 16);
    }

    public PagedChannelRandomAccessSource(FileChannel channel, int totalBufferSize, int maxOpenBuffers) throws IOException {
        super(PagedChannelRandomAccessSource.buildSources(channel, totalBufferSize / maxOpenBuffers));
        this.channel = channel;
        this.bufferSize = totalBufferSize / maxOpenBuffers;
        this.mru = new MRU(maxOpenBuffers);
    }

    private static RandomAccessSource[] buildSources(FileChannel channel, int bufferSize) throws IOException {
        long size = channel.size();
        if (size <= 0L) {
            throw new IOException("File size must be greater than zero");
        }
        int bufferCount = (int)(size / (long)bufferSize) + (size % (long)bufferSize == 0L ? 0 : 1);
        RandomAccessSource[] sources = new MappedChannelRandomAccessSource[bufferCount];
        for (int i = 0; i < bufferCount; ++i) {
            long pageOffset = (long)i * (long)bufferSize;
            long pageLength = Math.min(size - pageOffset, (long)bufferSize);
            sources[i] = new MappedChannelRandomAccessSource(channel, pageOffset, pageLength);
        }
        return sources;
    }

    @Override
    protected int getStartingSourceIndex(long offset) {
        return (int)(offset / (long)this.bufferSize);
    }

    @Override
    protected void sourceReleased(RandomAccessSource source) throws IOException {
        RandomAccessSource old = this.mru.enqueue(source);
        if (old != null) {
            old.close();
        }
    }

    @Override
    protected void sourceInUse(RandomAccessSource source) throws IOException {
        ((MappedChannelRandomAccessSource)source).open();
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.channel.close();
    }

    private static class MRU<E> {
        private final int limit;
        private LinkedList<E> queue = new LinkedList();

        public MRU(int limit) {
            this.limit = limit;
        }

        public E enqueue(E newElement) {
            if (this.queue.size() > 0 && this.queue.getFirst() == newElement) {
                return null;
            }
            Iterator it = this.queue.iterator();
            while (it.hasNext()) {
                Object element = it.next();
                if (newElement != element) continue;
                it.remove();
                this.queue.addFirst(newElement);
                return null;
            }
            this.queue.addFirst(newElement);
            if (this.queue.size() > this.limit) {
                return this.queue.removeLast();
            }
            return null;
        }
    }
}

