/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.xtra.xfa.pipe;

import com.itextpdf.tool.xml.Pipeline;
import com.itextpdf.tool.xml.PipelineException;
import com.itextpdf.tool.xml.ProcessObject;
import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.WorkerContext;
import com.itextpdf.tool.xml.pipeline.AbstractPipeline;
import com.itextpdf.tool.xml.xtra.xfa.resolver.ConfigResolver;

public class ConfigPipeline
extends AbstractPipeline<ConfigResolver> {
    private Tag configRoot;
    private Tag presentNode;
    private Tag acrobatNode;
    private Tag acrobatCommonNode;

    public ConfigPipeline(Pipeline next) {
        super(next);
    }

    @Override
    public Pipeline<?> init(WorkerContext context) throws PipelineException {
        ConfigResolver configResolver = new ConfigResolver();
        context.put(this.getContextKey(), configResolver);
        return super.init(context);
    }

    @Override
    public Pipeline<?> open(WorkerContext context, Tag t, ProcessObject po) {
        String tagName = t.getName();
        if ("config".equals(tagName) && this.configRoot == null) {
            this.configRoot = t;
        } else if ("present".equals(tagName) && t.getParent() == this.configRoot) {
            this.presentNode = t;
        } else if ("acrobat".equals(tagName) && t.getParent() == this.configRoot) {
            this.acrobatNode = t;
        } else if ("common".equals(tagName) && t.getParent() == this.acrobatNode) {
            this.acrobatCommonNode = t;
        }
        return this.getNext();
    }

    @Override
    public Pipeline<?> content(WorkerContext ctx, Tag currentTag, String text, ProcessObject po) throws PipelineException {
        if ("locale".equals(currentTag.getName()) && currentTag.getParent() == this.acrobatCommonNode) {
            String localeName = text;
            ConfigResolver configResolver = (ConfigResolver)this.getLocalContext(ctx);
            configResolver.setDefaultAcrobatLocale(localeName);
        }
        return super.content(ctx, currentTag, text, po);
    }
}

