/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures;

import com.itextpdf.bouncycastleconnector.BouncyCastleFactoryCreator;
import com.itextpdf.commons.bouncycastle.IBouncyCastleFactory;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1InputStream;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Sequence;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Set;
import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.kernel.exceptions.PdfException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CertificateInfo {
    private static final IBouncyCastleFactory BOUNCY_CASTLE_FACTORY = BouncyCastleFactoryCreator.getFactory();

    public static X500Name getIssuerFields(X509Certificate cert) {
        try {
            return new X500Name(BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)CertificateInfo.getIssuer(cert.getTBSCertificate())));
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static IASN1Primitive getIssuer(byte[] enc) {
        try {
            IASN1Sequence seq;
            try (IASN1InputStream in = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(enc));){
                seq = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)in.readObject());
            }
            return BOUNCY_CASTLE_FACTORY.createASN1Primitive(seq.getObjectAt(BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(seq.getObjectAt(0)) == null ? 2 : 3));
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static X500Name getSubjectFields(X509Certificate cert) {
        try {
            if (cert != null) {
                return new X500Name(BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)CertificateInfo.getSubject(cert.getTBSCertificate())));
            }
        }
        catch (Exception e) {
            throw new PdfException((Throwable)e);
        }
        return null;
    }

    public static IASN1Primitive getSubject(byte[] enc) {
        try {
            IASN1Sequence seq;
            try (IASN1InputStream in = BOUNCY_CASTLE_FACTORY.createASN1InputStream((InputStream)new ByteArrayInputStream(enc));){
                seq = BOUNCY_CASTLE_FACTORY.createASN1Sequence((IASN1Encodable)in.readObject());
            }
            return BOUNCY_CASTLE_FACTORY.createASN1Primitive(seq.getObjectAt(BOUNCY_CASTLE_FACTORY.createASN1TaggedObject(seq.getObjectAt(0)) == null ? 4 : 5));
        }
        catch (IOException e) {
            throw new PdfException((Throwable)e);
        }
    }

    public static class X509NameTokenizer {
        private String oid;
        private int index;
        private StringBuffer buf = new StringBuffer();

        public X509NameTokenizer(String oid) {
            this.oid = oid;
            this.index = -1;
        }

        public boolean hasMoreTokens() {
            return this.index != this.oid.length();
        }

        public String nextToken() {
            int end;
            if (this.index == this.oid.length()) {
                return null;
            }
            boolean quoted = false;
            boolean escaped = false;
            this.buf.setLength(0);
            for (end = this.index + 1; end != this.oid.length(); ++end) {
                char c = this.oid.charAt(end);
                if (c == '\"') {
                    if (escaped) {
                        this.buf.append(c);
                    } else {
                        quoted = !quoted;
                    }
                    escaped = false;
                    continue;
                }
                if (escaped || quoted) {
                    this.buf.append(c);
                    escaped = false;
                    continue;
                }
                if (c == '\\') {
                    escaped = true;
                    continue;
                }
                if (c == ',') break;
                this.buf.append(c);
            }
            this.index = end;
            return this.buf.toString().trim();
        }
    }

    public static class X500Name {
        public static final IASN1ObjectIdentifier C = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.6");
        public static final IASN1ObjectIdentifier O = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.10");
        public static final IASN1ObjectIdentifier OU = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.11");
        public static final IASN1ObjectIdentifier T = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.12");
        public static final IASN1ObjectIdentifier CN = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.3");
        public static final IASN1ObjectIdentifier SN = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.5");
        public static final IASN1ObjectIdentifier L = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.7");
        public static final IASN1ObjectIdentifier ST = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.8");
        public static final IASN1ObjectIdentifier SURNAME = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.4");
        public static final IASN1ObjectIdentifier GIVENNAME = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.42");
        public static final IASN1ObjectIdentifier INITIALS = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.43");
        public static final IASN1ObjectIdentifier GENERATION = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.44");
        public static final IASN1ObjectIdentifier UNIQUE_IDENTIFIER = CertificateInfo.access$000().createASN1ObjectIdentifier("2.5.4.45");
        public static final IASN1ObjectIdentifier EmailAddress;
        public static final IASN1ObjectIdentifier E;
        public static final IASN1ObjectIdentifier DC;
        public static final IASN1ObjectIdentifier UID;
        public static final Map<IASN1ObjectIdentifier, String> DefaultSymbols;
        private final Map<String, List<String>> values = new HashMap<String, List<String>>();

        public X500Name(IASN1Sequence seq) {
            Enumeration e = seq.getObjects();
            while (e.hasMoreElements()) {
                IASN1Set set = BOUNCY_CASTLE_FACTORY.createASN1Set(e.nextElement());
                for (int i = 0; i < set.size(); ++i) {
                    IASN1Sequence s = BOUNCY_CASTLE_FACTORY.createASN1Sequence(set.getObjectAt(i));
                    String id = DefaultSymbols.get(BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier(s.getObjectAt(0)));
                    if (id == null) continue;
                    List<String> vs = this.values.get(id);
                    if (vs == null) {
                        vs = new ArrayList<String>();
                        this.values.put(id, vs);
                    }
                    vs.add(BOUNCY_CASTLE_FACTORY.createASN1String(s.getObjectAt(1)).getString());
                }
            }
        }

        public X500Name(String dirName) {
            X509NameTokenizer nTok = new X509NameTokenizer(dirName);
            while (nTok.hasMoreTokens()) {
                String token = nTok.nextToken();
                int index = token.indexOf(61);
                if (index == -1) {
                    throw new IllegalArgumentException();
                }
                String id = StringNormalizer.toUpperCase((String)token.substring(0, index));
                String value = token.substring(index + 1);
                List<String> vs = this.values.get(id);
                if (vs == null) {
                    vs = new ArrayList<String>();
                    this.values.put(id, vs);
                }
                vs.add(value);
            }
        }

        public String getField(String name) {
            List<String> vs = this.values.get(name);
            return vs == null ? null : vs.get(0);
        }

        public List<String> getFieldArray(String name) {
            return this.values.get(name);
        }

        public Map<String, List<String>> getFields() {
            return this.values;
        }

        public String toString() {
            return this.values.toString();
        }

        static {
            E = EmailAddress = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("1.2.840.113549.1.9.1");
            DC = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("0.9.2342.19200300.100.1.25");
            UID = BOUNCY_CASTLE_FACTORY.createASN1ObjectIdentifier("0.9.2342.19200300.100.1.1");
            DefaultSymbols = new HashMap<IASN1ObjectIdentifier, String>();
            DefaultSymbols.put(C, "C");
            DefaultSymbols.put(O, "O");
            DefaultSymbols.put(T, "T");
            DefaultSymbols.put(OU, "OU");
            DefaultSymbols.put(CN, "CN");
            DefaultSymbols.put(L, "L");
            DefaultSymbols.put(ST, "ST");
            DefaultSymbols.put(SN, "SN");
            DefaultSymbols.put(EmailAddress, "E");
            DefaultSymbols.put(DC, "DC");
            DefaultSymbols.put(UID, "UID");
            DefaultSymbols.put(SURNAME, "SURNAME");
            DefaultSymbols.put(GIVENNAME, "GIVENNAME");
            DefaultSymbols.put(INITIALS, "INITIALS");
            DefaultSymbols.put(GENERATION, "GENERATION");
        }
    }
}

