/*
 * Decompiled with CFR 0.152.
 */
package com.newrelic.agent.transaction;

import com.newrelic.agent.Agent;
import com.newrelic.agent.bridge.TransactionNamePriority;
import com.newrelic.agent.transaction.TransactionNamingScheme;
import com.newrelic.api.agent.NewRelic;
import java.util.logging.Level;

public class TransactionNamingUtility {
    public static boolean isGreaterThan(TransactionNamePriority one, TransactionNamePriority two, TransactionNamingScheme scheme) {
        return TransactionNamingUtility.comparePriority(one, two, scheme) > 0;
    }

    public static boolean isLessThan(TransactionNamePriority one, TransactionNamePriority two, TransactionNamingScheme scheme) {
        return TransactionNamingUtility.comparePriority(one, two, scheme) < 0;
    }

    public static int comparePriority(TransactionNamePriority one, TransactionNamePriority two, TransactionNamingScheme scheme) {
        if (TransactionNamingScheme.RESOURCE_BASED.equals((Object)scheme)) {
            if (NewRelic.getAgent().getLogger().isLoggable(Level.FINEST)) {
                Agent.LOG.log(Level.FINEST, "agent.transaction.TransactionNamingUtility::comparePriority: pathPriorityOneValue: {0}, pathPriorityTwoValue: {1}; return val will be {2}", one.pathPriority, two.pathPriority, one.pathPriority - two.pathPriority);
            }
            return one.pathPriority - two.pathPriority;
        }
        if (NewRelic.getAgent().getLogger().isLoggable(Level.FINEST)) {
            Agent.LOG.log(Level.FINEST, "agent.transaction.TransactionNamingUtility::comparePriority: legacyPriorityOneValue: {0}, legacyPriorityTwoValue: {1}; return val will be {2}", one.legacyPriority, two.legacyPriority, one.legacyPriority - two.legacyPriority);
        }
        return one.legacyPriority - two.legacyPriority;
    }
}

