/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.StatelessCheck;
import com.puppycrawl.tools.checkstyle.api.AbstractCheck;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.utils.CommonUtil;
import com.puppycrawl.tools.checkstyle.utils.ScopeUtil;

@StatelessCheck
public final class UnnecessarySemicolonAfterTypeMemberDeclarationCheck
extends AbstractCheck {
    public static final String MSG_SEMI = "unnecessary.semicolon";

    @Override
    public int[] getDefaultTokens() {
        return this.getAcceptableTokens();
    }

    @Override
    public int[] getAcceptableTokens() {
        return new int[]{14, 15, 154, 157, 10, 161, 12, 11, 8, 9, 155, 203, 199};
    }

    @Override
    public int[] getRequiredTokens() {
        return CommonUtil.EMPTY_INT_ARRAY;
    }

    @Override
    public void visitToken(DetailAST ast) {
        switch (ast.getType()) {
            case 14: 
            case 15: 
            case 154: 
            case 157: 
            case 199: {
                this.checkTypeDefinition(ast);
                break;
            }
            case 10: {
                this.checkVariableDefinition(ast);
                break;
            }
            case 155: {
                this.checkEnumConstant(ast);
                break;
            }
            default: {
                this.checkTypeMember(ast);
            }
        }
    }

    private void checkTypeMember(DetailAST ast) {
        if (UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(ast.getNextSibling())) {
            this.log(ast.getNextSibling(), MSG_SEMI, new Object[0]);
        }
    }

    private void checkTypeDefinition(DetailAST ast) {
        DetailAST firstMember;
        if (!ScopeUtil.isOuterMostType(ast) && UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(ast.getNextSibling())) {
            this.log(ast.getNextSibling(), MSG_SEMI, new Object[0]);
        }
        if (UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(firstMember = ast.findFirstToken(6).getFirstChild().getNextSibling()) && !ScopeUtil.isInEnumBlock(firstMember)) {
            this.log(firstMember, MSG_SEMI, new Object[0]);
        }
    }

    private void checkVariableDefinition(DetailAST variableDef) {
        if (UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(variableDef.getLastChild()) && UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(variableDef.getNextSibling())) {
            this.log(variableDef.getNextSibling(), MSG_SEMI, new Object[0]);
        }
    }

    private void checkEnumConstant(DetailAST ast) {
        DetailAST next = ast.getNextSibling();
        if (UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(next) && UnnecessarySemicolonAfterTypeMemberDeclarationCheck.isSemicolon(next.getNextSibling())) {
            this.log(next.getNextSibling(), MSG_SEMI, new Object[0]);
        }
    }

    private static boolean isSemicolon(DetailAST ast) {
        return ast.getType() == 45;
    }
}

