/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.indentation;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.checks.indentation.AbstractExpressionHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentLevel;
import com.puppycrawl.tools.checkstyle.checks.indentation.IndentationCheck;
import com.puppycrawl.tools.checkstyle.checks.indentation.MethodCallHandler;
import com.puppycrawl.tools.checkstyle.checks.indentation.NewHandler;

public class LambdaHandler
extends AbstractExpressionHandler {
    private boolean isLambdaCorrectlyIndented = true;

    public LambdaHandler(IndentationCheck indentCheck, DetailAST ast, AbstractExpressionHandler parent) {
        super(indentCheck, "lambda", ast, parent);
    }

    @Override
    public IndentLevel getSuggestedChildIndent(AbstractExpressionHandler child) {
        IndentLevel childIndent = this.getIndent();
        if (this.isLambdaCorrectlyIndented) {
            childIndent = IndentLevel.addAcceptable(childIndent, this.getLineStart(this.getMainAst()), this.getLineStart(this.getMainAst().getFirstChild()));
        }
        return childIndent;
    }

    @Override
    protected IndentLevel getIndentImpl() {
        if (this.getParent() instanceof MethodCallHandler) {
            return this.getParent().getSuggestedChildIndent(this);
        }
        DetailAST parent = this.getMainAst().getParent();
        if (this.getParent() instanceof NewHandler) {
            parent = parent.getParent();
        }
        IndentLevel level = new IndentLevel(this.getLineStart(parent));
        DetailAST firstChild = this.getMainAst().getFirstChild();
        if (this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild)) {
            level = new IndentLevel(level, this.getIndentCheck().getLineWrappingIndentation());
        }
        return level;
    }

    @Override
    public void checkIndentation() {
        int mainAstColumnNo;
        IndentLevel level;
        int firstChildColumnNo;
        DetailAST firstChild = this.getMainAst().getFirstChild();
        DetailAST parent = this.getMainAst().getParent();
        if (parent.getType() != 208 && this.getLineStart(firstChild) == this.expandedTabsColumnNo(firstChild) && this.isNonAcceptableIndent(firstChildColumnNo = this.expandedTabsColumnNo(firstChild), level = this.getIndent())) {
            this.isLambdaCorrectlyIndented = false;
            this.logError(firstChild, "arguments", firstChildColumnNo, level);
        }
        if ((mainAstColumnNo = this.expandedTabsColumnNo(this.getMainAst())) == this.getLineStart(this.getMainAst()) && this.isNonAcceptableIndent(mainAstColumnNo, level = new IndentLevel(this.getIndent(), this.getIndentCheck().getLineWrappingIndentation()))) {
            this.isLambdaCorrectlyIndented = false;
            this.logError(this.getMainAst(), "", mainAstColumnNo, level);
        }
    }

    private boolean isNonAcceptableIndent(int astColumnNo, IndentLevel level) {
        return astColumnNo < level.getFirstIndentLevel() || this.getIndentCheck().isForceStrictCondition() && !level.isAcceptable(astColumnNo);
    }
}

