/*
 * Decompiled with CFR 0.152.
 */
package io.github.detekt.report.xml;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u001d\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0082\u0002\u00a8\u0006\u000f"}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer;", "", "<init>", "()V", "initializeXml10", "Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols;", "set", "", "", "c", "", "value", "", "XmlCodepointValidator", "XmlEscapeSymbols", "detekt-report-xml"})
final class Xml10EscapeSymbolsInitializer {
    @NotNull
    public static final Xml10EscapeSymbolsInitializer INSTANCE = new Xml10EscapeSymbolsInitializer();

    private Xml10EscapeSymbolsInitializer() {
    }

    @NotNull
    public final XmlEscapeSymbols initializeXml10() {
        int c;
        XmlEscapeSymbols.References xml10References = new XmlEscapeSymbols.References();
        xml10References.addReference(34, "&quot;");
        xml10References.addReference(38, "&amp;");
        xml10References.addReference(39, "&apos;");
        xml10References.addReference(60, "&lt;");
        xml10References.addReference(62, "&gt;");
        byte[] escapeLevels = new byte[161];
        ArraysKt.fill$default((byte[])escapeLevels, (byte)3, (int)0, (int)0, (int)6, null);
        for (c = 128; c < 161; ++c) {
            escapeLevels[c] = 2;
        }
        Xml10EscapeSymbolsInitializer $this$initializeXml10_u24lambda_u240 = this;
        boolean bl = false;
        char c2 = 'A';
        while (Intrinsics.compare((int)c2, (int)90) <= 0) {
            $this$initializeXml10_u24lambda_u240.set(escapeLevels, c2, (byte)4);
            c2 = (char)(c2 + '\u0001');
        }
        Xml10EscapeSymbolsInitializer $this$initializeXml10_u24lambda_u241 = this;
        boolean bl2 = false;
        c2 = 'a';
        while (Intrinsics.compare((int)c2, (int)122) <= 0) {
            $this$initializeXml10_u24lambda_u241.set(escapeLevels, c2, (byte)4);
            c2 = (char)(c2 + '\u0001');
        }
        Xml10EscapeSymbolsInitializer $this$initializeXml10_u24lambda_u242 = this;
        boolean bl3 = false;
        c2 = '0';
        while (Intrinsics.compare((int)c2, (int)57) <= 0) {
            $this$initializeXml10_u24lambda_u242.set(escapeLevels, c2, (byte)4);
            c2 = (char)(c2 + '\u0001');
        }
        this.set(escapeLevels, '\'', (byte)1);
        this.set(escapeLevels, '\"', (byte)1);
        this.set(escapeLevels, '<', (byte)1);
        this.set(escapeLevels, '>', (byte)1);
        this.set(escapeLevels, '&', (byte)1);
        for (c = 127; c < 133; ++c) {
            escapeLevels[c] = 1;
        }
        for (c = 134; c < 160; ++c) {
            escapeLevels[c] = 1;
        }
        return new XmlEscapeSymbols(xml10References, escapeLevels, new XmlCodepointValidator());
    }

    private final void set(byte[] $this$set, char c, byte value) {
        Intrinsics.checkNotNullParameter((Object)$this$set, (String)"<this>");
        $this$set[c] = value;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlCodepointValidator;", "", "<init>", "()V", "isValid", "", "codepoint", "", "detekt-report-xml"})
    public static final class XmlCodepointValidator {
        public final boolean isValid(int codepoint) {
            if (codepoint < 32) {
                return codepoint == 9 || codepoint == 10 || codepoint == 13;
            }
            if (codepoint <= 55295) {
                return true;
            }
            if (codepoint < 57344) {
                return false;
            }
            if (codepoint <= 65533) {
                return true;
            }
            return codepoint >= 65536;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u0019\n\u0002\b\u000b\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001d\u001e\u001fB!\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0013\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u0019\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u0014\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u001a\u0010\u0017R\u0011\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0012\u00a8\u0006 "}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols;", "", "references", "Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$References;", "escapeLevels", "", "CODEPOINT_VALIDATOR", "Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlCodepointValidator;", "<init>", "(Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$References;[BLio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlCodepointValidator;)V", "getCODEPOINT_VALIDATOR", "()Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlCodepointValidator;", "ESCAPE_LEVELS", "getESCAPE_LEVELS", "()[B", "SORTED_CODEPOINTS", "", "getSORTED_CODEPOINTS", "()[I", "SORTED_CERS_BY_CODEPOINT", "", "", "getSORTED_CERS_BY_CODEPOINT", "()[[C", "[[C", "SORTED_CERS", "getSORTED_CERS", "SORTED_CODEPOINTS_BY_CER", "getSORTED_CODEPOINTS_BY_CER", "References", "Reference", "Companion", "detekt-report-xml"})
    public static final class XmlEscapeSymbols {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final XmlCodepointValidator CODEPOINT_VALIDATOR;
        @NotNull
        private final byte[] ESCAPE_LEVELS;
        @NotNull
        private final int[] SORTED_CODEPOINTS;
        @NotNull
        private final char[][] SORTED_CERS_BY_CODEPOINT;
        @NotNull
        private final char[][] SORTED_CERS;
        @NotNull
        private final int[] SORTED_CODEPOINTS_BY_CER;
        public static final int LEVELS_LEN = 161;

        public XmlEscapeSymbols(@NotNull References references, @NotNull byte[] escapeLevels, @NotNull XmlCodepointValidator CODEPOINT_VALIDATOR) {
            int j;
            int i;
            Intrinsics.checkNotNullParameter((Object)references, (String)"references");
            Intrinsics.checkNotNullParameter((Object)escapeLevels, (String)"escapeLevels");
            Intrinsics.checkNotNullParameter((Object)CODEPOINT_VALIDATOR, (String)"CODEPOINT_VALIDATOR");
            this.CODEPOINT_VALIDATOR = CODEPOINT_VALIDATOR;
            this.ESCAPE_LEVELS = new byte[161];
            System.arraycopy(escapeLevels, 0, this.ESCAPE_LEVELS, 0, 161);
            int structureLen = references.getReferences$detekt_report_xml().size();
            ArrayList<char[]> cers = new ArrayList<char[]>(structureLen + 5);
            ArrayList<Integer> codepoints = new ArrayList<Integer>(structureLen + 5);
            Iterator<Reference> iterator = references.getReferences$detekt_report_xml().iterator();
            Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
            Iterator<Reference> iterator2 = iterator;
            while (iterator2.hasNext()) {
                Reference reference;
                Intrinsics.checkNotNullExpressionValue((Object)iterator2.next(), (String)"next(...)");
                cers.add(reference.getCer$detekt_report_xml());
                codepoints.add(reference.getCodepoint$detekt_report_xml());
            }
            this.SORTED_CODEPOINTS = new int[structureLen];
            this.SORTED_CERS_BY_CODEPOINT = new char[structureLen][];
            this.SORTED_CERS = new char[structureLen][];
            this.SORTED_CODEPOINTS_BY_CER = new int[structureLen];
            ArrayList cersOrdered = new ArrayList(cers);
            CollectionsKt.sortWith((List)cersOrdered, (arg_0, arg_1) -> XmlEscapeSymbols._init_$lambda$1(XmlEscapeSymbols::_init_$lambda$0, arg_0, arg_1));
            ArrayList codepointsOrdered = new ArrayList(codepoints);
            CollectionsKt.sort((List)codepointsOrdered);
            block1: for (i = 0; i < structureLen; ++i) {
                Integer codepoint = (Integer)codepointsOrdered.get(i);
                Intrinsics.checkNotNull((Object)codepoint);
                this.SORTED_CODEPOINTS[i] = codepoint;
                for (j = 0; j < structureLen; ++j) {
                    if (!Intrinsics.areEqual((Object)codepoint, codepoints.get(j))) continue;
                    this.SORTED_CERS_BY_CODEPOINT[i] = (char[])cers.get(j);
                    continue block1;
                }
            }
            block3: for (i = 0; i < structureLen; ++i) {
                char[] cer = (char[])cersOrdered.get(i);
                this.SORTED_CERS[i] = cer;
                for (j = 0; j < structureLen; ++j) {
                    if (!Arrays.equals(cer, (char[])cers.get(j))) continue;
                    Object e = codepoints.get(j);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"get(...)");
                    this.SORTED_CODEPOINTS_BY_CER[i] = ((Number)e).intValue();
                    continue block3;
                }
            }
        }

        @NotNull
        public final XmlCodepointValidator getCODEPOINT_VALIDATOR() {
            return this.CODEPOINT_VALIDATOR;
        }

        @NotNull
        public final byte[] getESCAPE_LEVELS() {
            return this.ESCAPE_LEVELS;
        }

        @NotNull
        public final int[] getSORTED_CODEPOINTS() {
            return this.SORTED_CODEPOINTS;
        }

        @NotNull
        public final char[][] getSORTED_CERS_BY_CODEPOINT() {
            return this.SORTED_CERS_BY_CODEPOINT;
        }

        @NotNull
        public final char[][] getSORTED_CERS() {
            return this.SORTED_CERS;
        }

        @NotNull
        public final int[] getSORTED_CODEPOINTS_BY_CER() {
            return this.SORTED_CODEPOINTS_BY_CER;
        }

        private static final int _init_$lambda$0(char[] o1, char[] o2) {
            Intrinsics.checkNotNull((Object)o1);
            String string = new String(o1);
            Intrinsics.checkNotNull((Object)o2);
            return string.compareTo(new String(o2));
        }

        private static final int _init_$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return ((Number)$tmp0.invoke(p0, p1)).intValue();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$Companion;", "", "<init>", "()V", "LEVELS_LEN", "", "detekt-report-xml"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0019\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\nX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$Reference;", "", "cer", "", "codepoint", "", "<init>", "(Ljava/lang/String;I)V", "getCodepoint$detekt_report_xml", "()I", "", "getCer$detekt_report_xml", "()[C", "detekt-report-xml"})
        public static final class Reference {
            private final int codepoint;
            @NotNull
            private final char[] cer;

            public Reference(@NotNull String cer, int codepoint) {
                Intrinsics.checkNotNullParameter((Object)cer, (String)"cer");
                this.codepoint = codepoint;
                char[] cArray = cer.toCharArray();
                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
                this.cer = cArray;
            }

            public final int getCodepoint$detekt_report_xml() {
                return this.codepoint;
            }

            @NotNull
            public final char[] getCer$detekt_report_xml() {
                return this.cer;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u000f"}, d2={"Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$References;", "", "<init>", "()V", "references", "Ljava/util/ArrayList;", "Lio/github/detekt/report/xml/Xml10EscapeSymbolsInitializer$XmlEscapeSymbols$Reference;", "getReferences$detekt_report_xml", "()Ljava/util/ArrayList;", "addReference", "", "codepoint", "", "cer", "", "detekt-report-xml"})
        public static final class References {
            @NotNull
            private final ArrayList<Reference> references = new ArrayList(200);

            @NotNull
            public final ArrayList<Reference> getReferences$detekt_report_xml() {
                return this.references;
            }

            public final void addReference(int codepoint, @NotNull String cer) {
                Intrinsics.checkNotNullParameter((Object)cer, (String)"cer");
                this.references.add(new Reference(cer, codepoint));
            }
        }
    }
}

