/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.AnnotationExcluder;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.complexity.LongParameterList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtSecondaryConstructor;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 C2\u00020\u0001:\u0001CB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020/2\u0006\u0010(\u001a\u00020\b2\u0006\u00100\u001a\u00020\u0015H\u0002J\u0014\u00101\u001a\u00020-2\n\u00102\u001a\u0006\u0012\u0002\b\u000303H\u0002J\u0010\u00104\u001a\u00020-2\u0006\u00105\u001a\u000206H\u0016J\u0010\u00107\u001a\u00020-2\u0006\u0010.\u001a\u000208H\u0016J\u0010\u00109\u001a\u00020-2\u0006\u00102\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020-2\u0006\u00102\u001a\u00020<H\u0016J\f\u0010=\u001a\u00020\u001b*\u00020>H\u0002J\f\u0010?\u001a\u00020\u001b*\u00020@H\u0002J\f\u0010A\u001a\u00020\b*\u00020BH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u0012\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR!\u0010\u000f\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u0012\u0004\b\u0010\u0010\n\u001a\u0004\b\u0011\u0010\fR'\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u000e\u0012\u0004\b\u0016\u0010\n\u001a\u0004\b\u0017\u0010\u0018R!\u0010\u001a\u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u000e\u0012\u0004\b\u001c\u0010\n\u001a\u0004\b\u001d\u0010\u001eR!\u0010 \u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u000e\u0012\u0004\b!\u0010\n\u001a\u0004\b\"\u0010\u001eR\u0014\u0010$\u001a\u00020%X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R!\u0010(\u001a\u00020\b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u000e\u0012\u0004\b)\u0010\n\u001a\u0004\b*\u0010\f\u00a8\u0006D"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "annotationExcluder", "Lio/gitlab/arturbosch/detekt/api/AnnotationExcluder;", "constructorThreshold", "", "getConstructorThreshold$annotations", "()V", "getConstructorThreshold", "()I", "constructorThreshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "functionThreshold", "getFunctionThreshold$annotations", "getFunctionThreshold", "functionThreshold$delegate", "ignoreAnnotated", "", "", "getIgnoreAnnotated$annotations", "getIgnoreAnnotated", "()Ljava/util/List;", "ignoreAnnotated$delegate", "ignoreDataClasses", "", "getIgnoreDataClasses$annotations", "getIgnoreDataClasses", "()Z", "ignoreDataClasses$delegate", "ignoreDefaultParameters", "getIgnoreDefaultParameters$annotations", "getIgnoreDefaultParameters", "ignoreDefaultParameters$delegate", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "getThreshold$annotations", "getThreshold", "threshold$delegate", "checkLongParameterList", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "identifier", "validateConstructor", "constructor", "Lorg/jetbrains/kotlin/psi/KtConstructor;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "visitNamedFunction", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitPrimaryConstructor", "Lorg/jetbrains/kotlin/psi/KtPrimaryConstructor;", "visitSecondaryConstructor", "Lorg/jetbrains/kotlin/psi/KtSecondaryConstructor;", "isDataClassOrIgnored", "Lorg/jetbrains/kotlin/psi/KtClass;", "isIgnored", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "parameterCount", "Lorg/jetbrains/kotlin/psi/KtParameterList;", "Companion", "detekt-rules-complexity"})
public final class LongParameterList
extends Rule {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;
    @NotNull
    private final ReadOnlyProperty functionThreshold$delegate;
    @NotNull
    private final ReadOnlyProperty constructorThreshold$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDefaultParameters$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreDataClasses$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreAnnotated$delegate;
    private AnnotationExcluder annotationExcluder;
    private static final int DEFAULT_FUNCTION_THRESHOLD = 6;
    private static final int DEFAULT_CONSTRUCTOR_THRESHOLD = 7;

    public LongParameterList(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("LongParameterList", Severity.Maintainability, "The more parameters a function has the more complex it is. Long parameter lists are often used to control complex algorithms and violate the Single Responsibility Principle. Prefer functions with short parameter lists.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)6);
        this.functionThreshold$delegate = ConfigPropertyKt.configWithFallback((String)"threshold", (Object)6);
        this.constructorThreshold$delegate = ConfigPropertyKt.configWithFallback((String)"threshold", (Object)7);
        this.ignoreDefaultParameters$delegate = ConfigPropertyKt.config((Object)false);
        this.ignoreDataClasses$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreAnnotated$delegate = ConfigPropertyKt.config((Object)CollectionsKt.emptyList(), (Function1)ignoreAnnotated.2.INSTANCE);
    }

    public /* synthetic */ LongParameterList(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Deprecated(message="Use `functionThreshold` and `constructorThreshold` instead")
    @Configuration(description="number of parameters required to trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    private final int getFunctionThreshold() {
        return ((Number)this.functionThreshold$delegate.getValue((Object)this, $$delegatedProperties[1])).intValue();
    }

    @Configuration(description="number of function parameters required to trigger the rule")
    private static /* synthetic */ void getFunctionThreshold$annotations() {
    }

    private final int getConstructorThreshold() {
        return ((Number)this.constructorThreshold$delegate.getValue((Object)this, $$delegatedProperties[2])).intValue();
    }

    @Configuration(description="number of constructor parameters required to trigger the rule")
    private static /* synthetic */ void getConstructorThreshold$annotations() {
    }

    private final boolean getIgnoreDefaultParameters() {
        return (Boolean)this.ignoreDefaultParameters$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignore parameters that have a default value")
    private static /* synthetic */ void getIgnoreDefaultParameters$annotations() {
    }

    private final boolean getIgnoreDataClasses() {
        return (Boolean)this.ignoreDataClasses$delegate.getValue((Object)this, $$delegatedProperties[4]);
    }

    @Configuration(description="ignore long constructor parameters list for data classes")
    private static /* synthetic */ void getIgnoreDataClasses$annotations() {
    }

    private final List<String> getIgnoreAnnotated() {
        return (List)this.ignoreAnnotated$delegate.getValue((Object)this, $$delegatedProperties[5]);
    }

    @Configuration(description="ignore long parameters list for constructors, functions or their parameters in the context of these annotation class names; (e.g. ['Inject', 'Module', 'Suppress', 'Value']); the most common cases are for dependency injection where constructors are annotated with `@Inject` or parameters are annotated with `@Value` and should not be counted for the rule to trigger")
    private static /* synthetic */ void getIgnoreAnnotated$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this.annotationExcluder = new AnnotationExcluder(file, this.getIgnoreAnnotated());
        super.visitKtFile(file);
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        KtClassOrObject owner = KtPsiUtilKt.getContainingClassOrObject((KtDeclaration)((KtDeclaration)function));
        if (owner instanceof KtClass && this.isIgnored((KtAnnotated)owner)) {
            return;
        }
        this.checkLongParameterList((KtFunction)function, this.getFunctionThreshold(), Intrinsics.stringPlus((String)"function ", (Object)function.getNameAsSafeName()));
    }

    public void visitPrimaryConstructor(@NotNull KtPrimaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    public void visitSecondaryConstructor(@NotNull KtSecondaryConstructor constructor) {
        Intrinsics.checkNotNullParameter((Object)constructor, (String)"constructor");
        this.validateConstructor((KtConstructor)constructor);
    }

    private final boolean isIgnored(KtAnnotated $this$isIgnored) {
        Object object = this.annotationExcluder;
        if (object == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"annotationExcluder");
            throw null;
        }
        AnnotationExcluder annotationExcluder = object;
        object = $this$isIgnored.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"annotationEntries");
        return annotationExcluder.shouldExclude((List)object);
    }

    private final void validateConstructor(KtConstructor<?> constructor) {
        KtClassOrObject owner = constructor.getContainingClassOrObject();
        if (owner instanceof KtClass && this.isDataClassOrIgnored((KtClass)owner)) {
            return;
        }
        this.checkLongParameterList((KtFunction)constructor, this.getConstructorThreshold(), "constructor");
    }

    private final boolean isDataClassOrIgnored(KtClass $this$isDataClassOrIgnored) {
        return this.isIgnored((KtAnnotated)$this$isDataClassOrIgnored) || this.getIgnoreDataClasses() && $this$isDataClassOrIgnored.isData();
    }

    private final void checkLongParameterList(KtFunction function, int threshold, String identifier) {
        block6: {
            block5: {
                if (KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)function)) || this.isIgnored((KtAnnotated)function)) break block5;
                KtFile ktFile = function.getContainingKtFile();
                Intrinsics.checkNotNullExpressionValue((Object)ktFile, (String)"function.containingKtFile");
                if (!this.isIgnored((KtAnnotated)ktFile)) break block6;
            }
            return;
        }
        KtParameterList ktParameterList = function.getValueParameterList();
        if (ktParameterList == null) {
            return;
        }
        KtParameterList ktParameterList2 = ktParameterList;
        KtParameterList parameterList = ktParameterList2;
        int parameterNumber = this.parameterCount(parameterList);
        if (parameterNumber >= threshold) {
            List list = function.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"function.valueParameters");
            String parameterPrint2 = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)", ", null, null, (int)0, null, (Function1)checkLongParameterList.parameterPrint.1.INSTANCE, (int)30, null);
            this.report((Finding)new ThresholdedCodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameterList), (int)0, (int)2, null), new Metric("SIZE", parameterNumber, threshold, false, 0, 24, null), "The " + identifier + '(' + parameterPrint2 + ") has too many parameters. The current threshold is set to " + threshold + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final int parameterCount(KtParameterList $this$parameterCount) {
        int n;
        void $this$filterTo$iv$iv;
        List list = $this$parameterCount.getParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"parameters");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtParameter it = (KtParameter)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            if (!(!this.isIgnored((KtAnnotated)it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List preFilteredParameters = (List)destination$iv$iv;
        if (this.getIgnoreDefaultParameters()) {
            Iterable $this$count$iv = preFilteredParameters;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    KtParameter it = (KtParameter)element$iv;
                    boolean bl = false;
                    if (!(!it.hasDefaultValue())) continue;
                    int n2 = ++count$iv;
                    boolean bl2 = false;
                    if (n2 >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
        } else {
            n = preFilteredParameters.size();
        }
        return n;
    }

    public LongParameterList() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "threshold", "getThreshold()I"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "functionThreshold", "getFunctionThreshold()I"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "constructorThreshold", "getConstructorThreshold()I"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "ignoreDefaultParameters", "getIgnoreDefaultParameters()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "ignoreDataClasses", "getIgnoreDataClasses()Z"))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LongParameterList.class), "ignoreAnnotated", "getIgnoreAnnotated()Ljava/util/List;")))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongParameterList$Companion;", "", "()V", "DEFAULT_CONSTRUCTOR_THRESHOLD", "", "DEFAULT_FUNCTION_THRESHOLD", "detekt-rules-complexity"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

