/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.DetektVisitor;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiElementVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0018B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u00020\n8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000f\u0010\u0010\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "threshold", "", "getThreshold$annotations", "()V", "getThreshold", "()I", "threshold$delegate", "Lkotlin/properties/ReadOnlyProperty;", "visitClassOrObject", "", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitKtFile", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "OverloadedMethodVisitor", "detekt-rules-complexity"})
public final class MethodOverloading
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty threshold$delegate;

    public MethodOverloading(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MethodOverloading", Severity.Maintainability, "Methods which are overloaded often might be harder to maintain. Furthermore, these methods are tightly coupled. Refactor these methods and try to use optional parameters.", Debt.Companion.getTWENTY_MINS());
        this.threshold$delegate = ConfigPropertyKt.config((Object)6);
    }

    public /* synthetic */ MethodOverloading(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final int getThreshold() {
        return ((Number)this.threshold$delegate.getValue((Object)this, $$delegatedProperties[0])).intValue();
    }

    @Configuration(description="number of overloads which will trigger the rule")
    private static /* synthetic */ void getThreshold$annotations() {
    }

    public void visitKtFile(@NotNull KtFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        OverloadedMethodVisitor visitor = new OverloadedMethodVisitor();
        PsiElement $this$getChildrenOfType$iv = (PsiElement)file;
        boolean $i$f$getChildrenOfType = false;
        PsiElement[] psiElementArray = PsiTreeUtil.getChildrenOfType((PsiElement)$this$getChildrenOfType$iv, KtNamedFunction.class);
        PsiElement[] $this$forEach$iv = psiElementArray == null ? (PsiElement[])new KtNamedFunction[0] : psiElementArray;
        boolean $i$f$forEach = false;
        for (PsiElement element$iv : $this$forEach$iv) {
            KtNamedFunction it = (KtNamedFunction)element$iv;
            boolean bl = false;
            visitor.visitMethod(it);
        }
        visitor.reportIfThresholdExceeded(Entity.Companion.atPackageOrFirstDecl(file));
        super.visitKtFile(file);
    }

    public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
        Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
        OverloadedMethodVisitor visitor = new OverloadedMethodVisitor();
        classOrObject.accept((PsiElementVisitor)visitor);
        visitor.reportIfThresholdExceeded(Entity.Companion.atName((KtNamedDeclaration)classOrObject));
        super.visitClassOrObject(classOrObject);
    }

    public MethodOverloading() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(MethodOverloading.class), "threshold", "getThreshold()I")))};
        $$delegatedProperties = kPropertyArray;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0080\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u0011H\u0002R*\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading$OverloadedMethodVisitor;", "Lio/gitlab/arturbosch/detekt/api/DetektVisitor;", "(Lio/gitlab/arturbosch/detekt/rules/complexity/MethodOverloading;)V", "methods", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "reportIfThresholdExceeded", "", "entity", "Lio/gitlab/arturbosch/detekt/api/Entity;", "visitClassOrObject", "classOrObject", "Lorg/jetbrains/kotlin/psi/KtClassOrObject;", "visitMethod", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isOverriddenInsideEnumEntry", "", "detekt-rules-complexity"})
    public final class OverloadedMethodVisitor
    extends DetektVisitor {
        @NotNull
        private HashMap<String, Integer> methods;

        public OverloadedMethodVisitor() {
            Intrinsics.checkNotNullParameter((Object)((Object)MethodOverloading.this), (String)"this$0");
            this.methods = new HashMap();
        }

        /*
         * WARNING - void declaration
         */
        public final void reportIfThresholdExceeded(@NotNull Entity entity) {
            void $this$filterValues$iv;
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Object object = this.methods;
            MethodOverloading methodOverloading = MethodOverloading.this;
            boolean $i$f$filterValues2 = false;
            LinkedHashMap result$iv = new LinkedHashMap();
            void var7_10 = $this$filterValues$iv;
            boolean bl = false;
            for (Map.Entry entry$iv : var7_10.entrySet()) {
                int it = ((Number)entry$iv.getValue()).intValue();
                boolean bl2 = false;
                if (!(it >= methodOverloading.getThreshold())) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            object = result$iv;
            boolean bl3 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                Object $i$f$filterValues2 = object = iterator.next();
                boolean bl4 = false;
                String name = (String)$i$f$filterValues2.getKey();
                Object object2 = object;
                boolean bl5 = false;
                int value = ((Number)object2.getValue()).intValue();
                MethodOverloading.this.report((Finding)new ThresholdedCodeSmell(MethodOverloading.this.getIssue(), entity, new Metric("OVERLOAD SIZE: ", value, MethodOverloading.this.getThreshold(), false, 0, 24, null), "The method '" + name + "' is overloaded " + value + " times.", null, 16, null));
            }
        }

        public void visitClassOrObject(@NotNull KtClassOrObject classOrObject) {
            Intrinsics.checkNotNullParameter((Object)classOrObject, (String)"classOrObject");
            KtClassBody ktClassBody = classOrObject.getBody();
            if (ktClassBody == null) {
                return;
            }
            KtClassBody body = ktClassBody;
            Iterable $this$forEach$iv = body.getFunctions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtNamedFunction it = (KtNamedFunction)element$iv;
                boolean bl = false;
                this.visitMethod(it);
            }
            $this$forEach$iv = body.getEnumEntries();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                List list;
                KtEnumEntry enumEntry = (KtEnumEntry)element$iv;
                boolean bl = false;
                KtClassBody ktClassBody2 = enumEntry.getBody();
                if (ktClassBody2 == null || (list = ktClassBody2.getFunctions()) == null) continue;
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    KtNamedFunction it = (KtNamedFunction)element$iv2;
                    boolean bl2 = false;
                    this.visitMethod(it);
                }
            }
        }

        public final void visitMethod(@NotNull KtNamedFunction function) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            String name = function.getName();
            if (name == null || this.isOverriddenInsideEnumEntry(function)) {
                return;
            }
            KtTypeReference receiver = function.getReceiverTypeReference();
            if (KtPsiUtilKt.isExtensionDeclaration((PsiElement)((PsiElement)function)) && receiver != null) {
                name = receiver.getText() + '.' + name;
            }
            Map map = this.methods;
            Integer n = ((Number)this.methods.getOrDefault(name, 0)).intValue() + 1;
            boolean bl = false;
            map.put(name, n);
        }

        private final boolean isOverriddenInsideEnumEntry(KtNamedFunction $this$isOverriddenInsideEnumEntry) {
            return KtPsiUtilKt.containingClass((KtElement)((KtElement)$this$isOverriddenInsideEnumEntry)) instanceof KtEnumEntry && KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)$this$isOverriddenInsideEnumEntry));
        }
    }
}

