/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.cfg.WhenChecker;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.load.kotlin.ModuleVisibilityUtilsKt;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/RedundantElseInWhen;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitWhenExpression", "", "whenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "detekt-rules-errorprone"})
public final class RedundantElseInWhen
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitWhenExpression(@NotNull KtWhenExpression whenExpression) {
        block8: {
            block9: {
                ClassDescriptor classDescriptor;
                Intrinsics.checkNotNullParameter((Object)whenExpression, (String)"whenExpression");
                if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                    return;
                }
                if (whenExpression.getElseExpression() == null) {
                    return;
                }
                KtExpression ktExpression = whenExpression.getSubjectExpression();
                if (ktExpression == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"whenExpression.subjectExpression ?: return");
                KtExpression subjectExpression = ktExpression;
                KotlinType kotlinType = CallUtilKt.getType((KtExpression)subjectExpression, (BindingContext)this.getBindingContext());
                if (kotlinType == null) {
                    return;
                }
                KotlinType subjectType = kotlinType;
                if (!WhenChecker.INSTANCE.getMissingCases(whenExpression, this.getBindingContext()).isEmpty()) break block8;
                ClassifierDescriptor classifierDescriptor = subjectType.getConstructor().getDeclarationDescriptor();
                if (!(classifierDescriptor instanceof ClassDescriptor)) {
                    classifierDescriptor = null;
                }
                ClassDescriptor subjectClass = (ClassDescriptor)classifierDescriptor;
                DeclarationDescriptor pseudocodeDescriptor = (DeclarationDescriptor)this.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, (classDescriptor = subjectClass) != null && (classDescriptor = ModuleVisibilityUtilsKt.getToSourceElement((DeclarationDescriptor)((DeclarationDescriptor)classDescriptor))) != null ? KotlinSourceElementKt.getPsi((SourceElement)classDescriptor) : null);
                if (subjectClass == null || KotlinBuiltIns.isBooleanOrNullableBoolean((KotlinType)subjectType)) break block9;
                DeclarationDescriptor declarationDescriptor = pseudocodeDescriptor;
                if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)subjectClass)), (Object)(declarationDescriptor != null ? DescriptorUtilsKt.getModule((DeclarationDescriptor)declarationDescriptor) : null))) break block8;
            }
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)whenExpression), (int)0, (int)2, null), "When expression contains redundant `else` case.", null, null, 24, null));
        }
        super.visitWhenExpression(whenExpression);
    }

    public RedundantElseInWhen(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("RedundantElseInWhen", Severity.Warning, "Check for redundant `else` case in `when` expression when used as statement.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ RedundantElseInWhen(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public RedundantElseInWhen() {
        this(null, 1, null);
    }
}

