/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.bugs;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtUnaryExpression;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lio/gitlab/arturbosch/detekt/rules/bugs/UnnecessaryNotNullOperator;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitUnaryExpression", "", "expression", "Lorg/jetbrains/kotlin/psi/KtUnaryExpression;", "detekt-rules-errorprone"})
public final class UnnecessaryNotNullOperator
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitUnaryExpression(@NotNull KtUnaryExpression expression) {
        boolean bl;
        block5: {
            Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
            super.visitUnaryExpression(expression);
            if (Intrinsics.areEqual((Object)this.getBindingContext(), (Object)BindingContext.EMPTY)) {
                return;
            }
            Diagnostics diagnostics = this.getBindingContext().getDiagnostics();
            KtSimpleNameExpression ktSimpleNameExpression = expression.getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"expression.operationReference");
            Collection compilerReports = diagnostics.forElement((PsiElement)ktSimpleNameExpression);
            Iterable $this$any$iv = compilerReports;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Diagnostic it = (Diagnostic)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getFactory(), (Object)Errors.UNNECESSARY_NOT_NULL_ASSERTION)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), expression.getText() + " contains an unnecessary " + "not-null (!!) operators", null, null, 24, null));
        }
    }

    public UnnecessaryNotNullOperator(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("UnnecessaryNotNullOperator", Severity.Defect, "Unnecessary not-null unary operator (!!) detected.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ UnnecessaryNotNullOperator(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public UnnecessaryNotNullOperator() {
        this(null, 1, null);
    }
}

