/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtConstructor;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\f\u0010%\u001a\u00020\u001b*\u00020#H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000fR!\u0010\u001a\u001a\u00020\u001b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0011\u0012\u0004\b\u001c\u0010\r\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006&"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ConstructorParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "Lkotlin/text/Regex;", "getParameterPattern$annotations", "()V", "getParameterPattern", "()Lkotlin/text/Regex;", "parameterPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "privateParameterPattern", "getPrivateParameterPattern$annotations", "getPrivateParameterPattern", "privateParameterPattern$delegate", "excludeClassPattern", "getExcludeClassPattern$annotations", "getExcludeClassPattern", "excludeClassPattern$delegate", "ignoreOverridden", "", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "()Z", "ignoreOverridden$delegate", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitPrivateParameter", "isConstructor", "detekt-rules-naming"})
public final class ConstructorParameterNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty parameterPattern$delegate;
    @NotNull
    private final ReadOnlyProperty privateParameterPattern$delegate;
    @NotNull
    private final ReadOnlyProperty excludeClassPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;

    public ConstructorParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Constructor parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", ConstructorParameterNaming::parameterPattern_delegate$lambda$0);
        this.privateParameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", ConstructorParameterNaming::privateParameterPattern_delegate$lambda$1);
        this.excludeClassPattern$delegate = ConfigPropertyKt.config((Object)"$^", ConstructorParameterNaming::excludeClassPattern_delegate$lambda$2);
        this.ignoreOverridden$delegate = ConfigPropertyKt.config((Object)true);
    }

    public /* synthetic */ ConstructorParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return (Regex)this.parameterPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    private final Regex getPrivateParameterPattern() {
        return (Regex)this.privateParameterPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivateParameterPattern$annotations() {
    }

    private final Regex getExcludeClassPattern() {
        return (Regex)this.excludeClassPattern$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores variables in classes which match this regex")
    private static /* synthetic */ void getExcludeClassPattern$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignores constructor properties that have the override modifier")
    @Deprecated(message="This configuration is ignored and will be removed in the future")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (!this.isConstructor(parameter) || ExcludeClassKt.isContainingExcludedClassOrObject((KtDeclaration)parameter, this.getExcludeClassPattern()) || KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)parameter))) {
            return;
        }
        String identifier = parameter.getName();
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)parameter))) {
            this.visitPrivateParameter(parameter);
        } else {
            boolean bl;
            String string = identifier;
            if (string != null) {
                CharSequence charSequence = string;
                bl = !this.getParameterPattern().matches(charSequence);
            } else {
                bl = false;
            }
            if (bl) {
                this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Constructor parameter names should match the pattern: " + this.getParameterPattern(), null, null, 24, null));
            }
        }
    }

    private final void visitPrivateParameter(KtParameter parameter) {
        boolean bl;
        String identifier;
        String string = identifier = parameter.getName();
        if (string != null) {
            CharSequence charSequence = string;
            bl = !this.getPrivateParameterPattern().matches(charSequence);
        } else {
            bl = false;
        }
        if (bl) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Constructor private parameter names should match the pattern: " + this.getPrivateParameterPattern(), null, null, 24, null));
        }
    }

    private final boolean isConstructor(KtParameter $this$isConstructor) {
        return $this$isConstructor.getOwnerFunction() instanceof KtConstructor;
    }

    private static final Regex parameterPattern_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    private static final Regex privateParameterPattern_delegate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    private static final Regex excludeClassPattern_delegate$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    public ConstructorParameterNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "parameterPattern", "getParameterPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "privateParameterPattern", "getPrivateParameterPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "excludeClassPattern", "getExcludeClassPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ConstructorParameterNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

