/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import io.gitlab.arturbosch.detekt.rules.naming.FunctionParameterNaming;
import io.gitlab.arturbosch.detekt.rules.naming.util.ExcludeClassKt;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.reflect.KProperty0;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtDeclarationWithBody;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\f\u0010$\u001a\u00020\u0017*\u00020#H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001b\u0010\u0011\u0012\u0004\b\u0018\u0010\r\u001a\u0004\b\u0019\u0010\u001aR!\u0010\u001c\u001a\u00020\u00178BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0011\u0012\u0004\b\u001d\u0010\r\u001a\u0004\b\u001e\u0010\u001a\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/FunctionParameterNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "parameterPattern", "Lkotlin/text/Regex;", "getParameterPattern$annotations", "()V", "getParameterPattern", "()Lkotlin/text/Regex;", "parameterPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "excludeClassPattern", "getExcludeClassPattern$annotations", "getExcludeClassPattern", "excludeClassPattern$delegate", "ignoreOverriddenFunctions", "", "getIgnoreOverriddenFunctions$annotations", "getIgnoreOverriddenFunctions", "()Z", "ignoreOverriddenFunctions$delegate", "ignoreOverridden", "getIgnoreOverridden$annotations", "getIgnoreOverridden", "ignoreOverridden$delegate", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "isParameterInFunction", "detekt-rules-naming"})
public final class FunctionParameterNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty parameterPattern$delegate;
    @NotNull
    private final ReadOnlyProperty excludeClassPattern$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverriddenFunctions$delegate;
    @NotNull
    private final ReadOnlyProperty ignoreOverridden$delegate;

    public FunctionParameterNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Function parameter names should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.parameterPattern$delegate = ConfigPropertyKt.config((Object)"[a-z][A-Za-z0-9]*", (Function1)parameterPattern.2.INSTANCE);
        this.excludeClassPattern$delegate = ConfigPropertyKt.config((Object)"$^", (Function1)excludeClassPattern.2.INSTANCE);
        this.ignoreOverriddenFunctions$delegate = ConfigPropertyKt.config((Object)true);
        this.ignoreOverridden$delegate = ConfigPropertyKt.configWithFallback((KProperty0)((KProperty0)new PropertyReference0Impl((Object)this){

            public Object get() {
                return FunctionParameterNaming.access$getIgnoreOverriddenFunctions((FunctionParameterNaming)((Object)this.receiver));
            }
        }), (Object)true);
    }

    public /* synthetic */ FunctionParameterNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getParameterPattern() {
        return (Regex)this.parameterPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getParameterPattern$annotations() {
    }

    private final Regex getExcludeClassPattern() {
        return (Regex)this.excludeClassPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="ignores variables in classes which match this regex")
    private static /* synthetic */ void getExcludeClassPattern$annotations() {
    }

    private final boolean getIgnoreOverriddenFunctions() {
        return (Boolean)this.ignoreOverriddenFunctions$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="ignores overridden functions with parameters not matching the pattern")
    @Deprecated(message="Use `ignoreOverridden` instead")
    private static /* synthetic */ void getIgnoreOverriddenFunctions$annotations() {
    }

    private final boolean getIgnoreOverridden() {
        return (Boolean)this.ignoreOverridden$delegate.getValue((Object)this, $$delegatedProperties[3]);
    }

    @Configuration(description="ignores overridden functions with parameters not matching the pattern")
    @Deprecated(message="This configuration is ignored and will be removed in the future")
    private static /* synthetic */ void getIgnoreOverridden$annotations() {
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        if (this.isParameterInFunction(parameter)) {
            return;
        }
        KtDeclarationWithBody ktDeclarationWithBody = parameter.getOwnerFunction();
        boolean bl = ktDeclarationWithBody != null ? KtModifierListKt.isOverride((KtModifierListOwner)((KtModifierListOwner)ktDeclarationWithBody)) : false;
        if (bl) {
            return;
        }
        String identifier = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)parameter));
        CharSequence charSequence = identifier;
        if (!this.getParameterPattern().matches(charSequence)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)parameter), (int)0, (int)2, null), "Function parameter names should match the pattern: " + this.getParameterPattern(), null, null, 24, null));
        }
    }

    private final boolean isParameterInFunction(KtParameter $this$isParameterInFunction) {
        PsiElement psiElement;
        return $this$isParameterInFunction.getNameAsSafeName().isSpecial() || ((psiElement = $this$isParameterInFunction.getNameIdentifier()) != null && (psiElement = psiElement.getParent()) != null ? psiElement.getClass() : null) == null || !($this$isParameterInFunction.getOwnerFunction() instanceof KtNamedFunction) || ExcludeClassKt.isContainingExcludedClass((KtDeclaration)$this$isParameterInFunction, this.getExcludeClassPattern());
    }

    public FunctionParameterNaming() {
        this(null, 1, null);
    }

    public static final /* synthetic */ boolean access$getIgnoreOverriddenFunctions(FunctionParameterNaming $this) {
        return $this.getIgnoreOverriddenFunctions();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, "parameterPattern", "getParameterPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, "excludeClassPattern", "getExcludeClassPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, "ignoreOverriddenFunctions", "getIgnoreOverriddenFunctions()Z", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(FunctionParameterNaming.class, "ignoreOverridden", "getIgnoreOverridden()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

