/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.RequiresTypeResolution;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.TypeUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBinding;
import org.jetbrains.kotlin.resolve.typeBinding.TypeBindingKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeKt;
import org.jetbrains.kotlin.types.TypeProjection;

@RequiresTypeResolution
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001e\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\b\u0018\u00010\u00182\u0006\u0010\u000f\u001a\u00020\u0016H\u0002J\f\u0010\u001a\u001a\u00020\u001b*\u00020\u0019H\u0002J \u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\bH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006 "}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/NonBooleanPropertyPrefixedWithIs;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "booleanTypes", "", "Lorg/jetbrains/kotlin/name/FqName;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "visitParameter", "", "parameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "validateDeclaration", "declaration", "Lorg/jetbrains/kotlin/psi/KtCallableDeclaration;", "getType", "Lkotlin/Pair;", "Lorg/jetbrains/kotlin/types/KotlinType;", "isBoolean", "", "report", "name", "", "typeFqName", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nNonBooleanPropertyPrefixedWithIs.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonBooleanPropertyPrefixedWithIs.kt\nio/gitlab/arturbosch/detekt/rules/naming/NonBooleanPropertyPrefixedWithIs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,98:1\n1557#2:99\n1628#2,3:100\n*S KotlinDebug\n*F\n+ 1 NonBooleanPropertyPrefixedWithIs.kt\nio/gitlab/arturbosch/detekt/rules/naming/NonBooleanPropertyPrefixedWithIs\n*L\n41#1:99\n41#1:100,3\n*E\n"})
public final class NonBooleanPropertyPrefixedWithIs
extends Rule {
    @NotNull
    private final Set<FqName> booleanTypes;
    @NotNull
    private final Issue issue;

    /*
     * WARNING - void declaration
     */
    public NonBooleanPropertyPrefixedWithIs(@NotNull Config config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        Object object = new String[]{"kotlin.Boolean", "java.lang.Boolean", "java.util.concurrent.atomic.AtomicBoolean"};
        object = CollectionsKt.listOf((Object[])object);
        NonBooleanPropertyPrefixedWithIs nonBooleanPropertyPrefixedWithIs = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new FqName((String)it));
        }
        nonBooleanPropertyPrefixedWithIs.booleanTypes = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Warning, "Only boolean property names can start with `is` prefix.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ NonBooleanPropertyPrefixedWithIs(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitParameter(@NotNull KtParameter parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        super.visitParameter(parameter);
        if (parameter.hasValOrVar()) {
            this.validateDeclaration((KtCallableDeclaration)parameter);
        }
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        super.visitProperty(property);
        this.validateDeclaration((KtCallableDeclaration)property);
    }

    private final void validateDeclaration(KtCallableDeclaration declaration) {
        String name = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)declaration));
        if (StringsKt.startsWith$default((String)name, (String)"is", (boolean)false, (int)2, null)) {
            Character c = StringsKt.getOrNull((CharSequence)name, (int)2);
            boolean bl = c != null ? Character.isUpperCase(c.charValue()) : false;
            if (bl) {
                Pair<KotlinType, FqName> pair = this.getType(declaration);
                if (pair == null) {
                    return;
                }
                Pair<KotlinType, FqName> pair2 = pair;
                KotlinType type = (KotlinType)pair2.component1();
                FqName typeFqName = (FqName)pair2.component2();
                if (!this.isBoolean(type)) {
                    this.report(declaration, name, typeFqName);
                }
            }
        }
    }

    private final Pair<KotlinType, FqName> getType(KtCallableDeclaration parameter) {
        TypeBinding typeBinding = TypeBindingKt.createTypeBindingForReturnType((KtCallableDeclaration)parameter, (BindingContext)this.getBindingContext());
        if (typeBinding == null || (typeBinding = typeBinding.getType()) == null) {
            return null;
        }
        TypeBinding type = typeBinding;
        if (KotlinTypeKt.isError((KotlinType)type)) {
            return null;
        }
        FqName fqName = TypeUtilsKt.fqNameOrNull((KotlinType)type);
        if (fqName == null) {
            return null;
        }
        FqName fqName2 = fqName;
        return TuplesKt.to((Object)type, (Object)fqName2);
    }

    private final boolean isBoolean(KotlinType $this$isBoolean) {
        TypeProjection typeProjection;
        return FunctionTypesKt.isFunctionOrKFunctionTypeWithAnySuspendability((KotlinType)$this$isBoolean) ? CollectionsKt.contains((Iterable)this.booleanTypes, (typeProjection = (TypeProjection)CollectionsKt.lastOrNull((List)$this$isBoolean.getArguments())) != null && (typeProjection = typeProjection.getType()) != null ? TypeUtilsKt.fqNameOrNull((KotlinType)typeProjection) : null) : CollectionsKt.contains((Iterable)this.booleanTypes, (Object)TypeUtilsKt.fqNameOrNull((KotlinType)$this$isBoolean));
    }

    private final void report(KtCallableDeclaration declaration, String name, FqName typeFqName) {
        String string = typeFqName.shortName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String typeName = string;
        CodeSmell codeSmell = new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)declaration), (int)0, (int)2, null), "Non-boolean properties shouldn't start with 'is' prefix. Actual type of " + name + ": " + typeName, null, null, 24, null);
        this.report((Finding)codeSmell);
    }

    public NonBooleanPropertyPrefixedWithIs() {
        this(null, 1, null);
    }
}

