/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.naming;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.ConfigPropertyKt;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.internal.Configuration;
import io.gitlab.arturbosch.detekt.rules.IdentifierNameKt;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtClassOrObject;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\f\u0010\u001e\u001a\u00020\u001f*\u00020\u001dH\u0002J\u0010\u0010 \u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010\"\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020$H\u0002R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR!\u0010\n\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000fR!\u0010\u0012\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u0012\u0004\b\u0013\u0010\r\u001a\u0004\b\u0014\u0010\u000fR!\u0010\u0016\u001a\u00020\u000b8BX\u0083\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u0011\u0012\u0004\b\u0017\u0010\r\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006%"}, d2={"Lio/gitlab/arturbosch/detekt/rules/naming/ObjectPropertyNaming;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "<init>", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "constantPattern", "Lkotlin/text/Regex;", "getConstantPattern$annotations", "()V", "getConstantPattern", "()Lkotlin/text/Regex;", "constantPattern$delegate", "Lkotlin/properties/ReadOnlyProperty;", "propertyPattern", "getPropertyPattern$annotations", "getPropertyPattern", "propertyPattern$delegate", "privatePropertyPattern", "getPrivatePropertyPattern$annotations", "getPrivatePropertyPattern", "privatePropertyPattern$delegate", "visitProperty", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isPropertyOfObjectDeclaration", "", "handleConstant", "handleProperty", "report", "message", "", "detekt-rules-naming"})
@SourceDebugExtension(value={"SMAP\nObjectPropertyNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectPropertyNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/ObjectPropertyNaming\n+ 2 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,84:1\n146#2:85\n*S KotlinDebug\n*F\n+ 1 ObjectPropertyNaming.kt\nio/gitlab/arturbosch/detekt/rules/naming/ObjectPropertyNaming\n*L\n56#1:85\n*E\n"})
public final class ObjectPropertyNaming
extends Rule {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Issue issue;
    @NotNull
    private final ReadOnlyProperty constantPattern$delegate;
    @NotNull
    private final ReadOnlyProperty propertyPattern$delegate;
    @NotNull
    private final ReadOnlyProperty privatePropertyPattern$delegate;

    public ObjectPropertyNaming(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleName(...)");
        this.issue = new Issue(string, Severity.Style, "Property names inside objects should follow the naming convention set in the projects configuration.", Debt.Companion.getFIVE_MINS());
        this.constantPattern$delegate = ConfigPropertyKt.config((Object)"[A-Za-z][_A-Za-z0-9]*", ObjectPropertyNaming::constantPattern_delegate$lambda$0);
        this.propertyPattern$delegate = ConfigPropertyKt.config((Object)"[A-Za-z][_A-Za-z0-9]*", ObjectPropertyNaming::propertyPattern_delegate$lambda$1);
        this.privatePropertyPattern$delegate = ConfigPropertyKt.config((Object)"(_)?[A-Za-z][_A-Za-z0-9]*", ObjectPropertyNaming::privatePropertyPattern_delegate$lambda$2);
    }

    public /* synthetic */ ObjectPropertyNaming(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    private final Regex getConstantPattern() {
        return (Regex)this.constantPattern$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getConstantPattern$annotations() {
    }

    private final Regex getPropertyPattern() {
        return (Regex)this.propertyPattern$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPropertyPattern$annotations() {
    }

    private final Regex getPrivatePropertyPattern() {
        return (Regex)this.privatePropertyPattern$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @Configuration(description="naming pattern")
    private static /* synthetic */ void getPrivatePropertyPattern$annotations() {
    }

    public void visitProperty(@NotNull KtProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (!this.isPropertyOfObjectDeclaration(property)) {
            return;
        }
        if (KtModifierListKt.isConstant((KtModifierListOwner)((KtModifierListOwner)property))) {
            this.handleConstant(property);
        } else {
            this.handleProperty(property);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPropertyOfObjectDeclaration(KtProperty $this$isPropertyOfObjectDeclaration) {
        if (!$this$isPropertyOfObjectDeclaration.isMember()) return false;
        PsiElement $this$getNonStrictParentOfType$iv = (PsiElement)$this$isPropertyOfObjectDeclaration;
        boolean $i$f$getNonStrictParentOfType = false;
        if (!(PsiTreeUtil.getParentOfType((PsiElement)$this$getNonStrictParentOfType$iv, KtClassOrObject.class, (boolean)false) instanceof KtObjectDeclaration)) return false;
        return true;
    }

    private final void handleConstant(KtProperty property) {
        CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
        if (!this.getConstantPattern().matches(charSequence)) {
            this.report(property, "Object constant names should match the pattern: " + this.getConstantPattern());
        }
    }

    private final void handleProperty(KtProperty property) {
        if (KtPsiUtilKt.isPrivate((KtModifierListOwner)((KtModifierListOwner)property))) {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            if (!this.getPrivatePropertyPattern().matches(charSequence)) {
                this.report(property, "Private object property names should match the pattern: " + this.getPrivatePropertyPattern());
            }
        } else {
            CharSequence charSequence = IdentifierNameKt.identifierName((KtNamedDeclaration)((KtNamedDeclaration)property));
            if (!this.getPropertyPattern().matches(charSequence)) {
                this.report(property, "Object property names should match the pattern: " + this.getPropertyPattern());
            }
        }
    }

    private final void report(KtProperty property, String message) {
        this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.atName((KtNamedDeclaration)property), message, null, null, 24, null));
    }

    private static final Regex constantPattern_delegate$lambda$0(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    private static final Regex propertyPattern_delegate$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    private static final Regex privatePropertyPattern_delegate$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new Regex(it);
    }

    public ObjectPropertyNaming() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ObjectPropertyNaming.class, "constantPattern", "getConstantPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ObjectPropertyNaming.class, "propertyPattern", "getPropertyPattern()Lkotlin/text/Regex;", 0))), Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ObjectPropertyNaming.class, "privatePropertyPattern", "getPrivatePropertyPattern()Lkotlin/text/Regex;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

