/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.complexity;

import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Metric;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.api.ThresholdRule;
import io.gitlab.arturbosch.detekt.api.ThresholdedCodeSmell;
import io.gitlab.arturbosch.detekt.rules.LinesOfCodeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequenceScope;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.utils.addToStdlib.AddToStdlibKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u00142\u0006\u0010\u0015\u001a\u00020\tH\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0014J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\tH\u0016R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00050\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0005`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\t0\u0011j\b\u0012\u0004\u0012\u00020\t`\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongMethod;", "Lio/gitlab/arturbosch/detekt/api/ThresholdRule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "threshold", "", "(Lio/gitlab/arturbosch/detekt/api/Config;I)V", "functionToLinesCache", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "Lkotlin/collections/HashMap;", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "nestedFunctionTracking", "Ljava/util/IdentityHashMap;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "findAllNestedFunctions", "Lkotlin/sequences/Sequence;", "startFunction", "postVisit", "", "root", "Lorg/jetbrains/kotlin/psi/KtFile;", "preVisit", "visitNamedFunction", "function", "Companion", "detekt-rules"})
public final class LongMethod
extends ThresholdRule {
    @NotNull
    private final Issue issue;
    private final HashMap<KtNamedFunction, Integer> functionToLinesCache;
    private final IdentityHashMap<KtNamedFunction, HashSet<KtNamedFunction>> nestedFunctionTracking;
    public static final int DEFAULT_THRESHOLD_METHOD_LENGTH = 60;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    protected void preVisit(@NotNull KtFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.functionToLinesCache.clear();
        this.nestedFunctionTracking.clear();
    }

    /*
     * WARNING - void declaration
     */
    protected void postVisit(@NotNull KtFile root) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        Map map = this.functionToLinesCache;
        boolean bl = false;
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            void function;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            map = (KtNamedFunction)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            int lines = ((Number)entry2.getValue()).intValue();
            if (lines < this.getThreshold()) continue;
            Issue issue = this.getIssue();
            PsiElement psiElement = function.getNameIdentifier();
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)psiElement, (String)"function.nameIdentifier!!");
            this.report((Finding)new ThresholdedCodeSmell(issue, Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)psiElement, (int)0, (int)2, null), new Metric("SIZE", lines, this.getThreshold(), false, 0, 24, null), "The function " + function.getNameAsSafeName() + " is too long (" + lines + "). " + "The maximum length is " + this.getThreshold() + '.', null, 16, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        block5: {
            void $this$fold$iv;
            boolean bl;
            Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
            int lines = LinesOfCodeKt.linesOfCode$default((KtElement)function, null, 1, null);
            ((Map)this.functionToLinesCache).put(function, lines);
            Sequence<KtNamedFunction> $this$getStrictParentOfType$iv = (Sequence<KtNamedFunction>)function;
            boolean $i$f$getStrictParentOfType = false;
            KtNamedFunction ktNamedFunction = (KtNamedFunction)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtNamedFunction.class, (boolean)true);
            if (ktNamedFunction != null) {
                Object object;
                $this$getStrictParentOfType$iv = ktNamedFunction;
                $i$f$getStrictParentOfType = false;
                bl = false;
                Sequence<KtNamedFunction> it = $this$getStrictParentOfType$iv;
                boolean bl2 = false;
                Map $this$getOrPut$iv = this.nestedFunctionTracking;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(it);
                if (value$iv == null) {
                    boolean bl3 = false;
                    HashSet answer$iv = new HashSet();
                    $this$getOrPut$iv.put(it, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((HashSet)object).add(function);
            }
            super.visitNamedFunction(function);
            $this$getStrictParentOfType$iv = this.findAllNestedFunctions(function);
            Integer initial$iv = 0;
            boolean $i$f$fold = false;
            Integer accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void next;
                KtNamedFunction $i$f$getOrPut = (KtNamedFunction)element$iv;
                int acc = ((Number)accumulator$iv).intValue();
                boolean bl4 = false;
                Integer n = this.functionToLinesCache.get(next);
                if (n == null) {
                    n = 0;
                }
                accumulator$iv = acc + n;
            }
            Integer n = accumulator$iv;
            boolean bl5 = false;
            bl = false;
            int it = ((Number)n).intValue();
            boolean bl6 = false;
            Integer n2 = it > 0 ? n : null;
            if (n2 == null) break block5;
            n = n2;
            bl5 = false;
            bl = false;
            it = ((Number)n).intValue();
            boolean bl7 = false;
            ((Map)this.functionToLinesCache).put(function, lines - it);
        }
    }

    private final Sequence<KtNamedFunction> findAllNestedFunctions(KtNamedFunction startFunction) {
        return SequencesKt.sequence((Function2)((Function2)new Function2<SequenceScope<? super KtNamedFunction>, Continuation<? super Unit>, Object>(this, startFunction, null){
            private SequenceScope p$;
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ LongMethod this$0;
            final /* synthetic */ KtNamedFunction $startFunction;

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object $result) {
                var22_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                block0 : switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        $this$sequence = this.p$;
                        nestedFunctions = (HashSet)LongMethod.access$getNestedFunctionTracking$p(this.this$0).get(this.$startFunction);
lbl7:
                        // 2 sources

                        while (true) {
                            var4_5 = nestedFunctions;
                            var5_6 = false;
                            var6_8 = false;
                            if (var4_5 == null || var4_5.isEmpty() != false) break block0;
                            this.L$0 = $this$sequence;
                            this.L$1 = nestedFunctions;
                            this.label = 1;
                            v0 = $this$sequence.yieldAll((Iterable)nestedFunctions, (Continuation)this);
                            if (v0 == var22_2) {
                                return var22_2;
                            }
                            ** GOTO lbl24
                            break;
                        }
                    }
                    case 1: {
                        nestedFunctions = (HashSet)this.L$1;
                        $this$sequence = (SequenceScope)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl24:
                        // 2 sources

                        $this$mapNotNull$iv = nestedFunctions;
                        $i$f$mapNotNull = false;
                        var6_7 = $this$mapNotNull$iv;
                        destination$iv$iv = new ArrayList<E>();
                        $i$f$mapNotNullTo = false;
                        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        $i$f$forEach = false;
                        var11_13 = $this$forEach$iv$iv$iv.iterator();
                        while (var11_13.hasNext()) {
                            element$iv$iv = element$iv$iv$iv = var11_13.next();
                            $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = false;
                            it = (KtNamedFunction)element$iv$iv;
                            $i$a$-mapNotNull-LongMethod$findAllNestedFunctions$1$1 = false;
                            if ((HashSet)LongMethod.access$getNestedFunctionTracking$p(this.this$0).get(it) == null) continue;
                            var18_20 = false;
                            var19_21 = false;
                            it$iv$iv = var17_19;
                            $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        nestedFunctions = (HashSet)AddToStdlibKt.flattenTo((Iterable)((List)destination$iv$iv), (Collection)new HashSet<E>());
                        ** continue;
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }
            {
                this.this$0 = longMethod;
                this.$startFunction = ktNamedFunction;
                super(2, continuation);
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                Function2<SequenceScope<? super KtNamedFunction>, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                SequenceScope sequenceScope = function2.p$ = (SequenceScope)value;
                return function2;
            }

            public final Object invoke(Object object, Object object2) {
                return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    public LongMethod(@NotNull Config config, int threshold) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, threshold);
        this.issue = new Issue("LongMethod", Severity.Maintainability, "One method should have one responsibility. Long methods tend to handle many things at once. Prefer smaller methods to make them easier to understand.", Debt.Companion.getTWENTY_MINS());
        this.functionToLinesCache = new HashMap();
        this.nestedFunctionTracking = new IdentityHashMap();
    }

    public /* synthetic */ LongMethod(Config config, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        if ((n2 & 2) != 0) {
            n = 60;
        }
        this(config, n);
    }

    public LongMethod() {
        this(null, 0, 3, null);
    }

    public static final /* synthetic */ IdentityHashMap access$getNestedFunctionTracking$p(LongMethod $this) {
        return $this.nestedFunctionTracking;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/complexity/LongMethod$Companion;", "", "()V", "DEFAULT_THRESHOLD_METHOD_LENGTH", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

