/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesIfStatements;
import io.gitlab.arturbosch.detekt.rules.style.optional.MandatoryBracesIfStatements$hasNewLine$;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiWhiteSpace;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0013"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/MandatoryBracesIfStatements;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "hasNewLine", "", "element", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "isNotBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "isNotBlockOrIfExpression", "visitIfExpression", "", "detekt-rules"})
public final class MandatoryBracesIfStatements
extends Rule {
    @NotNull
    private final Issue issue;

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitIfExpression(@NotNull KtIfExpression expression) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        if (this.isNotBlockExpression(expression) && this.hasNewLine(expression.getRightParenthesis())) {
            KtExpression ktExpression = expression.getThen();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)(ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression), (int)0, (int)2, null), "Multi-line if statement was found that does not have braces. These should be added to improve readability.", null, null, 24, null));
        }
        if (this.isNotBlockOrIfExpression(expression) && this.hasNewLine(expression.getElseKeyword())) {
            KtExpression ktExpression = expression.getElse();
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)(ktExpression != null ? (PsiElement)ktExpression : (PsiElement)expression), (int)0, (int)2, null), "Multi-line else statement was found that does not have braces.These should be added to improve readability", null, null, 24, null));
        }
        super.visitIfExpression(expression);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasNewLine(PsiElement element) {
        Object v5;
        block2: {
            PsiElement psiElement = element;
            PsiElement psiElement2 = psiElement;
            if (psiElement == null) return false;
            Sequence sequence = PsiUtilsKt.siblings((PsiElement)psiElement2, (boolean)true, (boolean)false);
            psiElement2 = sequence;
            if (sequence == null) return false;
            Sequence sequence2 = SequencesKt.takeWhile((Sequence)psiElement2, (Function1)hasNewLine.1.INSTANCE);
            psiElement2 = sequence2;
            if (sequence2 == null) return false;
            PsiElement $this$filterIsInstance$iv = psiElement2;
            boolean $i$f$filterIsInstance = false;
            Sequence sequence3 = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)hasNewLine$$inlined$filterIsInstance$1.INSTANCE);
            if (sequence3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.sequences.Sequence<R>");
            }
            psiElement2 = sequence3;
            if (sequence3 == null) return false;
            PsiElement $this$firstOrNull$iv = psiElement2;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PsiWhiteSpace it = (PsiWhiteSpace)element$iv;
                boolean bl = false;
                if (!it.textContains('\n')) continue;
                v5 = element$iv;
                break block2;
            }
            v5 = null;
        }
        PsiWhiteSpace psiWhiteSpace = v5;
        if (psiWhiteSpace == null) return false;
        return true;
    }

    private final boolean isNotBlockExpression(KtIfExpression expression) {
        return !(expression.getThen() instanceof KtBlockExpression);
    }

    private final boolean isNotBlockOrIfExpression(KtIfExpression expression) {
        return expression.getElse() != null && !(expression.getElse() instanceof KtIfExpression) && !(expression.getElse() instanceof KtBlockExpression);
    }

    public MandatoryBracesIfStatements(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        this.issue = new Issue("MandatoryBracesIfStatements", Severity.Style, "Multi-line if statement was found that does not have braces. These should be added to improve readability.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ MandatoryBracesIfStatements(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public MandatoryBracesIfStatements() {
        this(null, 1, null);
    }
}

