/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.arturbosch.detekt.rules.style.optional;

import io.gitlab.arturbosch.detekt.api.CodeSmell;
import io.gitlab.arturbosch.detekt.api.Config;
import io.gitlab.arturbosch.detekt.api.Debt;
import io.gitlab.arturbosch.detekt.api.Entity;
import io.gitlab.arturbosch.detekt.api.Finding;
import io.gitlab.arturbosch.detekt.api.Issue;
import io.gitlab.arturbosch.detekt.api.Rule;
import io.gitlab.arturbosch.detekt.api.Severity;
import io.gitlab.arturbosch.detekt.rules.KtModifierListKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTypeReference;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0017"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit;", "Lio/gitlab/arturbosch/detekt/api/Rule;", "config", "Lio/gitlab/arturbosch/detekt/api/Config;", "(Lio/gitlab/arturbosch/detekt/api/Config;)V", "issue", "Lio/gitlab/arturbosch/detekt/api/Issue;", "getIssue", "()Lio/gitlab/arturbosch/detekt/api/Issue;", "checkFunctionWithExplicitReturnType", "", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "checkFunctionWithInferredReturnType", "createMessage", "", "isInInterface", "", "visitBlockExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "visitNamedFunction", "Companion", "detekt-rules"})
public final class OptionalUnit
extends Rule {
    @NotNull
    private final Issue issue;
    private static final String UNIT = "Unit";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public Issue getIssue() {
        return this.issue;
    }

    public void visitNamedFunction(@NotNull KtNamedFunction function) {
        Intrinsics.checkParameterIsNotNull((Object)function, (String)"function");
        if (function.getFunKeyword() == null) {
            return;
        }
        if (this.isInInterface(function)) {
            return;
        }
        if (function.hasDeclaredReturnType() && function.getColon() != null) {
            this.checkFunctionWithExplicitReturnType(function);
        } else if (!KtModifierListKt.isOverride((KtModifierListOwner)function)) {
            this.checkFunctionWithInferredReturnType(function);
        }
        super.visitNamedFunction(function);
    }

    /*
     * WARNING - void declaration
     */
    public void visitBlockExpression(@NotNull KtBlockExpression expression) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        List list = expression.getStatements();
        Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"expression.statements");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtExpression it = (KtExpression)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((KtNameReferenceExpression)it).getText(), (Object)UNIT))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$onEach$iv = (List)destination$iv$iv;
        boolean $i$f$onEach = false;
        iterable = $this$onEach$iv;
        boolean bl = false;
        boolean bl2 = false;
        Iterable $this$apply$iv = iterable;
        boolean bl3 = false;
        for (Object element$iv : $this$apply$iv) {
            KtExpression it = (KtExpression)element$iv;
            boolean bl4 = false;
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)expression), (int)0, (int)2, null), "A single Unit expression is unnecessary and can safely be removed", null, null, 24, null));
        }
        super.visitBlockExpression(expression);
    }

    private final void checkFunctionWithExplicitReturnType(KtNamedFunction function) {
        String typeElementText;
        KtTypeReference typeReference = function.getTypeReference();
        KtTypeReference ktTypeReference = typeReference;
        String string = ktTypeReference != null && (ktTypeReference = ktTypeReference.getTypeElement()) != null ? ktTypeReference.getText() : (typeElementText = null);
        if (Intrinsics.areEqual((Object)typeElementText, (Object)UNIT)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)typeReference), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final void checkFunctionWithInferredReturnType(KtNamedFunction function) {
        KtNameReferenceExpression referenceExpression;
        KtExpression ktExpression = function.getBodyExpression();
        if (!(ktExpression instanceof KtNameReferenceExpression)) {
            ktExpression = null;
        }
        if ((referenceExpression = (KtNameReferenceExpression)ktExpression) != null && Intrinsics.areEqual((Object)referenceExpression.getText(), (Object)UNIT)) {
            this.report((Finding)new CodeSmell(this.getIssue(), Entity.Companion.from$default((Entity.Companion)Entity.Companion, (PsiElement)((PsiElement)referenceExpression), (int)0, (int)2, null), this.createMessage(function), null, null, 24, null));
        }
    }

    private final boolean isInInterface(KtNamedFunction function) {
        PsiElement $this$getStrictParentOfType$iv = (PsiElement)function;
        boolean $i$f$getStrictParentOfType = false;
        KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)$this$getStrictParentOfType$iv, KtClass.class, (boolean)true);
        return ktClass != null ? ktClass.isInterface() : false;
    }

    private final String createMessage(KtNamedFunction function) {
        return "The function " + function.getName() + ' ' + "defines a return type of Unit. This is unnecessary and can safely be removed.";
    }

    public OptionalUnit(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        super(config, null, 2, null);
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"javaClass.simpleName");
        this.issue = new Issue(string, Severity.Style, "Return type of 'Unit' is unnecessary and can be safely removed.", Debt.Companion.getFIVE_MINS());
    }

    public /* synthetic */ OptionalUnit(Config config, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            config = Config.Companion.getEmpty();
        }
        this(config);
    }

    public OptionalUnit() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lio/gitlab/arturbosch/detekt/rules/style/optional/OptionalUnit$Companion;", "", "()V", "UNIT", "", "detekt-rules"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

