/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.instrumentation.api.internal;

import io.opentelemetry.javaagent.shaded.instrumentation.api.config.Config;
import io.opentelemetry.javaagent.slf4j.Logger;
import io.opentelemetry.javaagent.slf4j.LoggerFactory;
import java.util.function.Predicate;

public final class InstrumentedTaskClasses {
    private static final Logger logger = LoggerFactory.getLogger(Config.class);
    private static final String AGENT_CLASSLOADER_NAME = "io.opentelemetry.javaagent.bootstrap.AgentClassLoader";
    private static final ClassValue<Boolean> INSTRUMENTED_TASK_CLASS = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> taskClass) {
            if (ignoredTaskClassesPredicate.test(taskClass.getName())) {
                return false;
            }
            ClassLoader taskClassLoader = taskClass.getClassLoader();
            if (taskClassLoader != null && InstrumentedTaskClasses.AGENT_CLASSLOADER_NAME.equals(taskClassLoader.getClass().getName())) {
                return false;
            }
            return true;
        }
    };
    private static volatile Predicate<String> ignoredTaskClassesPredicate;

    public static void setIgnoredTaskClassesPredicate(Predicate<String> ignoredTasksTriePredicate) {
        if (ignoredTaskClassesPredicate != null) {
            logger.warn("Ignored task classes were already set earlier; returning.");
            return;
        }
        ignoredTaskClassesPredicate = ignoredTasksTriePredicate;
    }

    public static boolean canInstrumentTaskClass(Class<?> taskClass) {
        return INSTRUMENTED_TASK_CLASS.get(taskClass);
    }

    private InstrumentedTaskClasses() {
    }
}

