/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging;

import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.messaging.MessageOperation;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import javax.annotation.Nullable;

public abstract class MessagingAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    public static final String TEMP_DESTINATION_NAME = "(temporary)";

    @Override
    public final void onStart(AttributesBuilder attributes, REQUEST request) {
        this.set(attributes, SemanticAttributes.MESSAGING_SYSTEM, this.system(request));
        this.set(attributes, SemanticAttributes.MESSAGING_DESTINATION_KIND, this.destinationKind(request));
        boolean isTemporaryDestination = this.temporaryDestination(request);
        if (isTemporaryDestination) {
            this.set(attributes, SemanticAttributes.MESSAGING_TEMP_DESTINATION, true);
            this.set(attributes, SemanticAttributes.MESSAGING_DESTINATION, TEMP_DESTINATION_NAME);
        } else {
            this.set(attributes, SemanticAttributes.MESSAGING_DESTINATION, this.destination(request));
        }
        this.set(attributes, SemanticAttributes.MESSAGING_PROTOCOL, this.protocol(request));
        this.set(attributes, SemanticAttributes.MESSAGING_PROTOCOL_VERSION, this.protocolVersion(request));
        this.set(attributes, SemanticAttributes.MESSAGING_URL, this.url(request));
        this.set(attributes, SemanticAttributes.MESSAGING_CONVERSATION_ID, this.conversationId(request));
        this.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_SIZE_BYTES, this.messagePayloadSize(request));
        this.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_PAYLOAD_COMPRESSED_SIZE_BYTES, this.messagePayloadCompressedSize(request));
        MessageOperation operation = this.operation();
        if (operation == MessageOperation.RECEIVE || operation == MessageOperation.PROCESS) {
            this.set(attributes, SemanticAttributes.MESSAGING_OPERATION, operation.operationName());
        }
    }

    @Override
    public final void onEnd(AttributesBuilder attributes, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.set(attributes, SemanticAttributes.MESSAGING_MESSAGE_ID, this.messageId(request, response));
    }

    public abstract MessageOperation operation();

    @Nullable
    protected abstract String system(REQUEST var1);

    @Nullable
    protected abstract String destinationKind(REQUEST var1);

    @Nullable
    protected abstract String destination(REQUEST var1);

    protected abstract boolean temporaryDestination(REQUEST var1);

    @Nullable
    protected abstract String protocol(REQUEST var1);

    @Nullable
    protected abstract String protocolVersion(REQUEST var1);

    @Nullable
    protected abstract String url(REQUEST var1);

    @Nullable
    protected abstract String conversationId(REQUEST var1);

    @Nullable
    protected abstract Long messagePayloadSize(REQUEST var1);

    @Nullable
    protected abstract Long messagePayloadCompressedSize(REQUEST var1);

    @Nullable
    protected abstract String messageId(REQUEST var1, @Nullable RESPONSE var2);
}

